/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.syslog;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.netmgt.alarmd.api.Destination;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogFilter;

@XmlRootElement(name="syslog-destination")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SyslogDestination
implements Destination {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="destination-name", required=true)
    private String m_destinationName;
    @XmlElement(name="host", defaultValue="localhost", required=false)
    private String m_host = "localhost";
    @XmlElement(name="port", defaultValue="514", required=false)
    private int m_port = 514;
    @XmlElement(name="ip-protocol", defaultValue="udp", required=false)
    private SyslogProtocol m_protocol = SyslogProtocol.UDP;
    @XmlElement(name="facility", defaultValue="USER", required=false)
    private SyslogFacility m_facility = SyslogFacility.USER;
    @XmlElement(name="char-set", defaultValue="UTF-8", required=false)
    private String m_charSet = "UTF-8";
    @XmlElement(name="max-message-length", defaultValue="1024", required=false)
    private int m_maxMessageLength = 1024;
    @XmlElement(name="send-local-name", defaultValue="true", required=false)
    private boolean m_sendLocalName = true;
    @XmlElement(name="send-local-time", defaultValue="true", required=false)
    private boolean m_sendLocalTime = true;
    @XmlElement(name="truncate-message", defaultValue="false", required=false)
    private boolean m_truncateMessage = false;
    @XmlElement(name="first-occurrence-only", defaultValue="false", required=false)
    private boolean m_firstOccurrenceOnly = false;
    @XmlElement(name="filter", required=false)
    private List<SyslogFilter> m_filters;

    public SyslogDestination() {
    }

    public SyslogDestination(String name, SyslogProtocol protocol, SyslogFacility facility) {
        this.m_destinationName = name;
        this.m_protocol = protocol;
        this.m_facility = facility;
    }

    public String getName() {
        return this.m_destinationName;
    }

    public void setName(String name) {
        this.m_destinationName = name;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String m_host) {
        this.m_host = m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int m_port) {
        this.m_port = m_port;
    }

    public SyslogProtocol getProtocol() {
        return this.m_protocol;
    }

    public void setProtocol(SyslogProtocol m_protocol) {
        this.m_protocol = m_protocol;
    }

    public SyslogFacility getFacility() {
        return this.m_facility;
    }

    public String getCharSet() {
        return this.m_charSet;
    }

    public void setCharSet(String charSet) {
        this.m_charSet = charSet;
    }

    public int getMaxMessageLength() {
        return this.m_maxMessageLength;
    }

    public void setMaxMessageLength(int maxMessageLength) {
        this.m_maxMessageLength = maxMessageLength;
    }

    public boolean isSendLocalName() {
        return this.m_sendLocalName;
    }

    public void setSendLocalName(boolean sendLocalName) {
        this.m_sendLocalName = sendLocalName;
    }

    public boolean isSendLocalTime() {
        return this.m_sendLocalTime;
    }

    public void setSendLocalTime(boolean sendLocalTime) {
        this.m_sendLocalTime = sendLocalTime;
    }

    public boolean isTruncateMessage() {
        return this.m_truncateMessage;
    }

    public void setTruncateMessage(boolean truncateMessage) {
        this.m_truncateMessage = truncateMessage;
    }

    public boolean isFirstOccurrenceOnly() {
        return this.m_firstOccurrenceOnly;
    }

    public void setFirstOccurrenceOnly(boolean firstOccurrenceOnly) {
        this.m_firstOccurrenceOnly = firstOccurrenceOnly;
    }

    public List<SyslogFilter> getFilters() {
        return this.m_filters;
    }

    public void setFilters(List<SyslogFilter> filters) {
        this.m_filters = filters;
    }

    public boolean passFilter(NorthboundAlarm alarm) {
        if (this.m_filters != null) {
            for (SyslogFilter filter : this.m_filters) {
                if (!filter.passFilter(alarm)) continue;
                return true;
            }
        }
        return false;
    }

    public String getCustomMessageFormat(NorthboundAlarm alarm) {
        if (this.m_filters != null) {
            for (SyslogFilter filter : this.m_filters) {
                if (filter.getMessageFormat() == null || !filter.passFilter(alarm)) continue;
                return filter.getMessageFormat();
            }
        }
        return null;
    }

    @XmlType
    @XmlEnum(value=String.class)
    public static enum SyslogFacility {
        KERN("KERN"),
        USER("USER"),
        MAIL("MAIL"),
        DAEMON("DAEMON"),
        AUTH("AUTH"),
        SYSLOG("SYSLOG"),
        LPR("LPR"),
        NEWS("NEWS"),
        UUCP("UUCP"),
        CRON("CRON"),
        AUTHPRIV("AUTHPRIV"),
        FTP("FTP"),
        LOCAL0("LOCAL0"),
        LOCAL1("LOCAL1"),
        LOCAL2("LOCAL2"),
        LOCAL3("LOCAL3"),
        LOCAL4("LOCAL4"),
        LOCAL5("LOCAL5"),
        LOCAL6("LOCAL6"),
        LOCAL7("LOCAL7");

        private String m_id;

        private SyslogFacility(String facility) {
            this.m_id = facility;
        }

        public String getId() {
            return this.m_id;
        }
    }

    @XmlType
    @XmlEnum(value=String.class)
    public static enum SyslogProtocol {
        UDP("udp"),
        TCP("tcp");

        private String m_id;

        private SyslogProtocol(String id) {
            this.m_id = id;
        }

        public String getId() {
            return this.m_id;
        }
    }
}

