/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.syslog;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogDestination;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogNorthbounderConfig;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsSeverity;
import org.productivity.java.syslog4j.Syslog;
import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.net.tcp.TCPNetSyslogConfig;
import org.productivity.java.syslog4j.impl.net.udp.UDPNetSyslogConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SyslogNorthbounder
extends AbstractNorthbounder
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogNorthbounder.class);
    private static final String NBI_NAME = "SyslogNBI";
    private SyslogNorthbounderConfig m_config;
    private NodeDao m_nodeDao;
    private SyslogDestination m_destination;

    public SyslogNorthbounder(SyslogNorthbounderConfig config, SyslogDestination destination) {
        super("SyslogNBI:" + destination);
        this.m_config = config;
        this.m_destination = destination;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.m_config == null) {
            LOG.info("Syslog Northbounder is currently disabled, rejecting alarm.");
            String msg = "Syslog forwarding configuration is not initialized.";
            IllegalStateException e = new IllegalStateException(msg);
            LOG.error(msg, (Throwable)e);
            throw e;
        }
        this.createNorthboundInstance();
        this.setNaglesDelay(this.m_config.getNaglesDelay().intValue());
        this.setMaxBatchSize(this.m_config.getBatchSize());
        this.setMaxPreservedAlarms(this.m_config.getQueueSize());
    }

    public boolean accepts(NorthboundAlarm alarm) {
        if (!this.m_config.isEnabled().booleanValue()) {
            return false;
        }
        LOG.debug("Validating UEI of alarm: {}", (Object)alarm.getUei());
        if (this.getConfig().getUeis() == null || this.getConfig().getUeis().contains(alarm.getUei())) {
            LOG.debug("UEI: {}, accepted.", (Object)alarm.getUei());
            return true;
        }
        LOG.debug("UEI: {}, rejected.", (Object)alarm.getUei());
        return false;
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        SyslogIF instance;
        if (alarms == null) {
            String errorMsg = "No alarms in alarms list for syslog forwarding.";
            IllegalStateException e = new IllegalStateException(errorMsg);
            LOG.error(errorMsg, (Throwable)e);
            throw e;
        }
        LOG.info("Forwarding {} alarms to destination:{}", (Object)alarms.size(), (Object)this.m_destination.getName());
        HashMap<Integer, Map<String, Object>> alarmMappings = new HashMap<Integer, Map<String, Object>>();
        try {
            instance = Syslog.getInstance((String)this.m_destination.getName());
        }
        catch (SyslogRuntimeException e) {
            LOG.error("Could not find Syslog instance for destination: '{}': {}", (Object)this.m_destination.getName(), (Object)e);
            throw e;
        }
        for (NorthboundAlarm alarm : alarms) {
            Integer count = alarm.getCount();
            if (count > 1 && this.m_destination.isFirstOccurrenceOnly()) {
                LOG.debug("Destination {} is configured for new alarm instances only.  Alarm has count of {}.", (Object)this.m_destination.getName(), (Object)count);
                continue;
            }
            LOG.debug("Creating formatted log message for alarm: {}.", (Object)alarm.getId());
            Map<String, Object> mapping = null;
            try {
                if (alarmMappings != null) {
                    mapping = (Map<String, Object>)alarmMappings.get(alarm.getId());
                }
                if (mapping == null) {
                    mapping = this.createMapping(alarmMappings, alarm);
                }
                LOG.debug("Making substitutions for tokens in message format for alarm: {}.", (Object)alarm.getId());
                String syslogMessage = PropertiesUtils.substitute((String)this.m_config.getMessageFormat(), (Map[])new Map[]{mapping});
                LOG.debug("Determining LOG_LEVEL for alarm: {}", (Object)alarm.getId());
                int level = this.determineLogLevel(alarm.getSeverity());
                LOG.debug("Forwarding alarm: {} via syslog to destination: {}", (Object)alarm.getId(), (Object)this.m_destination.getName());
                instance.log(level, syslogMessage);
            }
            catch (Exception e1) {
                LOG.error("Caught exception sending to destination: '{}': {}", (Object)this.m_destination.getName(), (Object)e1);
            }
        }
    }

    private Map<String, Object> createMapping(Map<Integer, Map<String, Object>> alarmMappings, NorthboundAlarm alarm) {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("ackUser", alarm.getAckUser());
        mapping.put("appDn", alarm.getAppDn());
        mapping.put("logMsg", alarm.getLogMsg());
        mapping.put("objectInstance", alarm.getObjectInstance());
        mapping.put("objectType", alarm.getObjectType());
        mapping.put("ossKey", alarm.getOssKey());
        mapping.put("ossState", alarm.getOssState());
        mapping.put("ticketId", alarm.getTicketId());
        mapping.put("alarmUei", alarm.getUei());
        mapping.put("ackTime", this.nullSafeToString(alarm.getAckTime(), ""));
        NorthboundAlarm.AlarmType alarmType = alarm.getAlarmType() == null ? NorthboundAlarm.AlarmType.NOTIFICATION : alarm.getAlarmType();
        mapping.put("alarmType", alarmType.name());
        String count = alarm.getCount() == null ? "1" : alarm.getCount().toString();
        mapping.put("count", count);
        mapping.put("firstOccurrence", this.nullSafeToString(alarm.getFirstOccurrence(), ""));
        mapping.put("alarmId", alarm.getId().toString());
        mapping.put("ipAddr", this.nullSafeToString(alarm.getIpAddr(), ""));
        mapping.put("lastOccurrence", this.nullSafeToString(alarm.getLastOccurrence(), ""));
        if (alarm.getNodeId() != null) {
            mapping.put("nodeId", alarm.getNodeId().toString());
            String nodeLabel = this.m_nodeDao.getLabelForId(alarm.getNodeId());
            mapping.put("nodeLabel", nodeLabel == null ? "?" : nodeLabel);
        } else {
            mapping.put("nodeId", "");
            mapping.put("nodeLabel", "");
        }
        String poller = alarm.getPoller() == null ? "localhost" : alarm.getPoller().getId();
        mapping.put("distPoller", poller);
        String service = alarm.getService() == null ? "" : alarm.getService();
        mapping.put("ifService", service);
        mapping.put("severity", this.nullSafeToString(alarm.getSeverity(), ""));
        mapping.put("ticketState", this.nullSafeToString(alarm.getTicketState(), ""));
        mapping.put("x733AlarmType", alarm.getX733Type());
        try {
            mapping.put("x733ProbableCause", this.nullSafeToString(NorthboundAlarm.x733ProbableCause.get((int)alarm.getX733Cause()), ""));
        }
        catch (Exception e) {
            LOG.info("Exception caught setting X733 Cause: {}", (Object)alarm.getX733Cause(), (Object)e);
            mapping.put("x733ProbableCause", "");
        }
        this.buildParmMappings(alarm, mapping);
        alarmMappings.put(alarm.getId(), mapping);
        return mapping;
    }

    protected void buildParmMappings(NorthboundAlarm alarm, Map<String, Object> mapping) {
        String[] parmArray;
        LinkedList<EventParm<String>> parmCollection = new LinkedList<EventParm<String>>();
        String parms = alarm.getEventParms();
        if (parms == null) {
            return;
        }
        char separator = ';';
        for (String string : parmArray = StringUtils.split((String)parms, (char)separator)) {
            char nameValueDelim = '=';
            String[] nameValueArray = StringUtils.split((String)string, (char)nameValueDelim);
            String parmName = nameValueArray[0];
            String parmValue = StringUtils.split((String)nameValueArray[1], (char)'(')[0];
            EventParm<String> eventParm = new EventParm<String>(parmName, parmValue);
            parmCollection.add(eventParm);
        }
        for (int i = 0; i < parmCollection.size(); ++i) {
            EventParm parm = (EventParm)parmCollection.get(i);
            Integer parmOffset = i + 1;
            mapping.put("parm[name-#" + parmOffset + "]", parm.getParmName());
            mapping.put("parm[#" + parmOffset + "]", parm.getParmValue().toString());
            mapping.put("parm[" + parm.getParmName() + "]", parm.getParmValue().toString());
        }
    }

    private String nullSafeToString(Object obj, String defaultString) {
        if (obj != null) {
            defaultString = obj.toString();
        }
        return defaultString;
    }

    private void createNorthboundInstance() throws SyslogRuntimeException {
        LOG.info("Creating Syslog Northbound Instance:{}", (Object)this.m_destination.getName());
        String instName = this.m_destination.getName();
        int facility = this.convertFacility(this.m_destination.getFacility());
        SyslogDestination.SyslogProtocol protocol = this.m_destination.getProtocol();
        SyslogConfigIF instanceConfiguration = this.createConfig(this.m_destination, protocol, facility);
        instanceConfiguration.setIdent("OpenNMS");
        instanceConfiguration.setCharSet(this.m_destination.getCharSet());
        instanceConfiguration.setMaxMessageLength(this.m_destination.getMaxMessageLength());
        instanceConfiguration.setSendLocalName(this.m_destination.isSendLocalName());
        instanceConfiguration.setSendLocalTimestamp(this.m_destination.isSendLocalTime());
        instanceConfiguration.setTruncateMessage(this.m_destination.isTruncateMessage());
        instanceConfiguration.setUseStructuredData(false);
        try {
            Syslog.createInstance((String)instName, (SyslogConfigIF)instanceConfiguration);
        }
        catch (SyslogRuntimeException e) {
            LOG.error("Could not create northbound instance, '{}': {}", (Object)instName, (Object)e);
            throw e;
        }
    }

    private SyslogConfigIF createConfig(SyslogDestination dest, SyslogDestination.SyslogProtocol protocol, int fac) {
        UDPNetSyslogConfig config;
        switch (protocol) {
            case UDP: {
                config = new UDPNetSyslogConfig(fac, dest.getHost(), dest.getPort());
                break;
            }
            case TCP: {
                config = new TCPNetSyslogConfig(fac, dest.getHost(), dest.getPort());
                break;
            }
            default: {
                config = new UDPNetSyslogConfig(fac, "localhost", 514);
            }
        }
        return config;
    }

    private int convertFacility(SyslogDestination.SyslogFacility facility) {
        int fac;
        switch (facility) {
            case KERN: {
                fac = 0;
                break;
            }
            case USER: {
                fac = 8;
                break;
            }
            case MAIL: {
                fac = 16;
                break;
            }
            case DAEMON: {
                fac = 24;
                break;
            }
            case AUTH: {
                fac = 32;
                break;
            }
            case SYSLOG: {
                fac = 40;
                break;
            }
            case LPR: {
                fac = 48;
                break;
            }
            case NEWS: {
                fac = 56;
                break;
            }
            case UUCP: {
                fac = 64;
                break;
            }
            case CRON: {
                fac = 72;
                break;
            }
            case AUTHPRIV: {
                fac = 80;
                break;
            }
            case FTP: {
                fac = 88;
                break;
            }
            case LOCAL0: {
                fac = 128;
                break;
            }
            case LOCAL1: {
                fac = 136;
                break;
            }
            case LOCAL2: {
                fac = 144;
                break;
            }
            case LOCAL3: {
                fac = 152;
                break;
            }
            case LOCAL4: {
                fac = 160;
                break;
            }
            case LOCAL5: {
                fac = 168;
                break;
            }
            case LOCAL6: {
                fac = 176;
                break;
            }
            case LOCAL7: {
                fac = 184;
                break;
            }
            default: {
                fac = 8;
            }
        }
        return fac;
    }

    private int determineLogLevel(OnmsSeverity severity) {
        int level;
        switch (severity) {
            case CRITICAL: {
                level = 2;
                break;
            }
            case MAJOR: {
                level = 3;
                break;
            }
            case MINOR: {
                level = 3;
                break;
            }
            case WARNING: {
                level = 4;
                break;
            }
            case NORMAL: {
                level = 5;
                break;
            }
            case CLEARED: {
                level = 6;
                break;
            }
            case INDETERMINATE: {
                level = 7;
                break;
            }
            default: {
                level = 4;
            }
        }
        return level;
    }

    public SyslogNorthbounderConfig getConfig() {
        if (this.m_config == null) {
            String errMsg = "Syslog Northbounder configuration is not set.";
            LOG.error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        return this.m_config;
    }

    public void setConfig(SyslogNorthbounderConfig config) {
        if (config == null) {
            String string = "Syslog Northbounder configuration cannot be set null";
            LOG.error(string);
            throw new IllegalStateException(string);
        }
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    protected static class EventParm<T> {
        private String m_parmName;
        private T m_parmValue;

        EventParm(String name, T value) {
            this.m_parmName = name;
            this.m_parmValue = value;
        }

        public String getParmName() {
            return this.m_parmName;
        }

        public T getParmValue() {
            return this.m_parmValue;
        }
    }
}

