/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.syslog;

import java.util.List;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.netmgt.alarmd.api.Northbounder;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogDestination;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogNorthbounderConfig;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogNorthbounderConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class SyslogNorthbounderManager
implements InitializingBean,
DisposableBean {
    @Autowired
    private ServiceRegistry m_serviceRegistry;
    @Autowired
    private SyslogNorthbounderConfigDao m_configDao;
    @Autowired
    private NodeDao m_nodeDao;
    private Registration m_registration = null;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_nodeDao);
        Assert.notNull((Object)((Object)this.m_configDao));
        Assert.notNull((Object)this.m_serviceRegistry);
        SyslogNorthbounderConfig config = this.m_configDao.getConfig();
        List<SyslogDestination> destinations = config.getDestinations();
        for (SyslogDestination syslogDestination : destinations) {
            SyslogNorthbounder nbi = new SyslogNorthbounder(config, syslogDestination);
            nbi.setNodeDao(this.m_nodeDao);
            nbi.afterPropertiesSet();
            this.m_registration = this.m_serviceRegistry.register((Object)nbi, new Class[]{Northbounder.class});
        }
    }

    public void destroy() throws Exception {
        this.m_registration.unregister();
    }
}

