/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.snmptrap;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.VarbindType;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@XmlRootElement(name="varbind")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class VarbindMapping {
    public static final Logger LOG = LoggerFactory.getLogger(VarbindMapping.class);
    @XmlAttribute(name="name", required=false)
    private String m_name;
    @XmlElement(name="oid", required=true)
    private String m_oid;
    @XmlElement(name="type", required=true)
    private VarbindType m_type;
    @XmlElement(name="value", required=true)
    private String m_value;
    @XmlElement(name="max", required=false)
    private int m_max;
    @XmlElement(name="instance", required=false)
    private String m_instance;

    public String getName() {
        return this.m_name;
    }

    public String getOid() {
        return this.m_oid;
    }

    public VarbindType getType() {
        return this.m_type;
    }

    public String getValue() {
        return this.m_value;
    }

    public String getInstance() {
        return this.m_instance;
    }

    public int getMax() {
        return this.m_max;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setOid(String oid) {
        this.m_oid = oid;
    }

    public void setType(VarbindType type) {
        this.m_type = type;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public void setInstance(String instance) {
        this.m_instance = instance;
    }

    public void setMax(int max) {
        this.m_max = max;
    }

    public Parm getParameter(NorthboundAlarm alarm) {
        String oid = this.getOid();
        String instance = this.evaluate(this.getInstance(), alarm);
        if (instance != null) {
            oid = oid + (this.isNumber(instance) ? "." + instance : this.encode(instance));
        }
        String value = this.evaluate(this.getValue(), alarm);
        if (this.getType().equals((Object)VarbindType.TYPE_SNMP_OCTET_STRING) && this.getMax() > 0 && this.getType().value().length() > this.getMax()) {
            value = value.substring(0, this.getMax());
        }
        Parm parm = new Parm(oid, value);
        parm.getValue().setType(this.getType().value());
        return parm;
    }

    private String encode(String parameterInstance) {
        int snLength = parameterInstance.length();
        StringBuffer oidBuf = new StringBuffer();
        oidBuf.append(".").append(Integer.toString(snLength));
        for (byte thisByte : parameterInstance.getBytes()) {
            oidBuf.append(".").append(Byte.toString(thisByte));
        }
        return oidBuf.toString();
    }

    private boolean isNumber(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private String evaluate(String expression, NorthboundAlarm alarm) {
        if (expression == null) {
            return null;
        }
        try {
            StandardEvaluationContext context = new StandardEvaluationContext((Object)alarm);
            SpelExpressionParser parser = new SpelExpressionParser();
            Expression exp = parser.parseExpression(expression);
            return (String)exp.getValue((EvaluationContext)context, String.class);
        }
        catch (Exception e) {
            LOG.warn("Can't evaluate expression {} for alarm {} because: {}", new Object[]{this.getValue(), alarm.getUei(), e.getMessage()});
            return null;
        }
    }
}

