/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.snmptrap;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.alarmd.api.Destination;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapConfig;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapException;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapMapping;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapMappingGroup;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="snmp-trap-sink")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SnmpTrapSink
implements Destination {
    public static final Logger LOG = LoggerFactory.getLogger(SnmpTrapSink.class);
    public static final String MAPPINGS_DIRECTORY_NAME = "snmptrap-northbounder-mappings.d";
    private static final long serialVersionUID = 1L;
    @XmlElement(name="name", required=true)
    private String m_name;
    @XmlElement(name="ip-address", required=true, defaultValue="127.0.0.1")
    private String m_ipAddress;
    @XmlElement(name="port", required=false, defaultValue="162")
    private Integer m_port;
    @XmlElement(name="v1-agent-address", required=false)
    private String m_v1AgentAddress;
    @XmlElement(name="version", required=true, defaultValue="V1")
    private SnmpVersion m_version;
    @XmlElement(name="community", required=false, defaultValue="public")
    private String m_community;
    @XmlElement(name="mapping-group", required=false)
    private List<SnmpTrapMappingGroup> m_mappings = new ArrayList<SnmpTrapMappingGroup>();
    @XmlElement(name="import-mappings", required=false)
    private List<String> m_importMappings = new ArrayList<String>();

    public boolean isFirstOccurrenceOnly() {
        return false;
    }

    public String getName() {
        return this.m_name;
    }

    public String getIpAddress() {
        return this.m_ipAddress == null ? "127.0.0.1" : this.m_ipAddress;
    }

    public Integer getPort() {
        return this.m_port == null ? 162 : this.m_port;
    }

    public String getV1AgentIpAddress() {
        return this.m_v1AgentAddress;
    }

    public SnmpVersion getVersion() {
        return this.m_version == null ? SnmpVersion.V1 : this.m_version;
    }

    public String getCommunity() {
        return this.m_community == null ? "public" : this.m_community;
    }

    public List<SnmpTrapMappingGroup> getMappings() {
        return this.m_mappings;
    }

    public List<String> getImportMappings() {
        return this.m_importMappings;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setIpAddress(String ipAddress) {
        this.m_ipAddress = ipAddress;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public void setV1AgentIpAddress(String v1AgentIpAddress) {
        this.m_v1AgentAddress = v1AgentIpAddress;
    }

    public void setVersion(SnmpVersion version) {
        this.m_version = version;
    }

    public void setCommunity(String community) {
        this.m_community = community;
    }

    public void setMappings(List<SnmpTrapMappingGroup> mappings) {
        this.m_mappings = mappings;
    }

    public void setImportMappings(List<String> importMappings) {
        this.m_importMappings = importMappings;
    }

    public void addMappingGroup(SnmpTrapMappingGroup mappingGroup) {
        int index = -1;
        for (int i = 0; i < this.m_mappings.size(); ++i) {
            if (!this.m_mappings.get(i).getName().equals(mappingGroup.getName())) continue;
            index = i;
            break;
        }
        if (index > -1) {
            this.m_mappings.remove(index);
            this.m_mappings.add(index, mappingGroup);
        } else {
            this.m_mappings.add(mappingGroup);
        }
    }

    public String getMappingGroupFileName(String mappingName) {
        return MAPPINGS_DIRECTORY_NAME + File.separator + mappingName + ".xml";
    }

    public File getMappingGroupFile(String mappingFileName) {
        return new File(ConfigFileConstants.getHome(), "etc" + File.separator + mappingFileName);
    }

    public SnmpTrapMappingGroup getImportMapping(String mappingName) throws Exception {
        String fileName = this.getMappingGroupFileName(mappingName);
        if (this.m_importMappings.contains(fileName)) {
            return (SnmpTrapMappingGroup)JaxbUtils.unmarshal(SnmpTrapMappingGroup.class, (File)this.getMappingGroupFile(fileName));
        }
        return null;
    }

    public void addImportMapping(SnmpTrapMappingGroup mappingGroup) throws Exception {
        String fileName = this.getMappingGroupFileName(mappingGroup.getName());
        if (!this.m_importMappings.contains(fileName)) {
            this.m_importMappings.add(fileName);
        }
        JaxbUtils.marshal((Object)mappingGroup, (Writer)new FileWriter(this.getMappingGroupFile(fileName)));
    }

    public boolean removeImportMapping(String mappingName) {
        String fileName = this.getMappingGroupFileName(mappingName);
        if (this.m_importMappings.contains(fileName)) {
            this.m_importMappings.remove(fileName);
            File file = this.getMappingGroupFile(fileName);
            if (file.exists()) {
                return file.delete();
            }
        }
        return false;
    }

    public boolean accepts(NorthboundAlarm alarm) {
        for (SnmpTrapMappingGroup group : this.m_mappings) {
            if (!group.accepts(alarm)) continue;
            return true;
        }
        return false;
    }

    public SnmpTrapConfig createTrapConfig(NorthboundAlarm alarm) throws SnmpTrapException {
        SnmpTrapMapping mapping = this.getSnmpTrapMapping(alarm);
        if (mapping == null) {
            return null;
        }
        SnmpTrapConfig config = new SnmpTrapConfig();
        try {
            config.setDestinationAddress(InetAddress.getByName(this.m_ipAddress));
        }
        catch (UnknownHostException e) {
            throw new SnmpTrapException("Invalid target IP or FQDN", e);
        }
        config.setDestinationPort(this.m_port);
        config.setVersion(this.m_version);
        config.setCommunity(this.m_community);
        try {
            InetAddress hostAddress = null;
            if (this.m_v1AgentAddress == null) {
                hostAddress = alarm.getIpAddr() == null ? InetAddress.getLocalHost() : InetAddress.getByName(alarm.getIpAddr());
            } else {
                InetAddress.getByName(this.m_v1AgentAddress);
            }
            config.setHostAddress(hostAddress);
        }
        catch (UnknownHostException e) {
            throw new SnmpTrapException("Invalid host address", e);
        }
        config.setEnterpriseId(mapping.getEnterpriseOid());
        config.setGeneric(mapping.getGeneric());
        config.setSpecific(mapping.getSpecific());
        config.setParameters(mapping.getParams(alarm));
        return config;
    }

    public void cleanMappingGroups() {
        Iterator<SnmpTrapMappingGroup> it = this.m_mappings.iterator();
        while (it.hasNext()) {
            SnmpTrapMappingGroup grp = it.next();
            if (this.m_importMappings.contains(this.getMappingGroupFileName(grp.getName()))) {
                LOG.debug("cleanMappingGroups: removing {} from {} as the content is managed through an external file", (Object)grp.getName(), (Object)this.getName());
                it.remove();
                continue;
            }
            LOG.debug("cleanMappingGroups: keeping {} on {}", (Object)grp.getName(), (Object)this.getName());
        }
        LOG.debug("cleanMappingGroups: {} group remains explicitly on {}", (Object)this.m_mappings.size(), (Object)this.getName());
    }

    private SnmpTrapMapping getSnmpTrapMapping(NorthboundAlarm alarm) {
        for (SnmpTrapMappingGroup group : this.m_mappings) {
            if (!group.accepts(alarm)) continue;
            for (SnmpTrapMapping mapping : group.getMappings()) {
                if (!mapping.accepts(alarm)) continue;
                return mapping;
            }
        }
        return null;
    }
}

