/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.snmptrap;

import java.util.List;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapConfig;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapException;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapHelper;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapNorthbounderConfig;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapNorthbounderConfigDao;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SnmpTrapNorthbounder
extends AbstractNorthbounder
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpTrapNorthbounder.class);
    protected static final String NBI_NAME = "SnmpTrapNBI";
    private SnmpTrapNorthbounderConfigDao m_configDao;
    private SnmpTrapSink m_trapSink;
    private SnmpTrapHelper m_trapHelper;
    private boolean initialized = false;

    public SnmpTrapNorthbounder(SnmpTrapNorthbounderConfigDao configDao, String trapSink) {
        super("SnmpTrapNBI:" + trapSink);
        this.m_configDao = configDao;
        this.m_trapSink = configDao.getConfig().getSnmpTrapSink(trapSink);
        this.m_trapHelper = new SnmpTrapHelper();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.m_configDao == null || this.m_trapSink == null) {
            LOG.error("SNMP Trap Northbounder {} is currently disabled because it has not been initialized correctly or there is a problem with the configuration.", (Object)this.getName());
            this.initialized = false;
            return;
        }
        this.setNaglesDelay(this.getConfig().getNaglesDelay().intValue());
        this.setMaxBatchSize(this.getConfig().getBatchSize());
        this.setMaxPreservedAlarms(this.getConfig().getQueueSize());
        this.initialized = true;
    }

    public boolean accepts(NorthboundAlarm alarm) {
        if (!this.initialized) {
            LOG.warn("SNMP Trap Northbounder {} has not been properly initialized, rejecting alarm {}.", (Object)this.getName(), (Object)alarm.getUei());
            return false;
        }
        if (!this.getConfig().isEnabled().booleanValue()) {
            LOG.warn("SNMP Trap Northbounder {} is currently disabled, rejecting alarm {}.", (Object)this.getName(), (Object)alarm.getUei());
            return false;
        }
        LOG.debug("Validating UEI of alarm: {}", (Object)alarm.getUei());
        if (this.getConfig().getUeis() == null || this.getConfig().getUeis().contains(alarm.getUei())) {
            LOG.debug("UEI: {}, accepted.", (Object)alarm.getUei());
            boolean passed = this.m_trapSink.accepts(alarm);
            LOG.debug("Filters: {}, passed ? {}.", (Object)alarm.getUei(), (Object)passed);
            return passed;
        }
        LOG.debug("UEI: {}, rejected.", (Object)alarm.getUei());
        return false;
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        if (alarms == null) {
            String errorMsg = "No alarms in alarms list for SNMP Trap forwarding.";
            NorthbounderException e = new NorthbounderException(errorMsg);
            LOG.error(errorMsg, (Throwable)e);
            throw e;
        }
        LOG.info("Forwarding {} alarms to destination {}", (Object)alarms.size(), (Object)this.m_trapSink.getName());
        for (NorthboundAlarm alarm : alarms) {
            try {
                SnmpTrapConfig config = this.m_trapSink.createTrapConfig(alarm);
                if (config == null) continue;
                this.m_trapHelper.forwardTrap(config);
            }
            catch (SnmpTrapException e) {
                LOG.error("Can't send trap for {}", (Object)alarm, (Object)e);
            }
        }
    }

    public SnmpTrapNorthbounderConfig getConfig() {
        return this.m_configDao.getConfig();
    }
}

