/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.snmptrap;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@XmlRootElement(name="mapping-group")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SnmpTrapMappingGroup {
    public static final Logger LOG = LoggerFactory.getLogger(SnmpTrapMappingGroup.class);
    @XmlAttribute(name="name", required=false)
    private String m_name;
    @XmlElement(name="rule", required=true)
    private String m_rule;
    @XmlElement(name="mapping", required=true)
    private List<SnmpTrapMapping> m_mappings = new ArrayList<SnmpTrapMapping>();

    public String getName() {
        return this.m_name;
    }

    public String getRule() {
        return this.m_rule;
    }

    public List<SnmpTrapMapping> getMappings() {
        return this.m_mappings;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setRule(String rule) {
        this.m_rule = rule;
    }

    public void setMappings(List<SnmpTrapMapping> mappings) {
        this.m_mappings = mappings;
    }

    public boolean accepts(NorthboundAlarm alarm) {
        StandardEvaluationContext context = new StandardEvaluationContext((Object)alarm);
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(this.getRule());
        boolean passed = false;
        try {
            passed = (Boolean)exp.getValue((EvaluationContext)context, Boolean.class);
            if (passed) {
                boolean mappingAccepted = false;
                for (SnmpTrapMapping mapping : this.getMappings()) {
                    if (!mapping.accepts(alarm)) continue;
                    mappingAccepted = true;
                    break;
                }
                passed = mappingAccepted;
            }
        }
        catch (Exception e) {
            LOG.warn("mapping group accepts: can't evaluate expression {} for alarm {} because: {}", new Object[]{this.getRule(), alarm.getUei(), e.getMessage()});
        }
        LOG.debug("mapping group accepts: {} ? {}", (Object)this.getRule(), (Object)passed);
        return passed;
    }
}

