/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.snmptrap;

import java.math.BigInteger;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.Base64;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapConfig;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapException;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpVersion;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV2TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV3TrapBuilder;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpTrapHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpTrapHelper.class);
    private static final String SNMP_SYSUPTIME_OID = ".1.3.6.1.2.1.1.3.0";
    private static final String SNMP_TRAP_OID = ".1.3.6.1.6.3.1.1.4.1.0";
    private static final String SNMP_TRAPS = ".1.3.6.1.6.3.1.1.5";
    private static final int ENTERPRISE_SPECIFIC = 6;
    private Map<String, Object> m_factoryMap = new HashMap<String, Object>();

    public SnmpTrapHelper() {
        this.m_factoryMap.put("OctetString", new SnmpOctetStringFactory());
        this.m_factoryMap.put("Int32", new SnmpInt32Factory());
        this.m_factoryMap.put("Null", new SnmpNullFactory());
        this.m_factoryMap.put("ObjectIdentifier", new SnmpObjectIdFactory());
        this.m_factoryMap.put("IpAddress", new SnmpIPAddressFactory());
        this.m_factoryMap.put("TimeTicks", new SnmpTimeTicksFactory());
        this.m_factoryMap.put("Counter32", new SnmpCounter32Factory());
        this.m_factoryMap.put("Gauge32", new SnmpGauge32Factory());
        this.m_factoryMap.put("Opaque", new SnmpOpaqueFactory());
        this.m_factoryMap.put("Counter64", new SnmpCounter64Factory());
    }

    private void addVarBinding(SnmpTrapBuilder trap, String name, String type, String value) throws SnmpTrapException {
        this.addVarBinding(trap, name, type, "text", value);
    }

    private void addVarBinding(SnmpTrapBuilder trap, String name, String type, String encoding, String value) throws SnmpTrapException {
        if (name == null) {
            throw new SnmpTrapException("Name is null");
        }
        VarBindFactory factory = (VarBindFactory)this.m_factoryMap.get(type);
        if (factory == null) {
            throw new SnmpTrapException("Type " + type + " is invalid or not implemented");
        }
        factory.addVarBind(trap, name, encoding, value);
    }

    private void addParameters(SnmpTrapBuilder builder, SnmpTrapConfig trapConfig) throws SnmpTrapException {
        int i = 0;
        for (Parm parm : trapConfig.getParameters()) {
            try {
                Value value = parm.getValue();
                this.addVarBinding(builder, parm.getParmName(), value.getType(), value.getEncoding(), value.getContent());
            }
            catch (SnmpTrapException e) {
                throw new SnmpTrapException(e.getMessage() + " in event parm[" + i + "]");
            }
            finally {
                ++i;
            }
        }
    }

    private void forwardV1Trap(SnmpTrapConfig trapConfig) throws SnmpTrapException {
        SnmpV1TrapBuilder trap = SnmpUtils.getV1TrapBuilder();
        trap.setEnterprise(SnmpObjId.get((String)trapConfig.getEnterpriseId()));
        trap.setAgentAddress(trapConfig.getHostAddress());
        if (trapConfig.hasGeneric()) {
            trap.setGeneric(trapConfig.getGeneric());
        }
        if (trapConfig.hasSpecific()) {
            trap.setSpecific(trapConfig.getSpecific());
        }
        trap.setTimeStamp(System.currentTimeMillis() / 1000L);
        this.addParameters((SnmpTrapBuilder)trap, trapConfig);
        try {
            SnmpAgentConfig config = this.getAgentConfig(trapConfig);
            trap.send(config.getAddress().getHostAddress(), config.getPort(), config.getReadCommunity());
        }
        catch (Throwable e) {
            throw new SnmpTrapException("Failed to send trap " + e.getMessage(), e);
        }
    }

    private void populateTrapBuilder(SnmpTrapBuilder builder, SnmpTrapConfig trapConfig) throws SnmpTrapException {
        this.addVarBinding(builder, SNMP_SYSUPTIME_OID, "TimeTicks", Long.toString(System.currentTimeMillis() / 1000L));
        String oid = trapConfig.getGeneric() == 6 ? trapConfig.getEnterpriseId() + "." + trapConfig.getSpecific() : ".1.3.6.1.6.3.1.1.5." + (trapConfig.getGeneric() + 1);
        this.addVarBinding(builder, SNMP_TRAP_OID, "ObjectIdentifier", oid);
        this.addParameters(builder, trapConfig);
    }

    private void forwardV2Trap(SnmpTrapConfig trapConfig) throws SnmpTrapException {
        SnmpTrapBuilder trap = SnmpUtils.getV2TrapBuilder();
        this.populateTrapBuilder(trap, trapConfig);
        try {
            SnmpAgentConfig config = this.getAgentConfig(trapConfig);
            trap.send(config.getAddress().getHostAddress(), config.getPort(), config.getReadCommunity());
        }
        catch (Throwable e) {
            throw new SnmpTrapException("Failed to send trap " + e.getMessage(), e);
        }
    }

    private void forwardV2Inform(SnmpTrapConfig trapConfig) throws SnmpTrapException {
        SnmpV2TrapBuilder trap = SnmpUtils.getV2InformBuilder();
        this.populateTrapBuilder((SnmpTrapBuilder)trap, trapConfig);
        try {
            SnmpAgentConfig config = this.getAgentConfig(trapConfig);
            trap.sendInform(config.getAddress().getHostName(), config.getPort(), config.getTimeout(), config.getRetries(), config.getReadCommunity());
        }
        catch (Throwable e) {
            throw new SnmpTrapException("Failed to send trap " + e.getMessage(), e);
        }
    }

    private void forwardV3Trap(SnmpTrapConfig trapConfig) throws SnmpTrapException {
        SnmpV3TrapBuilder trap = SnmpUtils.getV3TrapBuilder();
        this.populateTrapBuilder((SnmpTrapBuilder)trap, trapConfig);
        try {
            SnmpAgentConfig config = this.getAgentConfig(trapConfig);
            trap.send(config.getAddress().getHostAddress(), config.getPort(), config.getSecurityLevel(), config.getSecurityName(), config.getAuthPassPhrase(), config.getAuthProtocol(), config.getPrivPassPhrase(), config.getPrivProtocol());
        }
        catch (Throwable e) {
            throw new SnmpTrapException("Failed to send trap " + e.getMessage(), e);
        }
    }

    private void forwardV3Inform(SnmpTrapConfig trapConfig) throws SnmpTrapException {
        SnmpV3TrapBuilder trap = SnmpUtils.getV3InformBuilder();
        this.populateTrapBuilder((SnmpTrapBuilder)trap, trapConfig);
        try {
            SnmpAgentConfig config = this.getAgentConfig(trapConfig);
            trap.sendInform(config.getAddress().getHostAddress(), config.getPort(), config.getTimeout(), config.getTimeout(), config.getSecurityLevel(), config.getSecurityName(), config.getAuthPassPhrase(), config.getAuthProtocol(), config.getPrivPassPhrase(), config.getPrivProtocol());
        }
        catch (Throwable e) {
            throw new SnmpTrapException("Failed to send trap " + e.getMessage(), e);
        }
    }

    private SnmpAgentConfig getAgentConfig(SnmpTrapConfig trapConfig) throws SnmpTrapException {
        SnmpAgentConfig agentConfig = trapConfig.getAgentConfig();
        if (trapConfig.getVersion().intValue() != agentConfig.getVersion()) {
            throw new SnmpTrapException("SNMP Version mismatch for " + trapConfig);
        }
        int estimatedSize = this.getEstimatedPacketSize(trapConfig, agentConfig);
        LOG.info("Sending SNMP{} using {}. The estimated packet size is {} bytes", new Object[]{trapConfig.getVersion().stringValue(), trapConfig, estimatedSize});
        return agentConfig;
    }

    public int getEstimatedPacketSize(SnmpTrapConfig trapConfig, SnmpAgentConfig agentConfig) {
        int preamble = 0;
        if (trapConfig.getVersion().isV1()) {
            preamble = 42;
        }
        if (trapConfig.getVersion().isV2()) {
            preamble = 43;
        }
        if (trapConfig.getVersion().isV3()) {
            preamble = 41;
        }
        int version = 3;
        int community = 0;
        if (trapConfig.getVersion().isV1() || trapConfig.getVersion().isV2()) {
            community = agentConfig.getReadCommunity().length() + 2;
        }
        int overhead = 0;
        if (trapConfig.getVersion().isV1()) {
            overhead = trapConfig.getEnterpriseId().length() + 1;
            overhead += trapConfig.getHostAddress().getHostAddress().length() + 2;
            overhead += 13;
        } else {
            overhead = 21;
            overhead += trapConfig.getEnterpriseId().length() + 14;
            if (trapConfig.getVersion().isV3()) {
                switch (agentConfig.getSecurityLevel()) {
                    case 1: {
                        overhead += 92;
                        break;
                    }
                    case 2: {
                        overhead += 120;
                        break;
                    }
                    case 3: {
                        overhead += 130;
                    }
                }
                overhead += agentConfig.getSecurityName().length() + 2;
            }
        }
        int varbinds = 0;
        for (Parm p : trapConfig.getParameters()) {
            varbinds += p.getParmName().length() + p.getValue().getContent().length() + 4;
        }
        return preamble + version + community + overhead + varbinds;
    }

    public void forwardTrap(SnmpTrapConfig trapConfig) throws SnmpTrapException {
        if (!trapConfig.isValid()) {
            throw new SnmpTrapException("The current configuration is not valid: " + trapConfig);
        }
        SnmpVersion version = trapConfig.getVersion();
        switch (version) {
            case V1: {
                this.forwardV1Trap(trapConfig);
                break;
            }
            case V2c: {
                this.forwardV2Trap(trapConfig);
                break;
            }
            case V3: {
                this.forwardV3Trap(trapConfig);
                break;
            }
            case V2_INFORM: {
                this.forwardV2Inform(trapConfig);
                break;
            }
            case V3_INFORM: {
                this.forwardV3Inform(trapConfig);
                break;
            }
            default: {
                throw new SnmpTrapException("Invalid SNMP version " + (Object)((Object)version));
            }
        }
    }

    private static class SnmpCounter64Factory
    implements VarBindFactory {
        private SnmpCounter64Factory() {
        }

        @Override
        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapException {
            if ("text".equals(encoding)) {
                try {
                    trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getCounter64(new BigInteger(value)));
                }
                catch (IllegalArgumentException e) {
                    throw new SnmpTrapException("Value " + value + "is invalid for SnmpCounter64");
                }
                catch (NullPointerException e) {
                    throw new SnmpTrapException("Value is null for SnmpCounter64");
                }
            } else {
                throw new SnmpTrapException("Encoding " + encoding + "is invalid for SnmpCounter64");
            }
        }
    }

    private static class SnmpOpaqueFactory
    implements VarBindFactory {
        private SnmpOpaqueFactory() {
        }

        @Override
        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapException {
            if (!"base64".equals(encoding)) {
                throw new SnmpTrapException("Encoding " + encoding + "is invalid for SnmpOpaque");
            }
            trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getOpaque(Base64.decodeBase64((char[])value.toCharArray())));
        }
    }

    private static class SnmpGauge32Factory
    implements VarBindFactory {
        private SnmpGauge32Factory() {
        }

        @Override
        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapException {
            if ("text".equals(encoding)) {
                try {
                    trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getGauge32(Long.parseLong(value)));
                }
                catch (NumberFormatException e) {
                    throw new SnmpTrapException("Value " + value + "is invalid for SnmpGauge32");
                }
                catch (IllegalArgumentException e) {
                    throw new SnmpTrapException("Value " + value + "is invalid for SnmpGauge32");
                }
                catch (NullPointerException e) {
                    throw new SnmpTrapException("Value is null for SnmpGauge32");
                }
            } else {
                throw new SnmpTrapException("Encoding " + encoding + "is invalid for SnmpGauge32");
            }
        }
    }

    private static class SnmpCounter32Factory
    implements VarBindFactory {
        private SnmpCounter32Factory() {
        }

        @Override
        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapException {
            if ("text".equals(encoding)) {
                try {
                    trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getCounter32(Long.parseLong(value)));
                }
                catch (NumberFormatException e) {
                    throw new SnmpTrapException("Value " + value + "is invalid for SnmpCounter32");
                }
                catch (IllegalArgumentException e) {
                    throw new SnmpTrapException("Value " + value + "is invalid for SnmpCounter32");
                }
                catch (NullPointerException e) {
                    throw new SnmpTrapException("Value is null for SnmpCounter32");
                }
            } else {
                throw new SnmpTrapException("Encoding " + encoding + "is invalid for SnmpCounter32");
            }
        }
    }

    private static class SnmpTimeTicksFactory
    implements VarBindFactory {
        private SnmpTimeTicksFactory() {
        }

        @Override
        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapException {
            if ("text".equals(encoding)) {
                try {
                    trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getTimeTicks(Long.parseLong(value)));
                }
                catch (NumberFormatException e) {
                    throw new SnmpTrapException("Value " + value + "is invalid for SnmpTimeTicks");
                }
                catch (IllegalArgumentException e) {
                    throw new SnmpTrapException("Value " + value + "is invalid for SnmpTimeTicks");
                }
                catch (NullPointerException e) {
                    throw new SnmpTrapException("Value is null for SnmpTimeTicks");
                }
            } else {
                throw new SnmpTrapException("Encoding " + encoding + "is invalid for SnmpTimeTicks");
            }
        }
    }

    private static class SnmpIPAddressFactory
    implements VarBindFactory {
        private SnmpIPAddressFactory() {
        }

        @Override
        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapException {
            InetAddress addr;
            if ("text".equals(encoding)) {
                addr = InetAddressUtils.addr((String)value);
                if (addr == null) {
                    throw new SnmpTrapException("Value " + value + "is invalid, or host unknown for SnmpIPAddress");
                }
            } else {
                throw new SnmpTrapException("Encoding " + encoding + "is invalid for SnmpIPAddress");
            }
            trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getIpAddress(addr));
        }
    }

    private static class SnmpObjectIdFactory
    implements VarBindFactory {
        private SnmpObjectIdFactory() {
        }

        @Override
        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapException {
            if (!"text".equals(encoding)) {
                throw new SnmpTrapException("Encoding " + encoding + "is invalid for SnmpObjectId");
            }
            trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getObjectId(SnmpObjId.get((String)value)));
        }
    }

    private static class SnmpNullFactory
    implements VarBindFactory {
        private SnmpNullFactory() {
        }

        @Override
        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) {
            trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getNull());
        }
    }

    private static class SnmpInt32Factory
    implements VarBindFactory {
        private SnmpInt32Factory() {
        }

        @Override
        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapException {
            if ("text".equals(encoding)) {
                try {
                    trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getInt32(Integer.parseInt(value)));
                }
                catch (NumberFormatException e) {
                    throw new SnmpTrapException("Value " + value + "is invalid for SnmpInt32");
                }
                catch (NullPointerException e) {
                    throw new SnmpTrapException("Value is null for SnmpInt32");
                }
            } else {
                throw new SnmpTrapException("Encoding " + encoding + "is invalid for SnmpInt32");
            }
        }
    }

    private static class SnmpOctetStringFactory
    implements VarBindFactory {
        private SnmpOctetStringFactory() {
        }

        @Override
        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapException {
            byte[] contents;
            if ("text".equals(encoding)) {
                contents = value.getBytes();
            } else if ("base64".equals(encoding)) {
                contents = Base64.decodeBase64((char[])value.toCharArray());
            } else if ("macAddress".equals(encoding)) {
                contents = InetAddressUtils.macAddressStringToBytes((String)value);
            } else {
                throw new SnmpTrapException("Encoding " + encoding + "is invalid for SnmpOctetString");
            }
            trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getOctetString(contents));
        }
    }

    private static interface VarBindFactory {
        public void addVarBind(SnmpTrapBuilder var1, String var2, String var3, String var4) throws SnmpTrapException;
    }
}

