/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.jms;

import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.Northbounder;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.northbounder.jms.JmsDestination;
import org.opennms.netmgt.alarmd.northbounder.jms.JmsNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.jms.JmsNorthbounderConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class JmsNorthbounderManager
implements InitializingBean,
Northbounder,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(JmsNorthbounderManager.class);
    @Autowired
    private ServiceRegistry m_serviceRegistry;
    @Autowired
    private ConnectionFactory m_jmsNorthbounderConnectionFactory;
    @Autowired
    private JmsNorthbounderConfigDao m_configDao;
    private Map<String, Registration> m_registrations = new HashMap<String, Registration>();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)((Object)this.m_configDao));
        Assert.notNull((Object)this.m_serviceRegistry);
        this.m_registrations.put(this.getName(), this.m_serviceRegistry.register((Object)this, new Class[]{Northbounder.class}));
        this.registerNorthnounders();
    }

    private void registerNorthnounders() throws Exception {
        if (!this.m_configDao.getConfig().isEnabled().booleanValue()) {
            LOG.warn("The JMS NBI is globally disabled, the destinations won't be registered which means all the alarms will be rejected.");
            return;
        }
        for (JmsDestination jmsDestination : this.m_configDao.getConfig().getDestinations()) {
            LOG.info("Registering JMS northbound configuration for destination {}.", (Object)jmsDestination.getName());
            JmsNorthbounder nbi = new JmsNorthbounder(this.m_configDao.getConfig(), this.m_jmsNorthbounderConnectionFactory, jmsDestination);
            nbi.afterPropertiesSet();
            this.m_registrations.put(nbi.getName(), this.m_serviceRegistry.register((Object)nbi, new Class[]{Northbounder.class}));
        }
    }

    public void destroy() throws Exception {
        this.m_registrations.values().forEach(Registration::unregister);
    }

    public void start() throws NorthbounderException {
    }

    public void onAlarm(NorthboundAlarm alarm) throws NorthbounderException {
    }

    public void stop() throws NorthbounderException {
    }

    public String getName() {
        return "JmsNBI";
    }

    public void reloadConfig() throws NorthbounderException {
        LOG.info("Reloading JMS northbound configuration.");
        try {
            this.m_configDao.reload();
            this.m_registrations.forEach((k, v) -> {
                if (k != this.getName()) {
                    v.unregister();
                }
            });
            this.registerNorthnounders();
        }
        catch (Exception e) {
            throw new NorthbounderException("Can't reload the JMS northbound configuration", (Throwable)e);
        }
    }
}

