/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.jms;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.jms.JmsDestination;
import org.opennms.netmgt.alarmd.northbounder.jms.JmsNorthbounderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class JmsNorthbounder
extends AbstractNorthbounder
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(JmsNorthbounder.class);
    public static final String NBI_NAME = "JmsNBI";
    private ConnectionFactory m_jmsNorthbounderConnectionFactory;
    private JmsNorthbounderConfig m_config;
    private JmsDestination m_jmsDestination;
    private JmsTemplate m_template;

    public JmsNorthbounder(JmsNorthbounderConfig config, ConnectionFactory jmsNorthbounderConnectionFactory, JmsDestination destination) {
        super("JmsNBI:" + destination);
        this.m_config = config;
        this.m_jmsNorthbounderConnectionFactory = jmsNorthbounderConnectionFactory;
        this.m_jmsDestination = destination;
    }

    protected JmsNorthbounder() {
        super(NBI_NAME);
    }

    public boolean accepts(NorthboundAlarm alarm) {
        if (!this.m_config.isEnabled().booleanValue()) {
            LOG.warn("JMS Northbounder {} is currently disabled, rejecting alarm {}.", (Object)this.getName(), (Object)alarm.getUei());
            return false;
        }
        LOG.debug("Validating UEI of alarm: {}", (Object)alarm.getUei());
        if (this.getConfig().getUeis() == null || this.getConfig().getUeis().contains(alarm.getUei())) {
            LOG.debug("UEI: {}, accepted.", (Object)alarm.getUei());
            return true;
        }
        LOG.debug("UEI: {}, rejected.", (Object)alarm.getUei());
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)((Object)this));
        LOG.debug("creating new JmsTemplate with connection to {}", (Object)this.m_jmsDestination.getJmsDestination());
        this.m_template = new JmsTemplate(this.m_jmsNorthbounderConnectionFactory);
        if (this.m_jmsDestination.getDestinationType().equals((Object)JmsDestination.DestinationType.TOPIC)) {
            this.m_template.setPubSubDomain(true);
        }
        this.setNaglesDelay(this.m_config.getNaglesDelay().intValue());
        this.setMaxBatchSize(this.m_config.getBatchSize());
        this.setMaxPreservedAlarms(this.m_config.getQueueSize());
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        for (final NorthboundAlarm alarm : alarms) {
            Integer count = alarm.getCount();
            LOG.debug("Does destination {} take only first occurances? {} Is new alarm? Has count of {}.", new Object[]{this.m_jmsDestination.getName(), this.m_jmsDestination.isFirstOccurrenceOnly(), count});
            if (count > 1 && this.m_jmsDestination.isFirstOccurrenceOnly()) {
                LOG.debug("Skipping because not new alarm.");
                continue;
            }
            LOG.debug("Attempting to send a message to {} of type {}", (Object)this.m_jmsDestination.getJmsDestination(), (Object)this.m_jmsDestination.getDestinationType());
            try {
                this.m_template.send(this.m_jmsDestination.getJmsDestination(), new MessageCreator(){

                    public Message createMessage(Session session) throws JMSException {
                        if (JmsNorthbounder.this.m_jmsDestination.isSendAsObjectMessageEnabled()) {
                            return session.createObjectMessage((Serializable)alarm);
                        }
                        return session.createTextMessage(JmsNorthbounder.this.convertAlarmToText(alarm));
                    }
                });
                LOG.debug("Sent message");
            }
            catch (JmsException e) {
                LOG.error("Unable to send alarm to northbound JMS because {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
        }
    }

    private String convertAlarmToText(NorthboundAlarm alarm) {
        String alarmXml = null;
        Map mapping = this.createMapping(alarm);
        LOG.debug("Making substitutions for tokens in message format for alarm: {}.", (Object)alarm.getId());
        alarmXml = this.m_jmsDestination.getMessageFormat() != null ? PropertiesUtils.substitute((String)this.m_jmsDestination.getMessageFormat(), (Map[])new Map[]{mapping}) : PropertiesUtils.substitute((String)this.m_config.getMessageFormat(), (Map[])new Map[]{mapping});
        return alarmXml;
    }

    public JmsDestination getDestination() {
        return this.m_jmsDestination;
    }

    public JmsNorthbounderConfig getConfig() {
        return this.m_config;
    }

    public ConnectionFactory getJmsNorthbounderConnectionFactory() {
        return this.m_jmsNorthbounderConnectionFactory;
    }

    public void setJmsNorthbounderConnectionFactory(ConnectionFactory jmsNorthbounderConnectionFactory) {
        this.m_jmsNorthbounderConnectionFactory = jmsNorthbounderConnectionFactory;
    }
}

