/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.jms;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.opennms.netmgt.alarmd.api.Destination;

@XmlRootElement(name="jms-destination")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JmsDestination
implements Destination {
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private String m_destinationName;
    @XmlElement(name="first-occurence-only", required=false, defaultValue="false")
    private Boolean m_firstOccurrenceOnly;
    @XmlElement(name="send-as-object-message", required=false, defaultValue="false")
    private Boolean m_sendAsObjectMessageEnabled;
    @XmlElement(name="destination-type", required=true, defaultValue="QUEUE")
    private DestinationType m_destinationType;
    @XmlElement(name="jms-destination", required=true)
    private String m_destination;
    @XmlElement(name="message-format", required=false)
    private String m_messageFormat;

    public JmsDestination() {
    }

    public JmsDestination(DestinationType destinationType, String destination) {
        this.m_destinationType = destinationType;
        this.m_destination = destination;
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_destinationType.toString()).append(":").append(this.m_destination);
        this.m_destinationName = sb.toString();
    }

    public JmsDestination(DestinationType destinationType, String destination, boolean firstOccurrenceOnly, boolean sendAsObjectMessage) {
        this(destinationType, destination);
        this.m_firstOccurrenceOnly = firstOccurrenceOnly;
        this.m_sendAsObjectMessageEnabled = sendAsObjectMessage;
    }

    public String getName() {
        return this.m_destinationName;
    }

    public void setName(String destinationName) {
        this.m_destinationName = destinationName;
    }

    public boolean isFirstOccurrenceOnly() {
        return this.m_firstOccurrenceOnly == null ? false : this.m_firstOccurrenceOnly;
    }

    public void setFirstOccurrenceOnly(Boolean firstOccurrenceOnly) {
        this.m_firstOccurrenceOnly = firstOccurrenceOnly;
    }

    public String getJmsDestination() {
        return this.m_destination;
    }

    public boolean isSendAsObjectMessageEnabled() {
        return this.m_sendAsObjectMessageEnabled == null ? false : this.m_sendAsObjectMessageEnabled;
    }

    public DestinationType getDestinationType() {
        return this.m_destinationType == null ? DestinationType.QUEUE : this.m_destinationType;
    }

    public void setDestinationType(DestinationType destinationType) {
        this.m_destinationType = destinationType;
    }

    public String getMessageFormat() {
        return this.m_messageFormat;
    }

    @XmlType(name="destination-type")
    @XmlEnum
    public static enum DestinationType {
        QUEUE,
        TOPIC;


        public String value() {
            return this.name();
        }

        public static DestinationType fromValue(String v) {
            return DestinationType.valueOf(v);
        }
    }
}

