/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.jms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.ConnectionFactory;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.netmgt.alarmd.api.Northbounder;
import org.opennms.netmgt.alarmd.northbounder.jms.JmsDestination;
import org.opennms.netmgt.alarmd.northbounder.jms.JmsNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.jms.JmsNorthbounderConfig;
import org.opennms.netmgt.alarmd.northbounder.jms.JmsNorthbounderConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class JmsNorthbounderManager
implements InitializingBean,
DisposableBean {
    @Autowired
    private ServiceRegistry m_serviceRegistry;
    @Autowired
    private ConnectionFactory m_jmsNorthbounderConnectionFactory;
    @Autowired
    private JmsNorthbounderConfigDao m_configDao;
    @Autowired
    private NodeDao m_nodeDao;
    private Map<String, Registration> m_registrations = new HashMap<String, Registration>();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_nodeDao);
        Assert.notNull((Object)((Object)this.m_configDao));
        Assert.notNull((Object)this.m_serviceRegistry);
        JmsNorthbounderConfig config = this.m_configDao.getConfig();
        List<JmsDestination> destinations = config.getDestinations();
        for (JmsDestination jmsDestination : destinations) {
            JmsNorthbounder nbi = new JmsNorthbounder(config, this.m_jmsNorthbounderConnectionFactory, jmsDestination);
            nbi.setNodeDao(this.m_nodeDao);
            nbi.afterPropertiesSet();
            this.m_registrations.put(nbi.getName(), this.m_serviceRegistry.register((Object)nbi, new Class[]{Northbounder.class}));
        }
    }

    public void destroy() throws Exception {
        for (Registration r : this.m_registrations.values()) {
            r.unregister();
        }
    }
}

