/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.opennms.core.utils.EmptyKeyRelaxedTrustProvider;
import org.opennms.core.utils.HttpResponseRange;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.http.HttpNorthbounderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpNorthbounder
extends AbstractNorthbounder {
    private static final Logger LOG = LoggerFactory.getLogger(HttpNorthbounder.class);
    private HttpNorthbounderConfig m_config;

    protected HttpNorthbounder() {
        super("HttpNorthbounder");
    }

    public boolean accepts(NorthboundAlarm alarm) {
        return this.m_config.getAcceptableUeis() == null || this.m_config.getAcceptableUeis().contains(alarm.getUei());
    }

    public boolean isReady() {
        return true;
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        LOG.info("Forwarding {} alarms", (Object)alarms.size());
        int connectionTimeout = 3000;
        int socketTimeout = 3000;
        Integer retryCount = 3;
        URI uri = this.m_config.getURI();
        HttpClientWrapper clientWrapper = HttpClientWrapper.create().setConnectionTimeout(Integer.valueOf(connectionTimeout)).setSocketTimeout(Integer.valueOf(socketTimeout)).setRetries(retryCount).useBrowserCompatibleCookies();
        if (this.m_config.getVirtualHost() != null && !this.m_config.getVirtualHost().trim().isEmpty()) {
            clientWrapper.setVirtualHost(this.m_config.getVirtualHost());
        }
        if (this.m_config.getUserAgent() != null && !this.m_config.getUserAgent().trim().isEmpty()) {
            clientWrapper.setUserAgent(this.m_config.getUserAgent());
        }
        if ("https".equals(uri.getScheme())) {
            try {
                clientWrapper.useRelaxedSSL("https");
            }
            catch (GeneralSecurityException e) {
                throw new NorthbounderException("Failed to configure HTTP northbounder for relaxed SSL.", (Throwable)e);
            }
        }
        HttpGet method = null;
        if (HttpNorthbounderConfig.HttpMethod.POST == this.m_config.getMethod()) {
            HttpPost postMethod = new HttpPost(uri);
            ArrayList<BasicNameValuePair> postParms = new ArrayList<BasicNameValuePair>();
            BasicNameValuePair p = new BasicNameValuePair("foo", "bar");
            postParms.add(p);
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(postParms, StandardCharsets.UTF_8);
            postMethod.setEntity((HttpEntity)formEntity);
            StringEntity entity = null;
            try {
                entity = new StringEntity("XML HERE");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            postMethod.setEntity((HttpEntity)entity);
            method = postMethod;
        } else if (HttpNorthbounderConfig.HttpMethod.GET == this.m_config.getMethod()) {
            method = new HttpGet(uri);
        }
        HttpVersion httpVersion = HttpNorthbounder.determineHttpVersion(this.m_config.getHttpVersion());
        clientWrapper.setVersion(httpVersion);
        CloseableHttpResponse response = null;
        try {
            response = clientWrapper.execute((HttpUriRequest)method);
            int code = response.getStatusLine().getStatusCode();
            HttpResponseRange range = new HttpResponseRange("200-399");
            if (!range.contains(code)) {
                LOG.debug("response code out of range for uri:{}.  Expected {} but received {}", new Object[]{uri, range, code});
                throw new NorthbounderException("response code out of range for uri:" + uri + ".  Expected " + range + " but received " + code);
            }
            LOG.debug("HTTP Northbounder received response: {}", (Object)response.getStatusLine().getReasonPhrase());
        }
        catch (ClientProtocolException e) {
            throw new NorthbounderException((Throwable)e);
        }
        catch (IOException e) {
            throw new NorthbounderException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)clientWrapper);
        }
    }

    private static HttpVersion determineHttpVersion(String version) {
        HttpVersion httpVersion = null;
        httpVersion = "1.0".equals(version) ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
        return httpVersion;
    }

    public HttpNorthbounderConfig getConfig() {
        return this.m_config;
    }

    public void setConfig(HttpNorthbounderConfig config) {
        this.m_config = config;
    }

    static {
        Security.addProvider((Provider)new EmptyKeyRelaxedTrustProvider());
    }
}

