/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.drools;

import java.util.HashMap;
import java.util.Map;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.Northbounder;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.northbounder.drools.DroolsEngine;
import org.opennms.netmgt.alarmd.northbounder.drools.DroolsNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.drools.DroolsNorthbounderConfigDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class DroolsNorthbounderManager
implements Northbounder,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsNorthbounderManager.class);
    @Autowired
    private ServiceRegistry m_serviceRegistry;
    @Autowired
    private DroolsNorthbounderConfigDao m_configDao;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;
    @Autowired
    private ApplicationContext m_appContext;
    private Map<String, Registration> m_registrations = new HashMap<String, Registration>();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)((Object)this.m_configDao));
        Assert.notNull((Object)this.m_serviceRegistry);
        this.m_registrations.put(this.getName(), this.m_serviceRegistry.register((Object)this, new Class[]{Northbounder.class}));
        this.registerNorthnounders();
    }

    private void registerNorthnounders() throws Exception {
        if (!this.m_configDao.getConfig().isEnabled().booleanValue()) {
            LOG.warn("The Drools NBI is globally disabled, the destinations won't be registered which means all the alarms will be rejected.");
            return;
        }
        for (DroolsEngine engine : this.m_configDao.getConfig().getEngines()) {
            LOG.info("Registering Drools northbound configuration for destination {}.", (Object)engine.getName());
            DroolsNorthbounder nbi = new DroolsNorthbounder(this.m_appContext, this.m_configDao, this.m_eventProxy, engine.getName());
            nbi.afterPropertiesSet();
            this.m_registrations.put(nbi.getName(), this.m_serviceRegistry.register((Object)nbi, new Class[]{Northbounder.class}));
        }
    }

    public void destroy() throws Exception {
        this.m_registrations.values().forEach(Registration::unregister);
    }

    public void start() throws NorthbounderException {
    }

    public boolean isReady() {
        return false;
    }

    public void onAlarm(NorthboundAlarm alarm) throws NorthbounderException {
    }

    public void stop() throws NorthbounderException {
    }

    public String getName() {
        return "DroolsNBI";
    }

    public void reloadConfig() throws NorthbounderException {
        LOG.info("Reloading Drools northbound configuration.");
        try {
            this.m_configDao.reload();
            this.m_registrations.forEach((k, v) -> {
                if (k != this.getName()) {
                    v.unregister();
                }
            });
            this.registerNorthnounders();
        }
        catch (Exception e) {
            throw new NorthbounderException("Can't reload the Drools northbound configuration", (Throwable)e);
        }
    }
}

