/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.drools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.drools.DroolsEngine;
import org.opennms.netmgt.alarmd.northbounder.drools.DroolsNorthbounderConfig;
import org.opennms.netmgt.alarmd.northbounder.drools.DroolsNorthbounderConfigDao;
import org.opennms.netmgt.alarmd.northbounder.drools.Global;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class DroolsNorthbounder
extends AbstractNorthbounder
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsNorthbounder.class);
    protected static final String NBI_NAME = "DroolsNBI";
    private DroolsNorthbounderConfigDao m_configDao;
    private DroolsEngine m_engine;
    private KieBase m_kieBase;
    private KieSession m_kieSession;
    private EventProxy m_eventProxy;
    private boolean initialized = false;
    private ApplicationContext m_context;

    public DroolsNorthbounder(ApplicationContext context, DroolsNorthbounderConfigDao configDao, EventProxy eventProxy, String engineName) {
        super("DroolsNBI-" + engineName);
        this.m_context = context;
        this.m_configDao = configDao;
        this.m_eventProxy = eventProxy;
        this.m_engine = configDao.getConfig().getEngine(engineName);
    }

    public void afterPropertiesSet() throws Exception {
        this.setNaglesDelay(this.getConfig().getNaglesDelay().intValue());
        this.setMaxBatchSize(this.getConfig().getBatchSize());
        this.setMaxPreservedAlarms(this.getConfig().getQueueSize());
        if (this.m_engine == null) {
            LOG.error("Drools Northbounder {} is currently disabled because it has not been initialized correctly or there is a problem with the configuration.", (Object)this.getName());
            this.initialized = false;
            return;
        }
        this.initializeDroolsEngine();
        this.initialized = true;
    }

    protected void onStop() {
        this.marshallStateToDisk(true);
    }

    private void initializeDroolsEngine() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kFileSystem = ks.newKieFileSystem();
        for (String ruleFile : this.m_engine.getRuleFiles()) {
            LOG.debug("Loading rules file: {}", (Object)ruleFile);
            kFileSystem.write("src/main/resources/" + ruleFile, ks.getResources().newFileSystemResource(new File(ruleFile)));
        }
        KieBuilder kbuilder = ks.newKieBuilder(kFileSystem);
        kbuilder.buildAll();
        if (kbuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            LOG.warn("Unable to initialize Drools engine: {}", (Object)kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}));
            throw new IllegalStateException("Unable to initialize Drools engine: " + kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}));
        }
        KieContainer kContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        RuleBaseConfiguration.AssertBehaviour behaviour = RuleBaseConfiguration.AssertBehaviour.determineAssertBehaviour((String)this.m_engine.getAssertBehaviour());
        RuleBaseConfiguration ruleBaseConfig = new RuleBaseConfiguration();
        ruleBaseConfig.setAssertBehaviour(behaviour);
        ruleBaseConfig.setEventProcessingMode(EventProcessingOption.STREAM);
        this.m_kieBase = kContainer.newKieBase((KieBaseConfiguration)ruleBaseConfig);
        this.m_kieSession = this.m_kieBase.newKieSession();
        this.m_kieSession.setGlobal("engine", (Object)this);
        this.unmarshallStateFromDisk(true);
        ApplicationContext ctx = this.m_context;
        if (this.m_engine.getAppContext() != null) {
            ctx = new FileSystemXmlApplicationContext(new String[]{this.m_engine.getAppContext()}, this.m_context);
        }
        for (Global global : this.m_engine.getGlobals()) {
            this.m_kieSession.setGlobal(global.getName(), global.constructValue(ctx));
        }
        new Thread(() -> {
            Logging.putPrefix((String)this.getName());
            LOG.debug("Starting task thread for {}", (Object)this.getName());
            this.m_kieSession.fireUntilHalt();
            LOG.debug("Stopping task thread for {}", (Object)this.getName());
        }, "FireTask-" + this.getName()).start();
    }

    public boolean accepts(NorthboundAlarm alarm) {
        if (!this.initialized) {
            LOG.warn("Drools Northbounder {} has not been properly initialized, rejecting alarm {}.", (Object)this.getName(), (Object)alarm.getUei());
            return false;
        }
        if (!this.getConfig().isEnabled().booleanValue()) {
            LOG.warn("Drools Northbounder {} is currently disabled, rejecting alarm {}.", (Object)this.getName(), (Object)alarm.getUei());
            return false;
        }
        LOG.debug("Validating UEI of alarm: {}", (Object)alarm.getUei());
        if (this.getConfig().getUeis() == null || this.getConfig().getUeis().contains(alarm.getUei())) {
            LOG.debug("UEI: {}, accepted.", (Object)alarm.getUei());
            boolean passed = this.m_engine.accepts(alarm);
            LOG.debug("Filters: {}, passed ? {}.", (Object)alarm.getUei(), (Object)passed);
            return passed;
        }
        LOG.debug("UEI: {}, rejected.", (Object)alarm.getUei());
        return false;
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        if (alarms == null) {
            String errorMsg = "No alarms in alarms list for drools forwarding.";
            NorthbounderException e = new NorthbounderException(errorMsg);
            LOG.error(errorMsg, (Throwable)e);
            throw e;
        }
        LOG.info("Forwarding {} alarms to engine {}", (Object)alarms.size(), (Object)this.m_engine.getName());
        alarms.forEach(a -> {
            LOG.debug("Begin correlation for alarm {} uei: {}", (Object)a.getId(), (Object)a.getUei());
            this.m_kieSession.insert(a);
            LOG.debug("End correlation for alarm {} uei: {}", (Object)a.getId(), (Object)a.getUei());
        });
    }

    public Collection<? extends Object> getKieSessionObjects() {
        return this.m_kieSession.getObjects();
    }

    public KieSession getKieSession() {
        return this.m_kieSession;
    }

    public void sendEvent(Event event) {
        try {
            this.m_eventProxy.send(event);
        }
        catch (EventProxyException e) {
            LOG.error("Can't send event", (Throwable)e);
        }
    }

    protected DroolsNorthbounderConfig getConfig() {
        return this.m_configDao.getConfig();
    }

    private Path getPathToState() {
        return Paths.get(System.getProperty("java.io.tmpdir"), "opennms.drools.nbi." + this.getName() + ".state");
    }

    private void marshallStateToDisk(boolean serialize) {
        File stateFile = this.getPathToState().toFile();
        LOG.debug("Saving state for engine {} in {} ...", (Object)this.getName(), (Object)stateFile);
        KieMarshallers kMarshallers = KieServices.Factory.get().getMarshallers();
        ObjectMarshallingStrategy oms = serialize ? kMarshallers.newSerializeMarshallingStrategy() : kMarshallers.newIdentityMarshallingStrategy();
        Marshaller marshaller = kMarshallers.newMarshaller(this.m_kieBase, new ObjectMarshallingStrategy[]{oms});
        try (FileOutputStream fos = new FileOutputStream(stateFile);){
            this.m_kieSession.halt();
            marshaller.marshall((OutputStream)fos, this.m_kieSession);
            this.m_kieSession.dispose();
            this.m_kieSession.destroy();
            LOG.info("Sucessfully save state for engine {} in {}. There are {} elements on the working memory.", new Object[]{this.getName(), stateFile, this.m_kieSession.getObjects().size()});
        }
        catch (IOException e) {
            LOG.error("Failed to save state for engine {} in {}.", new Object[]{this.getName(), stateFile, e});
        }
    }

    private void unmarshallStateFromDisk(boolean serialize) {
        File stateFile = this.getPathToState().toFile();
        LOG.debug("Restoring state for engine {} from {} ...", (Object)this.getName(), (Object)stateFile);
        if (!stateFile.exists()) {
            return;
        }
        KieMarshallers kMarshallers = KieServices.Factory.get().getMarshallers();
        ObjectMarshallingStrategy oms = serialize ? kMarshallers.newSerializeMarshallingStrategy() : kMarshallers.newIdentityMarshallingStrategy();
        Marshaller marshaller = kMarshallers.newMarshaller(this.m_kieBase, new ObjectMarshallingStrategy[]{oms});
        try (FileInputStream fin = new FileInputStream(stateFile);){
            marshaller.unmarshall((InputStream)fin, this.m_kieSession);
            stateFile.delete();
            LOG.info("Sucessfully restored state for engine {} from {}. There are {} elements on the working memory.", new Object[]{this.getName(), stateFile, this.m_kieSession.getObjects().size()});
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.error("Failed to restore state for engine {} from {}.", new Object[]{this.getName(), stateFile, e});
        }
    }
}

