/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.api;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.alarmd.api.Preservable;
import org.opennms.netmgt.events.api.EventParameterUtils;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.netmgt.xml.event.Parm;

@XmlRootElement(name="northbound-alarm")
@ValidateUsing(value="northbound-alarm.xsd")
@XmlAccessorType(value=XmlAccessType.NONE)
public class NorthboundAlarm
implements Preservable {
    public static final NorthboundAlarm SYNC_LOST_ALARM = new NorthboundAlarm(-1, "uei.opennms.org/alarmd/northbounderSyncLost");
    @XmlAttribute(name="id")
    private Integer m_id;
    @XmlElement(name="uei")
    private String m_uei;
    @XmlElement(name="node-id")
    private Integer m_nodeId;
    @XmlElement(name="node-label")
    private String m_nodeLabel;
    @XmlElement(name="node-sysobjectid")
    private String m_nodeSysObjectId;
    @XmlElement(name="node-foreignsource")
    private String m_foreignSource;
    @XmlElement(name="node-foreignid")
    private String m_foreignId;
    @XmlElement(name="ack-time")
    private Date m_ackTime;
    @XmlElement(name="ack-user")
    private String m_ackUser;
    @XmlElement(name="alarm-type")
    private AlarmType m_alarmType;
    @XmlElement(name="app-dn")
    private String m_appDn;
    @XmlElement(name="clear-key")
    private String m_clearKey;
    @XmlElement(name="count")
    private Integer m_count;
    @XmlElement(name="description")
    private String m_desc;
    private OnmsDistPoller m_poller;
    @XmlElement(name="first-occurrence")
    private Date m_firstOccurrence;
    @XmlElement(name="ip-address")
    private String m_ipAddr;
    @XmlElement(name="last-occurrence")
    private Date m_lastOccurrence;
    @XmlElement(name="log-messsage")
    private String m_logMsg;
    @XmlElement(name="object-instance")
    private String m_objectInstance;
    @XmlElement(name="object-type")
    private String m_objectType;
    @XmlElement(name="operator-instructions")
    private String m_operInst;
    @XmlElement(name="oss-key")
    private String m_ossKey;
    @XmlElement(name="oss-state")
    private String m_ossState;
    @XmlElement(name="alarm-key")
    private String m_alarmKey;
    @XmlElement(name="service")
    private String m_service;
    @XmlElement(name="severity")
    private OnmsSeverity m_severity;
    @XmlElement(name="suppressed")
    private Date m_suppressed;
    @XmlElement(name="suppressed-until")
    private Date m_suppressedUntil;
    @XmlElement(name="suppressed-by")
    private String m_suppressedBy;
    @XmlElement(name="ticket-id")
    private String m_ticketId;
    @XmlElement(name="ticket-state")
    private TroubleTicketState m_ticketState;
    @XmlElement(name="x733-type")
    private String m_x733Type;
    @XmlElement(name="x733-cause")
    private int m_x733Cause;
    private Map<String, String> m_eventParametersMap = new HashMap<String, String>();
    private List<Parm> m_eventParametersCollection = new ArrayList<Parm>();
    @XmlElement(name="preserved", defaultValue="false")
    private volatile boolean m_preserved = false;

    public NorthboundAlarm() {
    }

    private NorthboundAlarm(int id, String uei) {
        this.m_id = id;
        this.m_uei = uei;
        this.m_nodeId = null;
        this.m_ackTime = null;
        this.m_ackUser = null;
        this.m_alarmType = null;
        this.m_appDn = null;
        this.m_clearKey = null;
        this.m_count = null;
        this.m_desc = null;
        this.m_poller = null;
        this.m_firstOccurrence = null;
        this.m_ipAddr = null;
        this.m_lastOccurrence = null;
        this.m_logMsg = null;
        this.m_objectInstance = null;
        this.m_objectType = null;
        this.m_operInst = null;
        this.m_ossKey = null;
        this.m_ossState = null;
        this.m_alarmKey = null;
        this.m_service = null;
        this.m_severity = null;
        this.m_suppressed = null;
        this.m_suppressedUntil = null;
        this.m_suppressedBy = null;
        this.m_ticketId = null;
        this.m_ticketState = null;
        this.m_x733Type = null;
        this.m_x733Cause = -1;
    }

    public NorthboundAlarm(OnmsAlarm alarm) {
        this.m_nodeId = alarm.getNodeId();
        this.m_ackTime = alarm.getAlarmAckTime();
        this.m_ackUser = alarm.getAlarmAckUser();
        this.m_alarmType = alarm.getAlarmType() == null ? null : AlarmType.toAlarmType(alarm.getAlarmType());
        this.m_appDn = alarm.getApplicationDN();
        this.m_clearKey = alarm.getClearKey();
        this.m_count = alarm.getCounter();
        this.m_desc = alarm.getDescription();
        this.m_poller = alarm.getDistPoller();
        this.m_firstOccurrence = alarm.getFirstEventTime();
        this.m_id = alarm.getId();
        this.m_ipAddr = alarm.getIpAddr() != null ? InetAddressUtils.toIpAddrString((InetAddress)alarm.getIpAddr()) : null;
        this.m_lastOccurrence = alarm.getLastEventTime();
        this.m_logMsg = alarm.getLogMsg();
        this.m_objectInstance = alarm.getManagedObjectInstance();
        this.m_objectType = alarm.getManagedObjectType();
        this.m_operInst = alarm.getOperInstruct();
        this.m_ossKey = alarm.getOssPrimaryKey();
        this.m_ossState = alarm.getQosAlarmState();
        this.m_alarmKey = alarm.getReductionKey();
        this.m_service = alarm.getServiceType() == null ? null : alarm.getServiceType().getName();
        this.m_severity = alarm.getSeverity();
        this.m_suppressed = alarm.getSuppressedTime();
        this.m_suppressedUntil = alarm.getSuppressedUntil();
        this.m_suppressedBy = alarm.getSuppressedUser();
        this.m_ticketId = alarm.getTTicketId();
        this.m_ticketState = alarm.getTTicketState();
        this.m_uei = alarm.getUei();
        this.m_x733Type = alarm.getX733AlarmType();
        this.m_x733Cause = alarm.getX733ProbableCause();
        if (alarm.getNode() != null) {
            this.m_foreignSource = alarm.getNode().getForeignSource();
            this.m_foreignId = alarm.getNode().getForeignId();
            this.m_nodeLabel = alarm.getNode().getLabel();
            this.m_nodeSysObjectId = alarm.getNode().getSysObjectId();
        }
        if (alarm.getEventParms() != null) {
            this.m_eventParametersCollection.addAll(EventParameterUtils.decode((String)alarm.getEventParms()));
            for (Parm parm : this.m_eventParametersCollection) {
                this.m_eventParametersMap.put(parm.getParmName(), parm.getValue().getContent());
            }
        }
    }

    public Integer getId() {
        return this.m_id;
    }

    public String getUei() {
        return this.m_uei;
    }

    public Date getAckTime() {
        return this.m_ackTime;
    }

    public String getAckUser() {
        return this.m_ackUser;
    }

    public AlarmType getAlarmType() {
        return this.m_alarmType;
    }

    public String getAppDn() {
        return this.m_appDn;
    }

    public String getClearKey() {
        return this.m_clearKey;
    }

    public Integer getCount() {
        return this.m_count;
    }

    public String getDesc() {
        return this.m_desc;
    }

    public OnmsDistPoller getPoller() {
        return this.m_poller;
    }

    public Date getFirstOccurrence() {
        return this.m_firstOccurrence;
    }

    public String getIpAddr() {
        return this.m_ipAddr;
    }

    public Date getLastOccurrence() {
        return this.m_lastOccurrence;
    }

    public String getLogMsg() {
        return this.m_logMsg;
    }

    public String getObjectInstance() {
        return this.m_objectInstance;
    }

    public String getObjectType() {
        return this.m_objectType;
    }

    public String getOperInst() {
        return this.m_operInst;
    }

    public String getOssKey() {
        return this.m_ossKey;
    }

    public String getOssState() {
        return this.m_ossState;
    }

    public String getAlarmKey() {
        return this.m_alarmKey;
    }

    public String getService() {
        return this.m_service;
    }

    public OnmsSeverity getSeverity() {
        return this.m_severity;
    }

    public Date getSuppressed() {
        return this.m_suppressed;
    }

    public Date getSuppressedUntil() {
        return this.m_suppressedUntil;
    }

    public String getSuppressedBy() {
        return this.m_suppressedBy;
    }

    public String getTicketId() {
        return this.m_ticketId;
    }

    public TroubleTicketState getTicketState() {
        return this.m_ticketState;
    }

    public String getX733Type() {
        return this.m_x733Type;
    }

    public int getX733Cause() {
        return this.m_x733Cause;
    }

    public Map<String, String> getParameters() {
        return this.m_eventParametersMap;
    }

    public List<Parm> getEventParametersCollection() {
        return this.m_eventParametersCollection;
    }

    @Override
    public boolean isPreserved() {
        return this.m_preserved;
    }

    @Override
    public void setPreserved(boolean preserved) {
        this.m_preserved = preserved;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public String getNodeLabel() {
        return this.m_nodeLabel;
    }

    public String getNodeSysObjectId() {
        return this.m_nodeSysObjectId;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public String getForeignId() {
        return this.m_foreignId;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    public void setUei(String uei) {
        this.m_uei = uei;
    }

    public void setNodeId(Integer nodeId) {
        this.m_nodeId = nodeId;
    }

    public void setNodeLabel(String nodeLabel) {
        this.m_nodeLabel = nodeLabel;
    }

    public void setNodeSysObjectId(String nodeSysObjectId) {
        this.m_nodeSysObjectId = nodeSysObjectId;
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = foreignSource;
    }

    public void setForeignId(String foreignId) {
        this.m_foreignId = foreignId;
    }

    public void setAckTime(Date ackTime) {
        this.m_ackTime = ackTime;
    }

    public void setAckUser(String ackUser) {
        this.m_ackUser = ackUser;
    }

    public void setAlarmType(AlarmType alarmType) {
        this.m_alarmType = alarmType;
    }

    public void setAppDn(String appDn) {
        this.m_appDn = appDn;
    }

    public void setClearKey(String clearKey) {
        this.m_clearKey = clearKey;
    }

    public void setCount(Integer count) {
        this.m_count = count;
    }

    public void setDesc(String desc) {
        this.m_desc = desc;
    }

    public void setPoller(OnmsDistPoller poller) {
        this.m_poller = poller;
    }

    public void setFirstOccurrence(Date firstOccurrence) {
        this.m_firstOccurrence = firstOccurrence;
    }

    public void setIpAddr(String ipAddr) {
        this.m_ipAddr = ipAddr;
    }

    public void setLastOccurrence(Date lastOccurrence) {
        this.m_lastOccurrence = lastOccurrence;
    }

    public void setLogMsg(String logMsg) {
        this.m_logMsg = logMsg;
    }

    public void setObjectInstance(String objectInstance) {
        this.m_objectInstance = objectInstance;
    }

    public void setObjectType(String objectType) {
        this.m_objectType = objectType;
    }

    public void setOperInst(String operInst) {
        this.m_operInst = operInst;
    }

    public void setOssKey(String ossKey) {
        this.m_ossKey = ossKey;
    }

    public void setOssState(String ossState) {
        this.m_ossState = ossState;
    }

    public void setAlarmKey(String alarmKey) {
        this.m_alarmKey = alarmKey;
    }

    public void setService(String service) {
        this.m_service = service;
    }

    public void setSeverity(OnmsSeverity severity) {
        this.m_severity = severity;
    }

    public void setSuppressed(Date suppressed) {
        this.m_suppressed = suppressed;
    }

    public void setSuppressedUntil(Date suppressedUntil) {
        this.m_suppressedUntil = suppressedUntil;
    }

    public void setSuppressedBy(String suppressedBy) {
        this.m_suppressedBy = suppressedBy;
    }

    public void setTicketId(String ticketId) {
        this.m_ticketId = ticketId;
    }

    public void setTicketState(TroubleTicketState ticketState) {
        this.m_ticketState = ticketState;
    }

    public void setx733Type(String x733Type) {
        this.m_x733Type = x733Type;
    }

    public void setx733Cause(int x733Cause) {
        this.m_x733Cause = x733Cause;
    }

    public void setEventParametersMap(Map<String, String> eventParametersMap) {
        this.m_eventParametersMap = eventParametersMap;
    }

    public void setEventParametersCollection(List<Parm> eventParametersCollection) {
        this.m_eventParametersCollection = eventParametersCollection;
    }

    public String toString() {
        return String.format("NorthboundAlarm[id=%d, uei='%s', nodeId=%d]", this.m_id, this.m_uei, this.m_nodeId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_ackTime == null ? 0 : this.m_ackTime.hashCode());
        result = 31 * result + (this.m_ackUser == null ? 0 : this.m_ackUser.hashCode());
        result = 31 * result + (this.m_alarmKey == null ? 0 : this.m_alarmKey.hashCode());
        result = 31 * result + (this.m_alarmType == null ? 0 : this.m_alarmType.hashCode());
        result = 31 * result + (this.m_appDn == null ? 0 : this.m_appDn.hashCode());
        result = 31 * result + (this.m_clearKey == null ? 0 : this.m_clearKey.hashCode());
        result = 31 * result + (this.m_count == null ? 0 : this.m_count.hashCode());
        result = 31 * result + (this.m_desc == null ? 0 : this.m_desc.hashCode());
        result = 31 * result + (this.m_eventParametersCollection == null ? 0 : this.m_eventParametersCollection.hashCode());
        result = 31 * result + (this.m_eventParametersMap == null ? 0 : this.m_eventParametersMap.hashCode());
        result = 31 * result + (this.m_firstOccurrence == null ? 0 : this.m_firstOccurrence.hashCode());
        result = 31 * result + (this.m_foreignId == null ? 0 : this.m_foreignId.hashCode());
        result = 31 * result + (this.m_foreignSource == null ? 0 : this.m_foreignSource.hashCode());
        result = 31 * result + (this.m_id == null ? 0 : this.m_id.hashCode());
        result = 31 * result + (this.m_ipAddr == null ? 0 : this.m_ipAddr.hashCode());
        result = 31 * result + (this.m_lastOccurrence == null ? 0 : this.m_lastOccurrence.hashCode());
        result = 31 * result + (this.m_logMsg == null ? 0 : this.m_logMsg.hashCode());
        result = 31 * result + (this.m_nodeId == null ? 0 : this.m_nodeId.hashCode());
        result = 31 * result + (this.m_nodeLabel == null ? 0 : this.m_nodeLabel.hashCode());
        result = 31 * result + (this.m_nodeSysObjectId == null ? 0 : this.m_nodeSysObjectId.hashCode());
        result = 31 * result + (this.m_objectInstance == null ? 0 : this.m_objectInstance.hashCode());
        result = 31 * result + (this.m_objectType == null ? 0 : this.m_objectType.hashCode());
        result = 31 * result + (this.m_operInst == null ? 0 : this.m_operInst.hashCode());
        result = 31 * result + (this.m_ossKey == null ? 0 : this.m_ossKey.hashCode());
        result = 31 * result + (this.m_ossState == null ? 0 : this.m_ossState.hashCode());
        result = 31 * result + (this.m_poller == null ? 0 : this.m_poller.hashCode());
        result = 31 * result + (this.m_preserved ? 1231 : 1237);
        result = 31 * result + (this.m_service == null ? 0 : this.m_service.hashCode());
        result = 31 * result + (this.m_severity == null ? 0 : this.m_severity.hashCode());
        result = 31 * result + (this.m_suppressed == null ? 0 : this.m_suppressed.hashCode());
        result = 31 * result + (this.m_suppressedBy == null ? 0 : this.m_suppressedBy.hashCode());
        result = 31 * result + (this.m_suppressedUntil == null ? 0 : this.m_suppressedUntil.hashCode());
        result = 31 * result + (this.m_ticketId == null ? 0 : this.m_ticketId.hashCode());
        result = 31 * result + (this.m_ticketState == null ? 0 : this.m_ticketState.hashCode());
        result = 31 * result + (this.m_uei == null ? 0 : this.m_uei.hashCode());
        result = 31 * result + this.m_x733Cause;
        result = 31 * result + (this.m_x733Type == null ? 0 : this.m_x733Type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NorthboundAlarm other = (NorthboundAlarm)obj;
        if (this.m_ackTime == null ? other.m_ackTime != null : !this.m_ackTime.equals(other.m_ackTime)) {
            return false;
        }
        if (this.m_ackUser == null ? other.m_ackUser != null : !this.m_ackUser.equals(other.m_ackUser)) {
            return false;
        }
        if (this.m_alarmKey == null ? other.m_alarmKey != null : !this.m_alarmKey.equals(other.m_alarmKey)) {
            return false;
        }
        if (this.m_alarmType != other.m_alarmType) {
            return false;
        }
        if (this.m_appDn == null ? other.m_appDn != null : !this.m_appDn.equals(other.m_appDn)) {
            return false;
        }
        if (this.m_clearKey == null ? other.m_clearKey != null : !this.m_clearKey.equals(other.m_clearKey)) {
            return false;
        }
        if (this.m_count == null ? other.m_count != null : !this.m_count.equals(other.m_count)) {
            return false;
        }
        if (this.m_desc == null ? other.m_desc != null : !this.m_desc.equals(other.m_desc)) {
            return false;
        }
        if (this.m_eventParametersCollection == null ? other.m_eventParametersCollection != null : !this.m_eventParametersCollection.equals(other.m_eventParametersCollection)) {
            return false;
        }
        if (this.m_eventParametersMap == null ? other.m_eventParametersMap != null : !this.m_eventParametersMap.equals(other.m_eventParametersMap)) {
            return false;
        }
        if (this.m_firstOccurrence == null ? other.m_firstOccurrence != null : !this.m_firstOccurrence.equals(other.m_firstOccurrence)) {
            return false;
        }
        if (this.m_foreignId == null ? other.m_foreignId != null : !this.m_foreignId.equals(other.m_foreignId)) {
            return false;
        }
        if (this.m_foreignSource == null ? other.m_foreignSource != null : !this.m_foreignSource.equals(other.m_foreignSource)) {
            return false;
        }
        if (this.m_id == null ? other.m_id != null : !this.m_id.equals(other.m_id)) {
            return false;
        }
        if (this.m_ipAddr == null ? other.m_ipAddr != null : !this.m_ipAddr.equals(other.m_ipAddr)) {
            return false;
        }
        if (this.m_lastOccurrence == null ? other.m_lastOccurrence != null : !this.m_lastOccurrence.equals(other.m_lastOccurrence)) {
            return false;
        }
        if (this.m_logMsg == null ? other.m_logMsg != null : !this.m_logMsg.equals(other.m_logMsg)) {
            return false;
        }
        if (this.m_nodeId == null ? other.m_nodeId != null : !this.m_nodeId.equals(other.m_nodeId)) {
            return false;
        }
        if (this.m_nodeLabel == null ? other.m_nodeLabel != null : !this.m_nodeLabel.equals(other.m_nodeLabel)) {
            return false;
        }
        if (this.m_nodeSysObjectId == null ? other.m_nodeSysObjectId != null : !this.m_nodeSysObjectId.equals(other.m_nodeSysObjectId)) {
            return false;
        }
        if (this.m_objectInstance == null ? other.m_objectInstance != null : !this.m_objectInstance.equals(other.m_objectInstance)) {
            return false;
        }
        if (this.m_objectType == null ? other.m_objectType != null : !this.m_objectType.equals(other.m_objectType)) {
            return false;
        }
        if (this.m_operInst == null ? other.m_operInst != null : !this.m_operInst.equals(other.m_operInst)) {
            return false;
        }
        if (this.m_ossKey == null ? other.m_ossKey != null : !this.m_ossKey.equals(other.m_ossKey)) {
            return false;
        }
        if (this.m_ossState == null ? other.m_ossState != null : !this.m_ossState.equals(other.m_ossState)) {
            return false;
        }
        if (this.m_poller == null ? other.m_poller != null : !this.m_poller.equals(other.m_poller)) {
            return false;
        }
        if (this.m_preserved != other.m_preserved) {
            return false;
        }
        if (this.m_service == null ? other.m_service != null : !this.m_service.equals(other.m_service)) {
            return false;
        }
        if (this.m_severity != other.m_severity) {
            return false;
        }
        if (this.m_suppressed == null ? other.m_suppressed != null : !this.m_suppressed.equals(other.m_suppressed)) {
            return false;
        }
        if (this.m_suppressedBy == null ? other.m_suppressedBy != null : !this.m_suppressedBy.equals(other.m_suppressedBy)) {
            return false;
        }
        if (this.m_suppressedUntil == null ? other.m_suppressedUntil != null : !this.m_suppressedUntil.equals(other.m_suppressedUntil)) {
            return false;
        }
        if (this.m_ticketId == null ? other.m_ticketId != null : !this.m_ticketId.equals(other.m_ticketId)) {
            return false;
        }
        if (this.m_ticketState != other.m_ticketState) {
            return false;
        }
        if (this.m_uei == null ? other.m_uei != null : !this.m_uei.equals(other.m_uei)) {
            return false;
        }
        if (this.m_x733Cause != other.m_x733Cause) {
            return false;
        }
        return !(this.m_x733Type == null ? other.m_x733Type != null : !this.m_x733Type.equals(other.m_x733Type));
    }

    public static enum x733AlarmType {
        other(1, "other"),
        communicationsAlarm(2, "communicationsAlarm"),
        qualityOfServiceAlarm(3, "qualityOfServiceAlarm"),
        processingErrorAlarm(4, "processingErrorAlarm"),
        equipmentAlarm(5, "equipmentAlarm"),
        environmentalAlarm(6, "environmentalAlarm"),
        integrityViolation(7, "integrityViolation"),
        operationalViolation(8, "operationalViolation"),
        physicalViolation(9, "physicalViolation"),
        securityServiceOrMechanismViolation(10, "securityServiceOrMechanismViolation"),
        timeDomainViolation(11, "timeDomainViolation");

        private static Map<Integer, x733AlarmType> m_idMap;
        private int m_id;
        private String m_label;

        private x733AlarmType(int id, String label) {
            this.m_id = id;
            this.m_label = label;
        }

        public int getId() {
            return this.m_id;
        }

        public static x733AlarmType get(String label) {
            x733AlarmType cause = other;
            if (label == null) {
                return cause;
            }
            for (Integer key : m_idMap.keySet()) {
                if (!m_idMap.get(key).getLabel().equalsIgnoreCase(label)) continue;
                cause = m_idMap.get(key);
            }
            return cause;
        }

        private String getLabel() {
            return this.m_label;
        }

        public static x733AlarmType get(int id) {
            if (m_idMap.containsKey(id)) {
                return m_idMap.get(id);
            }
            throw new IllegalArgumentException("Unknown x733 Alarm Type ID requested: " + id);
        }

        static {
            m_idMap = new HashMap<Integer, x733AlarmType>(x733AlarmType.values().length);
            for (x733AlarmType type : x733AlarmType.values()) {
                m_idMap.put(type.getId(), type);
            }
        }
    }

    public static enum x733ProbableCause {
        other(1, "other"),
        adapterError(2, "adapterError"),
        applicationSubsystemFailure(3, "applicationSubsystemFailure"),
        bandwidthReduced(4, "bandwidthReduced"),
        callEstablishmentError(5, "callEstablishmentError"),
        communicationsProtocolError(6, "communicationsProtocolError"),
        communicationsSubsystemFailure(7, "communicationsSubsystemFailure"),
        configurationOrCustomizationError(8, "configurationOrCustomizationError"),
        congestion(9, "congestion"),
        corruptData(10, "corruptData"),
        cpuCyclesLimitExceeded(11, "cpuCyclesLimitExceeded"),
        dataSetOrModemError(12, "dataSetOrModemError"),
        degradedSignal(13, "degradedSignal"),
        dteDceInterfaceError(14, "dteDceInterfaceError"),
        enclosureDoorOpen(15, "enclosureDoorOpen"),
        equipmentMalfunction(16, "equipmentMalfunction"),
        excessiveVibration(17, "excessiveVibration"),
        fileError(18, "fileError"),
        fireDetected(19, "fireDetected"),
        floodDetected(20, "floodDetected"),
        framingError(21, "framingError"),
        heatingVentCoolingSystemProblem(22, "heatingVentCoolingSystemProblem"),
        humidityUnacceptable(23, "humidityUnacceptable"),
        inputOutputDeviceError(24, "inputOutputDeviceError"),
        inputDeviceError(25, "inputDeviceError"),
        lanError(26, "lanError"),
        leakDetected(27, "leakDetected"),
        localNodeTransmissionError(28, "localNodeTransmissionError"),
        lossOfFrame(29, "lossOfFrame"),
        lossOfSignal(30, "lossOfSignal"),
        materialSupplyExhausted(31, "materialSupplyExhausted"),
        multiplexerProblem(32, "multiplexerProblem"),
        outOfMemory(33, "multiplexerProblem"),
        outputDeviceError(34, "outputDeviceError"),
        performanceDegraded(35, "performanceDegraded"),
        powerProblem(36, "powerProblem"),
        pressureUnacceptable(37, "pressureUnacceptable"),
        processorProblem(38, "processorProblem"),
        pumpFailure(39, "pumpFailure"),
        queueSizeExceeded(40, "queueSizeExceeded"),
        receiveFailure(41, "receiveFailure"),
        receiverFailure(42, "receiverFailure"),
        remoteNodeTransmissionError(43, "remoteNodeTransmissionError"),
        resourceAtOrNearingCapacity(44, "resourceAtOrNearingCapacity"),
        responseTimeExecessive(45, "responseTimeExcessive"),
        retransmissionRateExcessive(46, "retransmissionRateExcessive"),
        softwareError(47, "softwareError"),
        softwareProgramAbnormallyTerminated(48, "softwareProgramAbnormallyTerminated"),
        softwareProgramError(49, "softwareProgramError"),
        storageCapacityProblem(50, "storageCapacityProblem"),
        temperatureUnacceptable(51, "temperatureUnacceptable"),
        thresholdCrossed(52, "thresholdCrossed"),
        timingProblem(53, "timingProblem"),
        toxicLeakDetected(54, "toxicLeakDetected"),
        transmitFailure(55, "transmitFailure"),
        transmitterFailure(56, "transmitterFailure"),
        underlyingResourceUnavailable(57, "underlyingResourceUnavailable"),
        versionMismatch(58, "versionMismatch"),
        authenticationFailure(59, "authenticationFailure"),
        breachOfConfidentiality(60, "breachOfConfidentiality"),
        cableTamper(61, "cableTamper"),
        delayedInformation(62, "delayedInformation"),
        denialOfService(63, "denialOfService"),
        duplicateInformation(64, "duplicateInformation"),
        informationMissing(65, "informationMissing"),
        informationModificationDetected(66, "informationModificationDetected"),
        informationOutOfSequence(67, "informationOutOfSequence"),
        intrusionDetection(68, "intrusionDetection"),
        keyExpired(69, "keyExpired"),
        nonRepudiationFailure(70, "nonRepudiationFailure"),
        outOfHoursActivity(71, "outOfHoursActivity"),
        outOfService(72, "outOfService"),
        proceduralError(73, "proceduralError"),
        unauthorizedAccessAttempt(74, "unauthorizedAccessAttempt"),
        unexpectedInformation(75, "unexpectedInformation");

        private static final Map<Integer, x733ProbableCause> m_idMap;
        private int m_id;
        private String m_label;

        private x733ProbableCause(int id, String label) {
            this.m_id = id;
            this.m_label = label;
        }

        public int getId() {
            return this.m_id;
        }

        public String getLabel() {
            return this.m_label;
        }

        public static x733ProbableCause get(String label) {
            x733ProbableCause cause = other;
            if (label == null) {
                return cause;
            }
            for (Integer key : m_idMap.keySet()) {
                if (!m_idMap.get(key).getLabel().equalsIgnoreCase(label)) continue;
                cause = m_idMap.get(key);
            }
            return cause;
        }

        public static x733ProbableCause get(int id) {
            if (m_idMap.containsKey(id)) {
                return m_idMap.get(id);
            }
            throw new IllegalArgumentException("Unknown x733 Probable Cause ID requested: " + id);
        }

        static {
            m_idMap = new HashMap<Integer, x733ProbableCause>(x733ProbableCause.values().length);
            for (x733ProbableCause cause : x733ProbableCause.values()) {
                m_idMap.put(cause.getId(), cause);
            }
        }
    }

    public static enum AlarmType {
        PROBLEM,
        RESOLUTION,
        NOTIFICATION;


        static AlarmType toAlarmType(int alarmType) {
            if (alarmType == 1) {
                return PROBLEM;
            }
            if (alarmType == 2) {
                return RESOLUTION;
            }
            return NOTIFICATION;
        }
    }
}

