/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.api.support;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.Northbounder;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AlarmQueue;
import org.opennms.netmgt.alarmd.api.support.StatusFactory;
import org.opennms.netmgt.dao.api.NodeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNorthbounder
implements Northbounder,
Runnable,
StatusFactory<NorthboundAlarm> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNorthbounder.class);
    private final String m_name;
    private final AlarmQueue<NorthboundAlarm> m_queue;
    protected NodeDao m_nodeDao;
    private volatile boolean m_stopped = true;
    private long m_retryInterval = 1000L;

    protected AbstractNorthbounder(String name) {
        this.m_name = name;
        this.m_queue = new AlarmQueue<NorthboundAlarm>(this);
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setNaglesDelay(long delay) {
        this.m_queue.setNaglesDelay(delay);
    }

    public void setRetryInterval(int retryInterval) {
        this.m_retryInterval = retryInterval;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.m_queue.setMaxBatchSize(maxBatchSize);
    }

    public void setMaxPreservedAlarms(int maxPreservedAlarms) {
        this.m_queue.setMaxPreservedAlarms(maxPreservedAlarms);
    }

    protected void onPreStart() {
    }

    protected void onPostStart() {
    }

    @Override
    public final void start() throws NorthbounderException {
        if (!this.m_stopped) {
            return;
        }
        this.onPreStart();
        this.m_stopped = false;
        this.m_queue.init();
        Thread thread = new Thread((Runnable)this, this.getName() + "-Thread");
        thread.start();
        this.onPostStart();
    }

    @Override
    public final void onAlarm(NorthboundAlarm alarm) throws NorthbounderException {
        if (this.accepts(alarm)) {
            this.m_queue.accept(alarm);
        }
    }

    protected abstract boolean accepts(NorthboundAlarm var1);

    protected void preserve(NorthboundAlarm alarm) throws NorthbounderException {
        this.m_queue.preserve(alarm);
    }

    protected void discard(NorthboundAlarm alarm) throws NorthbounderException {
        this.m_queue.discard(alarm);
    }

    protected void onStop() {
    }

    @Override
    public final void stop() throws NorthbounderException {
        this.onStop();
        this.m_stopped = true;
    }

    @Override
    public void run() {
        block4: while (true) {
            try {
                while (!this.m_stopped) {
                    List<NorthboundAlarm> alarmsToForward = this.m_queue.getAlarmsToForward();
                    try {
                        this.forwardAlarms(alarmsToForward);
                        this.m_queue.forwardSuccessful(alarmsToForward);
                        continue block4;
                    }
                    catch (Exception e) {
                        this.m_queue.forwardFailed(alarmsToForward);
                        if (this.m_stopped) continue;
                        Thread.sleep(this.m_retryInterval);
                    }
                }
                break;
            }
            catch (InterruptedException e) {
                LOG.warn("Thread '{}' was interrupted unexpected.", (Object)this.getName());
                break;
            }
        }
    }

    @Override
    public NorthboundAlarm createSyncLostMessage() {
        return NorthboundAlarm.SYNC_LOST_ALARM;
    }

    public abstract void forwardAlarms(List<NorthboundAlarm> var1) throws NorthbounderException;

    protected Map<String, Object> createMapping(Map<Integer, Map<String, Object>> alarmMappings, NorthboundAlarm alarm) {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("ackUser", alarm.getAckUser());
        mapping.put("appDn", alarm.getAppDn());
        mapping.put("logMsg", alarm.getLogMsg());
        mapping.put("objectInstance", alarm.getObjectInstance());
        mapping.put("objectType", alarm.getObjectType());
        mapping.put("ossKey", alarm.getOssKey());
        mapping.put("ossState", alarm.getOssState());
        mapping.put("ticketId", alarm.getTicketId());
        mapping.put("alarmUei", alarm.getUei());
        mapping.put("ackTime", this.nullSafeToString(alarm.getAckTime(), ""));
        NorthboundAlarm.AlarmType alarmType = alarm.getAlarmType() == null ? NorthboundAlarm.AlarmType.NOTIFICATION : alarm.getAlarmType();
        mapping.put("alarmType", alarmType.name());
        String count = alarm.getCount() == null ? "1" : alarm.getCount().toString();
        mapping.put("count", count);
        mapping.put("firstOccurrence", this.nullSafeToString(alarm.getFirstOccurrence(), ""));
        mapping.put("alarmId", alarm.getId().toString());
        mapping.put("ipAddr", this.nullSafeToString(alarm.getIpAddr(), ""));
        mapping.put("lastOccurrence", this.nullSafeToString(alarm.getLastOccurrence(), ""));
        if (alarm.getNodeId() != null) {
            LOG.debug("Adding nodeId: " + alarm.getNodeId().toString());
            mapping.put("nodeId", alarm.getNodeId().toString());
            String nodeLabel = this.m_nodeDao.getLabelForId(alarm.getNodeId());
            mapping.put("nodeLabel", nodeLabel == null ? "?" : nodeLabel);
        } else {
            mapping.put("nodeId", "");
            mapping.put("nodeLabel", "");
        }
        String poller = alarm.getPoller() == null ? "localhost" : alarm.getPoller().getId();
        mapping.put("distPoller", poller);
        String service = alarm.getService() == null ? "" : alarm.getService();
        mapping.put("ifService", service);
        mapping.put("severity", this.nullSafeToString(alarm.getSeverity(), ""));
        mapping.put("ticketState", this.nullSafeToString(alarm.getTicketState(), ""));
        mapping.put("x733AlarmType", alarm.getX733Type());
        try {
            mapping.put("x733ProbableCause", this.nullSafeToString((Object)NorthboundAlarm.x733ProbableCause.get(alarm.getX733Cause()), ""));
        }
        catch (Exception e) {
            LOG.info("Exception caught setting X733 Cause: {}", (Object)alarm.getX733Cause(), (Object)e);
            mapping.put("x733ProbableCause", this.nullSafeToString((Object)NorthboundAlarm.x733ProbableCause.other, ""));
        }
        this.buildParmMappings(alarm, mapping);
        alarmMappings.put(alarm.getId(), mapping);
        return mapping;
    }

    private String nullSafeToString(Object obj, String defaultString) {
        if (obj != null) {
            defaultString = obj.toString();
        }
        return defaultString;
    }

    private void buildParmMappings(NorthboundAlarm alarm, Map<String, Object> mapping) {
        String[] parmArray;
        LinkedList<EventParm<String>> parmCollection = new LinkedList<EventParm<String>>();
        String parms = alarm.getEventParms();
        if (parms == null) {
            return;
        }
        char separator = ';';
        for (String string : parmArray = StringUtils.split((String)parms, (char)separator)) {
            char nameValueDelim = '=';
            String[] nameValueArray = StringUtils.split((String)string, (char)nameValueDelim);
            String parmName = nameValueArray[0];
            String parmValue = StringUtils.split((String)nameValueArray[1], (char)'(')[0];
            EventParm<String> eventParm = new EventParm<String>(parmName, parmValue);
            parmCollection.add(eventParm);
        }
        for (int i = 0; i < parmCollection.size(); ++i) {
            EventParm parm = (EventParm)parmCollection.get(i);
            Integer parmOffset = i + 1;
            mapping.put("parm[name-#" + parmOffset + "]", parm.getParmName());
            mapping.put("parm[#" + parmOffset + "]", parm.getParmValue().toString());
            mapping.put("parm[" + parm.getParmName() + "]", parm.getParmValue().toString());
        }
    }

    private static class EventParm<T> {
        private String m_parmName;
        private T m_parmValue;

        EventParm(String name, T value) {
            this.m_parmName = name;
            this.m_parmValue = value;
        }

        public String getParmName() {
            return this.m_parmName;
        }

        public T getParmValue() {
            return this.m_parmValue;
        }
    }
}

