/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.api;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.alarmd.api.Preservable;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.TroubleTicketState;

public class NorthboundAlarm
implements Preservable {
    public static final NorthboundAlarm SYNC_LOST_ALARM = new NorthboundAlarm(-1, "uei.opennms.org/alarmd/northbounderSyncLost");
    private final Integer m_id;
    private final String m_uei;
    private Integer m_nodeId;
    private final Date m_ackTime;
    private final String m_ackUser;
    private final AlarmType m_alarmType;
    private final String m_appDn;
    private final String m_clearKey;
    private final Integer m_count;
    private final String m_desc;
    private final OnmsDistPoller m_poller;
    private final Date m_firstOccurrence;
    private final InetAddress m_ipAddr;
    private final Date m_lastOccurrence;
    private final String m_logMsg;
    private final String m_objectInstance;
    private final String m_objectType;
    private final String m_operInst;
    private final String m_ossKey;
    private final String m_ossState;
    private final String m_alarmKey;
    private final String m_service;
    private final OnmsSeverity m_severity;
    private final Date m_suppressed;
    private final Date m_suppressedUntil;
    private final String m_suppressedBy;
    private final String m_ticketId;
    private final TroubleTicketState m_ticketState;
    private final String m_x733Type;
    private final int m_x733Cause;
    private final String m_eventParms;
    private volatile boolean m_preserved = false;

    private NorthboundAlarm(int id, String uei) {
        this.m_id = id;
        this.m_uei = uei;
        this.m_nodeId = null;
        this.m_ackTime = null;
        this.m_ackUser = null;
        this.m_alarmType = null;
        this.m_appDn = null;
        this.m_clearKey = null;
        this.m_count = null;
        this.m_desc = null;
        this.m_poller = null;
        this.m_eventParms = null;
        this.m_firstOccurrence = null;
        this.m_ipAddr = null;
        this.m_lastOccurrence = null;
        this.m_logMsg = null;
        this.m_objectInstance = null;
        this.m_objectType = null;
        this.m_operInst = null;
        this.m_ossKey = null;
        this.m_ossState = null;
        this.m_alarmKey = null;
        this.m_service = null;
        this.m_severity = null;
        this.m_suppressed = null;
        this.m_suppressedUntil = null;
        this.m_suppressedBy = null;
        this.m_ticketId = null;
        this.m_ticketState = null;
        this.m_x733Type = null;
        this.m_x733Cause = -1;
    }

    public NorthboundAlarm(OnmsAlarm alarm) {
        this.m_nodeId = alarm.getNodeId();
        this.m_ackTime = alarm.getAlarmAckTime();
        this.m_ackUser = alarm.getAlarmAckUser();
        this.m_alarmType = alarm.getAlarmType() == null ? null : AlarmType.toAlarmType(alarm.getAlarmType());
        this.m_appDn = alarm.getApplicationDN();
        this.m_clearKey = alarm.getClearKey();
        this.m_count = alarm.getCounter();
        this.m_desc = alarm.getDescription();
        this.m_poller = alarm.getDistPoller();
        this.m_eventParms = alarm.getEventParms();
        this.m_firstOccurrence = alarm.getFirstEventTime();
        this.m_id = alarm.getId();
        this.m_ipAddr = alarm.getIpAddr();
        this.m_lastOccurrence = alarm.getLastEventTime();
        this.m_logMsg = alarm.getLogMsg();
        this.m_objectInstance = alarm.getManagedObjectInstance();
        this.m_objectType = alarm.getManagedObjectType();
        this.m_operInst = alarm.getOperInstruct();
        this.m_ossKey = alarm.getOssPrimaryKey();
        this.m_ossState = alarm.getQosAlarmState();
        this.m_alarmKey = alarm.getReductionKey();
        this.m_service = alarm.getServiceType() == null ? null : alarm.getServiceType().getName();
        this.m_severity = alarm.getSeverity();
        this.m_suppressed = alarm.getSuppressedTime();
        this.m_suppressedUntil = alarm.getSuppressedUntil();
        this.m_suppressedBy = alarm.getSuppressedUser();
        this.m_ticketId = alarm.getTTicketId();
        this.m_ticketState = alarm.getTTicketState();
        this.m_uei = alarm.getUei();
        this.m_x733Type = alarm.getX733AlarmType();
        this.m_x733Cause = alarm.getX733ProbableCause();
    }

    public Integer getId() {
        return this.m_id;
    }

    public String getUei() {
        return this.m_uei;
    }

    public Date getAckTime() {
        return this.m_ackTime;
    }

    public String getAckUser() {
        return this.m_ackUser;
    }

    public AlarmType getAlarmType() {
        return this.m_alarmType;
    }

    public String getAppDn() {
        return this.m_appDn;
    }

    public String getClearKey() {
        return this.m_clearKey;
    }

    public Integer getCount() {
        return this.m_count;
    }

    public String getDesc() {
        return this.m_desc;
    }

    public OnmsDistPoller getPoller() {
        return this.m_poller;
    }

    public Date getFirstOccurrence() {
        return this.m_firstOccurrence;
    }

    public InetAddress getIpAddr() {
        return this.m_ipAddr;
    }

    public Date getLastOccurrence() {
        return this.m_lastOccurrence;
    }

    public String getLogMsg() {
        return this.m_logMsg;
    }

    public String getObjectInstance() {
        return this.m_objectInstance;
    }

    public String getObjectType() {
        return this.m_objectType;
    }

    public String getOperInst() {
        return this.m_operInst;
    }

    public String getOssKey() {
        return this.m_ossKey;
    }

    public String getOssState() {
        return this.m_ossState;
    }

    public String getAlarmKey() {
        return this.m_alarmKey;
    }

    public String getService() {
        return this.m_service;
    }

    public OnmsSeverity getSeverity() {
        return this.m_severity;
    }

    public Date getSuppressed() {
        return this.m_suppressed;
    }

    public Date getSuppressedUntil() {
        return this.m_suppressedUntil;
    }

    public String getSuppressedBy() {
        return this.m_suppressedBy;
    }

    public String getTicketId() {
        return this.m_ticketId;
    }

    public TroubleTicketState getTicketState() {
        return this.m_ticketState;
    }

    public String getX733Type() {
        return this.m_x733Type;
    }

    public int getX733Cause() {
        return this.m_x733Cause;
    }

    public String getEventParms() {
        return this.m_eventParms;
    }

    @Override
    public boolean isPreserved() {
        return this.m_preserved;
    }

    @Override
    public void setPreserved(boolean preserved) {
        this.m_preserved = preserved;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public static enum x733AlarmType {
        other(1, "other"),
        communicationsAlarm(2, "communicationsAlarm"),
        qualityOfServiceAlarm(3, "qualityOfServiceAlarm"),
        processingErrorAlarm(4, "processingErrorAlarm"),
        equipmentAlarm(5, "equipmentAlarm"),
        environmentalAlarm(6, "environmentalAlarm"),
        integrityViolation(7, "integrityViolation"),
        operationalViolation(8, "operationalViolation"),
        physicalViolation(9, "physicalViolation"),
        securityServiceOrMechanismViolation(10, "securityServiceOrMechanismViolation"),
        timeDomainViolation(11, "timeDomainViolation");

        private static Map<Integer, x733AlarmType> m_idMap;
        private int m_id;
        private String m_label;

        private x733AlarmType(int id, String label) {
            this.m_id = id;
            this.m_label = label;
        }

        public int getId() {
            return this.m_id;
        }

        public static x733AlarmType get(String label) {
            x733AlarmType cause = other;
            if (label == null) {
                return cause;
            }
            for (Integer key : m_idMap.keySet()) {
                if (!m_idMap.get(key).getLabel().equalsIgnoreCase(label)) continue;
                cause = m_idMap.get(key);
            }
            return cause;
        }

        private String getLabel() {
            return this.m_label;
        }

        public static x733AlarmType get(int id) {
            if (m_idMap.containsKey(id)) {
                return m_idMap.get(id);
            }
            throw new IllegalArgumentException("Unknown x733 Alarm Type ID requested: " + id);
        }

        static {
            m_idMap = new HashMap<Integer, x733AlarmType>(x733AlarmType.values().length);
            for (x733AlarmType type : x733AlarmType.values()) {
                m_idMap.put(type.getId(), type);
            }
        }
    }

    public static enum x733ProbableCause {
        other(1, "other"),
        adapterError(2, "adapterError"),
        applicationSubsystemFailure(3, "applicationSubsystemFailure"),
        bandwidthReduced(4, "bandwidthReduced"),
        callEstablishmentError(5, "callEstablishmentError"),
        communicationsProtocolError(6, "communicationsProtocolError"),
        communicationsSubsystemFailure(7, "communicationsSubsystemFailure"),
        configurationOrCustomizationError(8, "configurationOrCustomizationError"),
        congestion(9, "congestion"),
        corruptData(10, "corruptData"),
        cpuCyclesLimitExceeded(11, "cpuCyclesLimitExceeded"),
        dataSetOrModemError(12, "dataSetOrModemError"),
        degradedSignal(13, "degradedSignal"),
        dteDceInterfaceError(14, "dteDceInterfaceError"),
        enclosureDoorOpen(15, "enclosureDoorOpen"),
        equipmentMalfunction(16, "equipmentMalfunction"),
        excessiveVibration(17, "excessiveVibration"),
        fileError(18, "fileError"),
        fireDetected(19, "fireDetected"),
        floodDetected(20, "floodDetected"),
        framingError(21, "framingError"),
        heatingVentCoolingSystemProblem(22, "heatingVentCoolingSystemProblem"),
        humidityUnacceptable(23, "humidityUnacceptable"),
        inputOutputDeviceError(24, "inputOutputDeviceError"),
        inputDeviceError(25, "inputDeviceError"),
        lanError(26, "lanError"),
        leakDetected(27, "leakDetected"),
        localNodeTransmissionError(28, "localNodeTransmissionError"),
        lossOfFrame(29, "lossOfFrame"),
        lossOfSignal(30, "lossOfSignal"),
        materialSupplyExhausted(31, "materialSupplyExhausted"),
        multiplexerProblem(32, "multiplexerProblem"),
        outOfMemory(33, "multiplexerProblem"),
        ouputDeviceError(34, "ouputDeviceError"),
        performanceDegraded(35, "performanceDegraded"),
        powerProblem(36, "powerProblem"),
        pressureUnacceptable(37, "pressureUnacceptable"),
        processorProblem(38, "processorProblem"),
        pumpFailure(39, "pumpFailure"),
        queueSizeExceeded(40, "queueSizeExceeded"),
        receiveFailure(41, "receiveFailure"),
        receiverFailure(42, "receiverFailure"),
        remoteNodeTransmissionError(43, "remoteNodeTransmissionError"),
        resourceAtOrNearingCapacity(44, "resourceAtOrNearingCapacity"),
        responseTimeExecessive(45, "responseTimeExecessive"),
        retransmissionRateExcessive(46, "retransmissionRateExcessive"),
        softwareError(47, "softwareError"),
        softwareProgramAbnormallyTerminated(48, "softwareProgramAbnormallyTerminated"),
        softwareProgramError(49, "softwareProgramError"),
        storageCapacityProblem(50, "storageCapacityProblem"),
        temperatureUnacceptable(51, "temperatureUnacceptable"),
        thresholdCrossed(52, "thresholdCrossed"),
        timingProblem(53, "timingProblem"),
        toxicLeakDetected(54, "toxicLeakDetected"),
        transmitFailure(55, "transmitFailure"),
        transmitterFailure(56, "transmitterFailure"),
        underlyingResourceUnavailable(57, "underlyingResourceUnavailable"),
        versionMismatch(58, "versionMismatch"),
        authenticationFailure(59, "authenticationFailure"),
        breachOfConfidentiality(60, "breachOfConfidentiality"),
        cableTamper(61, "cableTamper"),
        delayedInformation(62, "delayedInformation"),
        denialOfService(63, "denialOfService"),
        duplicateInformation(64, "duplicateInformation"),
        informationMissing(65, "informationMissing"),
        informationModificationDetected(66, "informationModificationDetected"),
        informationOutOfSequence(67, "informationOutOfSequence"),
        intrusionDetection(68, "intrusionDetection"),
        keyExpired(69, "keyExpired"),
        nonRepudiationFailure(70, "nonRepudiationFailure"),
        outOfHoursActivity(71, "outOfHoursActivity"),
        outOfService(72, "outOfService"),
        proceduralError(73, "proceduralError"),
        unauthorizedAccessAttempt(74, "unauthorizedAccessAttempt"),
        unexpectedInformation(75, "unexpectedInformation");

        private static final Map<Integer, x733ProbableCause> m_idMap;
        private int m_id;
        private String m_label;

        private x733ProbableCause(int id, String label) {
            this.m_id = id;
            this.m_label = label;
        }

        public int getId() {
            return this.m_id;
        }

        public String getLabel() {
            return this.m_label;
        }

        public static x733ProbableCause get(String label) {
            x733ProbableCause cause = other;
            if (label == null) {
                return cause;
            }
            for (Integer key : m_idMap.keySet()) {
                if (!m_idMap.get(key).getLabel().equalsIgnoreCase(label)) continue;
                cause = m_idMap.get(key);
            }
            return cause;
        }

        public static x733ProbableCause get(int id) {
            if (m_idMap.containsKey(id)) {
                return m_idMap.get(id);
            }
            throw new IllegalArgumentException("Unknown x733 Probable Cause ID requested: " + id);
        }

        static {
            m_idMap = new HashMap<Integer, x733ProbableCause>(x733ProbableCause.values().length);
            for (x733ProbableCause cause : x733ProbableCause.values()) {
                m_idMap.put(cause.getId(), cause);
            }
        }
    }

    public static enum AlarmType {
        PROBLEM,
        RESOLUTION,
        NOTIFICATION;


        static AlarmType toAlarmType(int alarmType) {
            if (alarmType == 1) {
                return PROBLEM;
            }
            if (alarmType == 2) {
                return RESOLUTION;
            }
            return NOTIFICATION;
        }
    }
}

