/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.api.support;

import java.util.List;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.Northbounder;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AlarmQueue;
import org.opennms.netmgt.alarmd.api.support.StatusFactory;

public abstract class AbstractNorthbounder
implements Northbounder,
Runnable,
StatusFactory<NorthboundAlarm> {
    private final String m_name;
    private final AlarmQueue<NorthboundAlarm> m_queue;
    private volatile boolean m_stopped = true;
    private long m_retryInterval = 1000L;

    protected AbstractNorthbounder(String name) {
        this.m_name = name;
        this.m_queue = new AlarmQueue<NorthboundAlarm>(this);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setNaglesDelay(long delay) {
        this.m_queue.setNaglesDelay(delay);
    }

    public void setRetryInterval(int retryInterval) {
        this.m_retryInterval = retryInterval;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.m_queue.setMaxBatchSize(maxBatchSize);
    }

    public void setMaxPreservedAlarms(int maxPreservedAlarms) {
        this.m_queue.setMaxPreservedAlarms(maxPreservedAlarms);
    }

    protected void onPreStart() {
    }

    protected void onPostStart() {
    }

    @Override
    public final void start() throws NorthbounderException {
        if (!this.m_stopped) {
            return;
        }
        this.onPreStart();
        this.m_stopped = false;
        this.m_queue.init();
        Thread thread = new Thread((Runnable)this, this.getName() + "-Thread");
        thread.start();
        this.onPostStart();
    }

    @Override
    public final void onAlarm(NorthboundAlarm alarm) throws NorthbounderException {
        if (this.accepts(alarm)) {
            this.m_queue.accept(alarm);
        }
    }

    protected abstract boolean accepts(NorthboundAlarm var1);

    protected void preserve(NorthboundAlarm alarm) throws NorthbounderException {
        this.m_queue.preserve(alarm);
    }

    protected void discard(NorthboundAlarm alarm) throws NorthbounderException {
        this.m_queue.discard(alarm);
    }

    protected void onStop() {
    }

    @Override
    public final void stop() throws NorthbounderException {
        this.onStop();
        this.m_stopped = true;
    }

    @Override
    public void run() {
        block4: while (true) {
            try {
                while (!this.m_stopped) {
                    List<NorthboundAlarm> alarmsToForward = this.m_queue.getAlarmsToForward();
                    try {
                        this.forwardAlarms(alarmsToForward);
                        this.m_queue.forwardSuccessful(alarmsToForward);
                        continue block4;
                    }
                    catch (Exception e) {
                        this.m_queue.forwardFailed(alarmsToForward);
                        if (this.m_stopped) continue;
                        Thread.sleep(this.m_retryInterval);
                    }
                }
                break;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
    }

    @Override
    public NorthboundAlarm createSyncLostMessage() {
        return NorthboundAlarm.SYNC_LOST_ALARM;
    }

    public abstract void forwardAlarms(List<NorthboundAlarm> var1) throws NorthbounderException;
}

