/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ackd.readers;

import java.io.Closeable;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.GtRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.netmgt.ackd.readers.AckProcessor;
import org.opennms.netmgt.config.ackd.Parameter;
import org.opennms.netmgt.dao.api.AckdConfigurationDao;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HypericAckProcessor
implements AckProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(HypericAckProcessor.class);
    public static final String READER_NAME_HYPERIC = "HypericReader";
    public static final String PARAMETER_PREFIX_HYPERIC_SOURCE = "source:";
    public static final int ALERTS_PER_HTTP_TRANSACTION = 200;
    private AckdConfigurationDao m_ackdConfigDao;
    private AcknowledgmentDao m_ackDao;
    private AlarmDao m_alarmDao;

    @Override
    public void reloadConfigs() {
        LOG.debug("reloadConfigs: reloading configuration...");
        this.m_ackdConfigDao.reloadConfiguration();
        LOG.debug("reloadConfigs: configuration reloaded");
    }

    public List<OnmsAlarm> fetchUnclearedHypericAlarms() {
        Criteria criteria = new Criteria(OnmsAlarm.class);
        criteria.addRestriction((Restriction)new EqRestriction("uei", (Object)"uei.opennms.org/external/hyperic/alert"));
        criteria.addRestriction((Restriction)new GtRestriction("severity", (Object)OnmsSeverity.NORMAL));
        return this.m_alarmDao.findMatching(criteria);
    }

    public String getUrlForHypericSource(String source) {
        if (source == null) {
            throw new IllegalArgumentException("Cannot search for null Hyperic platform IDs inside the ackd configuration");
        }
        if ("".equals(source)) {
            throw new IllegalArgumentException("Cannot search for blank Hyperic platform IDs inside the ackd configuration");
        }
        List params = this.m_ackdConfigDao.getParametersForReader(READER_NAME_HYPERIC);
        if (params == null) {
            throw new IllegalStateException("There is no configuration for the 'HypericReader' reader inside the ackd configuration");
        }
        for (Parameter param : params) {
            if (!(PARAMETER_PREFIX_HYPERIC_SOURCE + source).equalsIgnoreCase(param.getKey())) continue;
            return param.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<OnmsAcknowledgment> acks = new ArrayList<OnmsAcknowledgment>();
        try {
            LOG.info("run: Processing Hyperic acknowledgments...");
            List<OnmsAlarm> unAckdAlarms = this.fetchUnclearedHypericAlarms();
            TreeMap<String, ArrayList<OnmsAlarm>> organizedAlarms = new TreeMap<String, ArrayList<OnmsAlarm>>();
            int legacyAlarmCount = 0;
            for (OnmsAlarm onmsAlarm : unAckdAlarms) {
                String key = HypericAckProcessor.getAlertSourceParmValue(onmsAlarm);
                if (key == null || "".equals(key)) {
                    ++legacyAlarmCount;
                    continue;
                }
                ArrayList<OnmsAlarm> targetList = (ArrayList<OnmsAlarm>)organizedAlarms.get(key);
                if (targetList == null) {
                    targetList = new ArrayList<OnmsAlarm>();
                    organizedAlarms.put(key, targetList);
                }
                targetList.add(onmsAlarm);
            }
            if (legacyAlarmCount > 0) {
                LOG.info("{} Hyperic alarms without an alert.source param found, these alarms will not be processed", (Object)String.valueOf(legacyAlarmCount));
            }
            for (Map.Entry entry : organizedAlarms.entrySet()) {
                String hypericSystem = (String)entry.getKey();
                List alarmsForSystem = (List)entry.getValue();
                String hypericUrl = this.getUrlForHypericSource(hypericSystem);
                if (hypericUrl == null) {
                    LOG.warn("Could not find Hyperic host URL for the following platform ID: {}", (Object)hypericSystem);
                    LOG.warn("Skipping processing of {} alarms with that platform ID", (Object)alarmsForSystem.size());
                    continue;
                }
                try {
                    ArrayList<String> alertIdList = new ArrayList<String>();
                    for (OnmsAlarm alarmForSystem : (List)entry.getValue()) {
                        String alertId = HypericAckProcessor.getAlertIdParmValue(alarmForSystem);
                        alertIdList.add(alertId);
                    }
                    List<HypericAlertStatus> alertsForSystem = HypericAckProcessor.fetchHypericAlerts(hypericUrl, alertIdList);
                    for (HypericAlertStatus alert : alertsForSystem) {
                        OnmsAcknowledgment ack;
                        OnmsAlarm alarm = HypericAckProcessor.findAlarmForHypericAlert(alarmsForSystem, hypericSystem, alert);
                        if (alarm == null) {
                            LOG.warn("Could not find the OpenNMS alarm for the following Hyperic alert: URL: \"{}\", id: {}", (Object)hypericUrl, (Object)alert.getAlertId());
                            continue;
                        }
                        if (alert.isFixed() && !OnmsSeverity.CLEARED.equals((Object)alarm.getSeverity())) {
                            ack = new OnmsAcknowledgment((Acknowledgeable)alarm, "Ackd.HypericAckProcessor", alert.getFixTime() != null ? alert.getFixTime() : new Date());
                            ack.setAckAction(AckAction.CLEAR);
                            ack.setLog(alert.getFixMessage());
                            acks.add(ack);
                            continue;
                        }
                        if (alert.getAckMessage() == null || alarm.getAckTime() != null) continue;
                        ack = new OnmsAcknowledgment((Acknowledgeable)alarm, "Ackd.HypericAckProcessor", alert.getAckTime() != null ? alert.getAckTime() : new Date());
                        ack.setAckAction(AckAction.ACKNOWLEDGE);
                        ack.setLog(alert.getAckMessage());
                        acks.add(ack);
                    }
                }
                catch (Throwable e) {
                    LOG.warn("run: threw exception when processing alarms for Hyperic system {}", (Object)hypericSystem, (Object)e.getMessage());
                    LOG.warn("run: {} acknowledgements processed successfully before exception", (Object)acks.size());
                }
                finally {
                    if (acks.size() <= 0) continue;
                    this.m_ackDao.processAcks(acks);
                }
            }
            LOG.info("run: Finished processing Hyperic acknowledgments ({} ack(s) processed for {} alarm(s))", (Object)acks.size(), (Object)unAckdAlarms.size());
        }
        catch (Throwable e) {
            LOG.warn("run: threw exception", e);
        }
    }

    public static OnmsAlarm findAlarmForHypericAlert(List<OnmsAlarm> alarms, String platformId, HypericAlertStatus alert) {
        String targetPlatformId = "alert.source=" + platformId + "(string,text)";
        String targetAlertId = "alert.id=" + String.valueOf(alert.getAlertId()) + "(string,text)";
        for (OnmsAlarm alarm : alarms) {
            String[] parms;
            String parmString = alarm.getEventParms();
            for (String parm : parms = parmString.split(";")) {
                if (!targetPlatformId.equals(parm)) continue;
                for (String alertparm : parms) {
                    if (!targetAlertId.equals(alertparm)) continue;
                    return alarm;
                }
            }
        }
        return null;
    }

    public static String getAlertSourceParmValue(OnmsAlarm alarm) {
        return HypericAckProcessor.getParmValueByRegex(alarm, "alert.source=(.*)[(]string,text[)]");
    }

    public static String getAlertIdParmValue(OnmsAlarm alarm) {
        return HypericAckProcessor.getParmValueByRegex(alarm, "alert.id=([0-9]*)[(]string,text[)]");
    }

    public static String getParmValueByRegex(OnmsAlarm alarm, String regex) {
        String[] parms;
        Pattern pattern = Pattern.compile(regex);
        String parmString = alarm.getEventParms();
        for (String parm : parms = parmString.split(";")) {
            Matcher matcher = pattern.matcher(parm);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HypericAlertStatus> fetchHypericAlerts(String hypericUrl, List<String> alertIds) throws IOException, JAXBException, XMLStreamException {
        List<HypericAlertStatus> retval = new ArrayList<HypericAlertStatus>();
        if (alertIds.size() < 1) {
            return retval;
        }
        for (int i = 0; i < alertIds.size(); ++i) {
            StringBuilder alertIdString = new StringBuilder();
            alertIdString.append("?");
            for (int j = 0; j < 200 && i < alertIds.size(); ++j, ++i) {
                if (j > 0) {
                    alertIdString.append("&");
                }
                alertIdString.append("id=").append(alertIds.get(i));
            }
            HttpClientWrapper clientWrapper = HttpClientWrapper.create().setConnectionTimeout(Integer.valueOf(3000)).setSocketTimeout(Integer.valueOf(3000)).setUserAgent("OpenNMS-Ackd.HypericAckProcessor");
            HttpGet httpMethod = new HttpGet(hypericUrl + alertIdString.toString());
            String userinfo = null;
            try {
                URI hypericUri = new URI(hypericUrl);
                userinfo = hypericUri.getUserInfo();
            }
            catch (URISyntaxException e) {
                LOG.warn("Could not parse URI to get username/password stanza: {}", (Object)hypericUrl, (Object)e);
            }
            if (userinfo != null && !"".equals(userinfo)) {
                String[] credentials = userinfo.split(":");
                if (credentials.length == 2) {
                    clientWrapper.addBasicCredentials(credentials[0], credentials[1]).usePreemptiveAuth();
                } else {
                    LOG.warn("Unable to deduce username/password from '{}'", (Object)userinfo);
                }
            }
            try {
                CloseableHttpResponse response = clientWrapper.execute((HttpUriRequest)httpMethod);
                retval = HypericAckProcessor.parseHypericAlerts(new StringReader(EntityUtils.toString((HttpEntity)response.getEntity())));
                continue;
            }
            finally {
                IOUtils.closeQuietly((Closeable)clientWrapper);
            }
        }
        return retval;
    }

    public static List<HypericAlertStatus> parseHypericAlerts(Reader reader) throws JAXBException, XMLStreamException {
        ArrayList<HypericAlertStatus> retval = new ArrayList<HypericAlertStatus>();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{HypericAlertStatuses.class, HypericAlertStatus.class});
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        XMLEventReader xmler = xmlif.createXMLEventReader(reader);
        EventFilter filter = new EventFilter(){

            @Override
            public boolean accept(XMLEvent event) {
                return event.isStartElement();
            }
        };
        XMLEventReader xmlfer = xmlif.createFilteredReader(xmler, filter);
        StartElement startElement = (StartElement)xmlfer.nextEvent();
        String rootElementName = context.createJAXBIntrospector().getElementName((Object)new HypericAlertStatuses()).getLocalPart();
        if (rootElementName.equals(startElement.getName().getLocalPart())) {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            while (xmlfer.peek() != null) {
                Object object = unmarshaller.unmarshal(xmler);
                if (!(object instanceof HypericAlertStatus)) continue;
                HypericAlertStatus alertStatus = (HypericAlertStatus)object;
                retval.add(alertStatus);
            }
        } else {
            StringBuilder errorContent = new StringBuilder();
            LineNumberReader lineReader = new LineNumberReader(reader);
            try {
                String line;
                while ((line = lineReader.readLine()) != null) {
                    errorContent.append(line.trim());
                }
            }
            catch (IOException e) {
                errorContent.append("Exception while trying to print out message content: " + e.getMessage());
            }
            throw new JAXBException("Found wrong root element in Hyperic XML document, expected: \"" + rootElementName + "\", found \"" + startElement.getName().getLocalPart() + "\"\n" + errorContent.toString());
        }
        return retval;
    }

    public synchronized void setAckdConfigDao(AckdConfigurationDao configDao) {
        this.m_ackdConfigDao = configDao;
    }

    public synchronized void setAcknowledgmentDao(AcknowledgmentDao ackDao) {
        this.m_ackDao = ackDao;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public synchronized void setAlarmDao(AlarmDao dao) {
        this.m_alarmDao = dao;
    }

    @XmlRootElement(name="alert")
    static class HypericAlertStatus {
        private int alertId;
        private String ackUser;
        private String ackMessage;
        private Date ackTime;
        private boolean isFixed;
        private String fixUser;
        private String fixMessage;
        private Date fixTime;

        HypericAlertStatus() {
        }

        @XmlAttribute(name="id", required=true)
        public int getAlertId() {
            return this.alertId;
        }

        public void setAlertId(int alertId) {
            this.alertId = alertId;
        }

        @XmlAttribute(name="fixed", required=true)
        public boolean isFixed() {
            return this.isFixed;
        }

        public void setFixed(boolean isFixed) {
            this.isFixed = isFixed;
        }

        @XmlAttribute(name="ackUser")
        public String getAckUser() {
            return this.ackUser;
        }

        public void setAckUser(String ackUser) {
            this.ackUser = ackUser;
        }

        @XmlAttribute(name="ackMessage")
        public String getAckMessage() {
            return this.ackMessage;
        }

        public void setAckMessage(String ackMessage) {
            this.ackMessage = ackMessage;
        }

        @XmlAttribute(name="ackTime")
        public Date getAckTime() {
            return this.ackTime;
        }

        public void setAckTime(Date ackTime) {
            this.ackTime = ackTime;
        }

        @XmlAttribute(name="fixUser")
        public String getFixUser() {
            return this.fixUser;
        }

        public void setFixUser(String fixUser) {
            this.fixUser = fixUser;
        }

        @XmlAttribute(name="fixMessage")
        public String getFixMessage() {
            return this.fixMessage;
        }

        public void setFixMessage(String fixMessage) {
            this.fixMessage = fixMessage;
        }

        @XmlAttribute(name="fixTime")
        public Date getFixTime() {
            return this.fixTime;
        }

        public void setFixTime(Date fixTime) {
            this.fixTime = fixTime;
        }

        public String toString() {
            StringBuilder retval = new StringBuilder();
            retval.append("{ ");
            retval.append("id: ").append(String.valueOf(this.alertId)).append(", ");
            retval.append("fixed: ").append(String.valueOf(this.isFixed)).append(", ");
            retval.append("ackUser: ").append(String.valueOf(this.ackUser)).append(", ");
            retval.append("ackMessage: ").append(String.valueOf(this.ackMessage)).append(", ");
            retval.append("ackTime: ").append(String.valueOf(this.ackTime)).append(", ");
            retval.append("fixUser: ").append(String.valueOf(this.fixUser)).append(", ");
            retval.append("fixMessage: ").append(String.valueOf(this.fixMessage)).append(", ");
            retval.append("fixTime: ").append(String.valueOf(this.fixTime));
            retval.append(" }");
            return retval.toString();
        }
    }

    @XmlRootElement(name="hyperic-alert-statuses")
    static class HypericAlertStatuses {
        private List<HypericAlertStatus> statusList;

        HypericAlertStatuses() {
        }

        @XmlElement
        public List<HypericAlertStatus> getStatusList() {
            return this.statusList;
        }

        public void setStatusList(List<HypericAlertStatus> statusList) {
            this.statusList = statusList;
        }
    }
}

