/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ackd.readers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.opennms.core.utils.StringUtils;
import org.opennms.javamail.JavaMailerException;
import org.opennms.javamail.JavaReadMailer;
import org.opennms.netmgt.ackd.readers.AckProcessor;
import org.opennms.netmgt.config.ackd.Parameter;
import org.opennms.netmgt.config.javamail.ReadmailConfig;
import org.opennms.netmgt.dao.api.AckdConfigurationDao;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.JavaMailConfigurationDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MailAckProcessor
implements AckProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MailAckProcessor.class);
    private static final int LOG_FIELD_WIDTH = 128;
    private AckdConfigurationDao m_ackdDao;
    private AcknowledgmentDao m_ackDao;
    private volatile JavaMailConfigurationDao m_jmConfigDao;

    public void afterPropertiesSet() throws Exception {
    }

    private MailAckProcessor() {
    }

    protected void findAndProcessAcks() {
        LOG.debug("findAndProcessAcks: checking for acknowledgments...");
        try {
            List<Message> msgs = this.retrieveAckMessages();
            List<OnmsAcknowledgment> acks = this.createAcks(msgs);
            if (acks != null) {
                LOG.debug("findAndProcessAcks: Found {} acks.  Processing...", (Object)acks.size());
                this.m_ackDao.processAcks(acks);
                LOG.debug("findAndProcessAcks: acks processed.");
            }
        }
        catch (JavaMailerException e) {
            LOG.error("findAndProcessAcks: Exception thrown in JavaMail", (Throwable)e);
        }
        LOG.debug("findAndProcessAcks: completed checking for and processing acknowledgments.");
    }

    protected List<OnmsAcknowledgment> createAcks(List<Message> msgs) {
        LOG.info("createAcks: Detecting and possibly creating acknowledgments from {} messages...", (Object)msgs.size());
        ArrayList<OnmsAcknowledgment> acks = null;
        if (msgs != null && msgs.size() > 0) {
            acks = new ArrayList<OnmsAcknowledgment>();
            for (Message msg : msgs) {
                try {
                    OnmsAcknowledgment ack;
                    LOG.debug("createAcks: detecting acks in message: {}", (Object)msg.getSubject());
                    Integer id = MailAckProcessor.detectId(msg.getSubject(), this.m_ackdDao.getConfig().getNotifyidMatchExpression());
                    if (id != null) {
                        ack = this.createAck(msg, id);
                        ack.setAckType(AckType.NOTIFICATION);
                        ack.setLog(MailAckProcessor.createLog(msg));
                        acks.add(ack);
                        msg.setFlag(Flags.Flag.DELETED, true);
                        LOG.debug("createAcks: found notification acknowledgment: {}", (Object)ack);
                        continue;
                    }
                    id = MailAckProcessor.detectId(msg.getSubject(), this.m_ackdDao.getConfig().getAlarmidMatchExpression());
                    if (id == null) continue;
                    ack = this.createAck(msg, id);
                    ack.setAckType(AckType.ALARM);
                    ack.setLog(MailAckProcessor.createLog(msg));
                    acks.add(ack);
                    msg.setFlag(Flags.Flag.DELETED, true);
                    LOG.debug("createAcks: found alarm acknowledgment: {}", (Object)ack);
                }
                catch (MessagingException e) {
                    LOG.error("createAcks: messaging error", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error("createAcks: IO problem", (Throwable)e);
                }
            }
        } else {
            LOG.debug("createAcks: No messages for acknowledgment processing.");
        }
        LOG.info("createAcks: Completed detecting and possibly creating acknowledgments.  Created {} acknowledgments.", (Object)(acks == null ? 0 : acks.size()));
        return acks;
    }

    protected static Integer detectId(String subject, String expression) {
        LOG.debug("detectId: Detecting aknowledgable ID from subject: {} using expression: {}", (Object)subject, (Object)expression);
        Integer id = null;
        String ackExpression = null;
        ackExpression = expression.startsWith("~") ? expression.substring(1) : expression;
        Pattern pattern = Pattern.compile(ackExpression);
        Matcher matcher = pattern.matcher(subject);
        if (matcher.matches() && matcher.groupCount() > 0) {
            id = Integer.valueOf(matcher.group(1));
            LOG.debug("detectId: found acknowledgable ID: {}", (Object)id);
        } else {
            LOG.debug("detectId: no acknowledgable ID found.");
        }
        return id;
    }

    protected OnmsAcknowledgment createAck(Message msg, Integer refId) throws MessagingException, IOException {
        String ackUser = ((InternetAddress)msg.getFrom()[0]).getAddress();
        Date ackTime = msg.getReceivedDate();
        OnmsAcknowledgment ack = new OnmsAcknowledgment(ackTime, ackUser);
        ack.setAckType(AckType.NOTIFICATION);
        ack.setAckAction(this.determineAckAction(msg));
        ack.setRefId(refId);
        return ack;
    }

    protected AckAction determineAckAction(Message msg) throws IOException, MessagingException {
        LOG.info("determineAckAcktion: evaluating message looking for user specified acktion...");
        List messageText = JavaReadMailer.getText((Message)msg);
        AckAction action = AckAction.UNSPECIFIED;
        if (messageText != null && messageText.size() > 0) {
            LOG.debug("determineAction: message text: {}", (Object)messageText);
            action = this.m_ackdDao.acknowledgmentMatch(messageText).booleanValue() ? AckAction.ACKNOWLEDGE : (this.m_ackdDao.clearMatch(messageText).booleanValue() ? AckAction.CLEAR : (this.m_ackdDao.escalationMatch(messageText).booleanValue() ? AckAction.ESCALATE : (this.m_ackdDao.unAcknowledgmentMatch(messageText).booleanValue() ? AckAction.UNACKNOWLEDGE : AckAction.UNSPECIFIED)));
        } else {
            String concern = "determineAckAction: a reply message to a notification has no text to evaluate.  No action can be determined.";
            LOG.warn(concern);
            throw new MessagingException(concern);
        }
        LOG.info("determineAckAcktion: evaluated message, {} action determined from message.", (Object)action);
        return action;
    }

    protected List<Message> retrieveAckMessages() throws JavaMailerException {
        LOG.debug("retrieveAckMessages: Retrieving messages...");
        ReadmailConfig readMailConfig = this.determineMailReaderConfig();
        LOG.debug("retrieveAckMessages: creating JavaReadMailer with config: host: {} port: {} ssl: {} transport: {} user: {} password: {}", new Object[]{readMailConfig.getReadmailHost().getHost(), readMailConfig.getReadmailHost().getPort(), readMailConfig.getReadmailHost().getReadmailProtocol().getSslEnable(), readMailConfig.getReadmailHost().getReadmailProtocol().getTransport(), readMailConfig.getUserAuth().getUserName(), readMailConfig.getUserAuth().getPassword()});
        JavaReadMailer readMailer = new JavaReadMailer(readMailConfig, Boolean.valueOf(true));
        String notifRe = this.m_ackdDao.getConfig().getNotifyidMatchExpression();
        notifRe = notifRe.startsWith("~") ? notifRe.substring(1) : notifRe;
        String alarmRe = this.m_ackdDao.getConfig().getAlarmidMatchExpression();
        alarmRe = alarmRe.startsWith("~") ? alarmRe.substring(1) : alarmRe;
        Pattern notifPattern = Pattern.compile(notifRe);
        Pattern alarmPattern = Pattern.compile(alarmRe);
        List msgs = readMailer.retrieveMessages();
        LOG.info("retrieveAckMessages: Iterating {} messages with notif expression: {} and alarm expression: {}", new Object[]{msgs.size(), notifRe, alarmRe});
        Iterator iterator = msgs.iterator();
        while (iterator.hasNext()) {
            Message msg = (Message)iterator.next();
            try {
                String subject = msg.getSubject();
                Matcher alarmMatcher = alarmPattern.matcher(subject);
                Matcher notifMatcher = notifPattern.matcher(subject);
                LOG.debug("retrieveAckMessages: comparing the subject: {}", (Object)subject);
                if (!notifMatcher.matches() && !alarmMatcher.matches()) {
                    LOG.debug("retrieveAckMessages: Subject doesn't match either expression.");
                    iterator.remove();
                    continue;
                }
                LOG.debug("retrieveAckMessages: Subject matched, setting deleted flag");
                if (!readMailConfig.isDeleteAllMail()) continue;
                msg.setFlag(Flags.Flag.DELETED, true);
            }
            catch (Throwable t) {
                LOG.error("retrieveAckMessages: Problem processing message: {}", t);
            }
        }
        return msgs;
    }

    private static String createLog(Message msg) {
        Enumeration allHeaders;
        StringBuilder bldr = new StringBuilder();
        try {
            allHeaders = msg.getAllHeaders();
        }
        catch (MessagingException e) {
            return null;
        }
        while (allHeaders.hasMoreElements()) {
            Header header = (Header)allHeaders.nextElement();
            String name = header.getName();
            String value = header.getValue();
            bldr.append(name);
            bldr.append(":");
            bldr.append(value);
            bldr.append("\n");
        }
        return StringUtils.truncate((String)bldr.toString(), (int)128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            LOG.info("run: Processing mail acknowledgments (opposed to femail acks ;)...");
            this.findAndProcessAcks();
            LOG.info("run: Finished processing mail acknowledgments.");
        }
        catch (Throwable e) {
            LOG.debug("run: threw exception", e);
        }
        finally {
            LOG.debug("run: method completed.");
        }
    }

    public ReadmailConfig determineMailReaderConfig() {
        LOG.info("determineMailReaderConfig: determining mail reader configuration...");
        List parms = this.m_ackdDao.getParametersForReader("JavaMailReader");
        ReadmailConfig config = this.m_jmConfigDao.getDefaultReadmailConfig();
        for (Parameter parameter : parms) {
            if (!"readmail-config".equalsIgnoreCase(parameter.getKey())) continue;
            config = this.m_jmConfigDao.getReadMailConfig(parameter.getValue());
        }
        LOG.info("determinedMailReaderConfig: {}", (Object)config);
        return config;
    }

    public synchronized void setAckdConfigDao(AckdConfigurationDao configDao) {
        this.m_ackdDao = configDao;
    }

    public synchronized void setAcknowledgmentDao(AcknowledgmentDao ackDao) {
        this.m_ackDao = ackDao;
    }

    @Override
    public synchronized void reloadConfigs() {
        LOG.debug("reloadConfigs: lock acquired; reloading configuration...");
        this.m_jmConfigDao.reloadConfiguration();
        LOG.debug("reloadConfigs: configuration reloaded");
    }

    protected JavaMailConfigurationDao getJmConfigDao() {
        return this.m_jmConfigDao;
    }

    public void setJmConfigDao(JavaMailConfigurationDao jmConfigDao) {
        this.m_jmConfigDao = jmConfigDao;
    }
}

