/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ackd;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ackd.AckReader;
import org.opennms.netmgt.ackd.readers.ReaderSchedule;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.dao.AckdConfigurationDao;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.acknowledgments.AckService;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.springframework.beans.factory.DisposableBean;

@EventListener(name="Ackd")
public class Ackd
implements SpringServiceDaemon,
DisposableBean {
    public static final String NAME = "Ackd";
    private volatile AckdConfigurationDao m_configDao;
    private volatile EventForwarder m_eventForwarder;
    private volatile ScheduledThreadPoolExecutor m_executor;
    private List<AckReader> m_ackReaders;
    private AckService m_ackService;
    private Object m_lock = new Object();

    public void start() {
        this.log().info("start: Starting " + this.m_ackReaders.size() + " readers...");
        this.startReaders();
        this.log().info("start: readers started.");
    }

    public void destroy() {
        this.log().info("destroy: shutting down readers...");
        try {
            this.stopReaders();
            this.m_executor.purge();
            this.m_executor.shutdown();
            this.m_executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            this.log().error("destroy: error destroying readers." + e, e);
            this.m_executor.shutdownNow();
        }
        this.log().info("destroy: readers shutdown.");
    }

    protected void startReaders() {
        this.startReaders(false);
    }

    protected void startReaders(boolean reloadConfig) {
        int enabledReaderCount = this.getConfigDao().getEnabledReaderCount();
        if (enabledReaderCount < 1) {
            this.log().info("startReaders: there are not readers enabled in the configuration.");
            return;
        }
        this.m_executor.setCorePoolSize(enabledReaderCount);
        this.log().info("startReaders: starting " + enabledReaderCount + " enabled readers of " + this.m_ackReaders.size() + " readers registered.");
        for (AckReader reader : this.m_ackReaders) {
            this.log().debug("startReaders: starting reader: " + reader.getName());
            ArrayList<AckReader.AckReaderState> allowedStates = new ArrayList<AckReader.AckReaderState>();
            allowedStates.add(AckReader.AckReaderState.STOPPED);
            try {
                this.adjustReaderState(reader, AckReader.AckReaderState.STARTED, allowedStates, reloadConfig);
            }
            catch (Throwable e) {
                this.log().error("startReaders: Could not start reader: " + reader.getName(), e);
                continue;
            }
            this.log().debug("startReaders: reader: " + reader.getName() + " started.");
        }
        this.log().info("startReaders: " + this.m_ackReaders.size() + " readers started.");
    }

    protected void stopReaders() {
        this.log().info("stopReaders: stopping " + this.m_ackReaders.size() + " readers...");
        for (AckReader reader : this.m_ackReaders) {
            this.log().debug("stopReaders: stopping reader: " + reader.getName());
            ArrayList<AckReader.AckReaderState> allowedStates = new ArrayList<AckReader.AckReaderState>();
            allowedStates.add(AckReader.AckReaderState.PAUSE_PENDING);
            allowedStates.add(AckReader.AckReaderState.PAUSED);
            allowedStates.add(AckReader.AckReaderState.RESUME_PENDING);
            allowedStates.add(AckReader.AckReaderState.RESUMED);
            allowedStates.add(AckReader.AckReaderState.STARTED);
            allowedStates.add(AckReader.AckReaderState.START_PENDING);
            allowedStates.add(AckReader.AckReaderState.STOP_PENDING);
            try {
                this.adjustReaderState(reader, AckReader.AckReaderState.STOPPED, allowedStates, false);
            }
            catch (Throwable e) {
                this.log().error("startReaders: Could not stop reader: " + reader.getName(), e);
            }
            this.log().debug("stopReaders: reader: " + reader.getName() + " stopped.");
        }
        this.log().info("stopReaders: " + this.m_ackReaders.size() + " readers stopped.");
    }

    protected void pauseReaders() {
        for (AckReader reader : this.m_ackReaders) {
            ArrayList<AckReader.AckReaderState> allowedStates = new ArrayList<AckReader.AckReaderState>();
            allowedStates.add(AckReader.AckReaderState.STARTED);
            allowedStates.add(AckReader.AckReaderState.RESUMED);
            try {
                this.adjustReaderState(reader, AckReader.AckReaderState.PAUSED, allowedStates, false);
            }
            catch (Throwable e) {
                this.log().error("startReaders: Could not pause reader: " + reader.getName(), e);
            }
        }
    }

    protected void resumeReaders() {
        for (AckReader reader : this.m_ackReaders) {
            ArrayList<AckReader.AckReaderState> allowedStates = new ArrayList<AckReader.AckReaderState>();
            allowedStates.add(AckReader.AckReaderState.PAUSED);
            try {
                this.adjustReaderState(reader, AckReader.AckReaderState.RESUMED, allowedStates, false);
            }
            catch (Throwable e) {
                this.log().error("startReaders: Could not resume reader: " + reader.getName(), e);
            }
        }
    }

    protected void restartReaders(boolean reloadConfigs) {
        this.log().info("restartReaders: restarting readers...");
        this.stopReaders();
        this.startReaders(reloadConfigs);
        this.log().info("restartReaders: readers restarted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void adjustReaderState(AckReader reader, AckReader.AckReaderState requestedState, List<AckReader.AckReaderState> allowedCurrentStates, boolean reloadConfig) {
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.getConfigDao().isReaderEnabled(reader.getName())) {
                if (!AckReader.AckReaderState.STOPPED.equals((Object)reader.getState())) {
                    this.log().warn("adjustReaderState: ignoring requested state and stopping the disabled reader: " + reader.getName() + "...");
                    reader.stop();
                    this.log().warn("adjustReaderState: disabled reader: " + reader.getName() + " stopped");
                    return;
                }
                this.log().warn("adjustReaderState: Not adjustingReaderState, disabled reader: " + reader.getName());
                return;
            }
            if (!allowedCurrentStates.contains((Object)reader.getState())) {
                IllegalStateException e = new IllegalStateException("error adjusting reader state; reader cannot be change from: " + (Object)((Object)reader.getState()) + " to: " + (Object)((Object)requestedState));
                this.log().error(e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
            this.log().debug("adjustReaderState: adjusting reader state from: " + (Object)((Object)reader.getState()) + " to: " + (Object)((Object)requestedState) + "...");
            org.opennms.netmgt.config.ackd.ReaderSchedule configSchedule = this.getConfigDao().getReaderSchedule(reader.getName());
            long interval = configSchedule.getInterval();
            String unit = configSchedule.getUnit();
            if (AckReader.AckReaderState.STARTED.equals((Object)requestedState)) {
                reader.start(this.m_executor, ReaderSchedule.createSchedule(interval, unit), reloadConfig);
            } else if (AckReader.AckReaderState.STOPPED.equals((Object)requestedState)) {
                reader.stop();
            } else if (AckReader.AckReaderState.PAUSED.equals((Object)requestedState)) {
                reader.pause();
            } else {
                if (!AckReader.AckReaderState.RESUMED.equals((Object)requestedState)) {
                    IllegalStateException e = new IllegalStateException("adjustReaderState: cannot request state: " + (Object)((Object)requestedState));
                    this.log().error(e.getLocalizedMessage(), (Throwable)e);
                    throw e;
                }
                reader.resume(this.m_executor);
            }
            return;
        }
    }

    @EventHandler(uei="uei.opennms.org/ackd/acknowledge")
    public void handleAckEvent(Event event) {
        this.log().info("handleAckEvent: Received acknowledgment event: " + event);
        try {
            OnmsAcknowledgment ack = new OnmsAcknowledgment(event);
            this.m_ackService.processAck(ack);
        }
        catch (ParseException e) {
            this.log().error("handleAckEvent: unable to process acknowledgment event: " + event + "\t" + e);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event event) {
        String specifiedDaemon = null;
        this.log().info("handleReloadConfigEvent: processing reload event: " + event + "...");
        List parms = event.getParmCollection();
        for (Parm parm : parms) {
            specifiedDaemon = parm.getValue().getContent();
            if (!"daemonName".equals(parm.getParmName()) || !this.getName().equalsIgnoreCase(specifiedDaemon)) continue;
            this.log().debug("handleReloadConfigEvent: reload event is for this daemon: " + this.getName() + "; reloading configuration...");
            try {
                this.m_configDao.reloadConfiguration();
                EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName(), Calendar.getInstance().getTime());
                bldr.addParam("daemonName", this.getName());
                this.m_eventForwarder.sendNow(bldr.getEvent());
                this.log().debug("handleReloadConfigEvent: restarting readers due to reload configuration event...");
                this.restartReaders(true);
            }
            catch (Throwable e) {
                this.log().error("handleReloadConfigEvent: " + e, e);
                EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName(), Calendar.getInstance().getTime());
                bldr.addParam("daemonName", this.getName());
                bldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
                this.m_eventForwarder.sendNow(bldr.getEvent());
            }
            this.log().debug("handleReloadConfigEvent: configuration reloaded.");
            return;
        }
        this.log().debug("handleReloadConfigEvent: reload event not for this daemon: " + this.getName() + "; daemon specified is: " + specifiedDaemon);
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance((String)this.getName());
    }

    public void setExecutor(ScheduledThreadPoolExecutor executor) {
        this.m_executor = executor;
    }

    public ScheduledThreadPoolExecutor getExecutor() {
        return this.m_executor;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    protected List<AckReader> getAckReaders() {
        return this.m_ackReaders;
    }

    public void setAckReaders(List<AckReader> ackReaders) {
        this.m_ackReaders = ackReaders;
    }

    public AckService getAckService() {
        return this.m_ackService;
    }

    public void setAckService(AckService ackService) {
        this.m_ackService = ackService;
    }

    public AckdConfigurationDao getConfigDao() {
        return this.m_configDao;
    }

    public void setConfigDao(AckdConfigurationDao config) {
        this.m_configDao = config;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public String getName() {
        return NAME;
    }
}

