/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ackd.readers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.opennms.core.utils.StringUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.javamail.JavaMailerException;
import org.opennms.javamail.JavaReadMailer;
import org.opennms.netmgt.ackd.readers.AckProcessor;
import org.opennms.netmgt.config.ackd.Parameter;
import org.opennms.netmgt.config.javamail.ReadmailConfig;
import org.opennms.netmgt.dao.AckdConfigurationDao;
import org.opennms.netmgt.dao.JavaMailConfigurationDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.acknowledgments.AckService;

class MailAckProcessor
implements AckProcessor {
    private static final int LOG_FIELD_WIDTH = 128;
    private AckdConfigurationDao m_ackdDao;
    private AckService m_ackService;
    private volatile JavaMailConfigurationDao m_jmConfigDao;

    public void afterPropertiesSet() throws Exception {
    }

    private MailAckProcessor() {
    }

    protected void findAndProcessAcks() {
        MailAckProcessor.log().debug("findAndProcessAcks: checking for acknowledgments...");
        try {
            List<Message> msgs = this.retrieveAckMessages();
            List<OnmsAcknowledgment> acks = this.createAcks(msgs);
            if (acks != null) {
                MailAckProcessor.log().debug("findAndProcessAcks: Found " + acks.size() + " acks.  Processing...");
                this.m_ackService.processAcks(acks);
                MailAckProcessor.log().debug("findAndProcessAcks: acks processed.");
            }
        }
        catch (JavaMailerException e) {
            MailAckProcessor.log().error("findAndProcessAcks: Exception thrown in JavaMail: " + (Object)((Object)e), (Throwable)e);
        }
        MailAckProcessor.log().debug("findAndProcessAcks: completed checking for and processing acknowledgments.");
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(MailAckProcessor.class);
    }

    protected List<OnmsAcknowledgment> createAcks(List<Message> msgs) {
        MailAckProcessor.log().info("createAcks: Detecting and possibly creating acknowledgments from " + msgs.size() + " messages...");
        ArrayList<OnmsAcknowledgment> acks = null;
        if (msgs != null && msgs.size() > 0) {
            acks = new ArrayList<OnmsAcknowledgment>();
            for (Message msg : msgs) {
                try {
                    OnmsAcknowledgment ack;
                    MailAckProcessor.log().debug("createAcks: detecting acks in message: " + msg.getSubject());
                    Integer id = MailAckProcessor.detectId(msg.getSubject(), this.m_ackdDao.getConfig().getNotifyidMatchExpression());
                    if (id != null) {
                        ack = this.createAck(msg, id);
                        ack.setAckType(AckType.NOTIFICATION);
                        ack.setLog(MailAckProcessor.createLog(msg));
                        acks.add(ack);
                        msg.setFlag(Flags.Flag.DELETED, true);
                        MailAckProcessor.log().debug("createAcks: found notification acknowledgment: " + ack);
                        continue;
                    }
                    id = MailAckProcessor.detectId(msg.getSubject(), this.m_ackdDao.getConfig().getAlarmidMatchExpression());
                    if (id == null) continue;
                    ack = this.createAck(msg, id);
                    ack.setAckType(AckType.ALARM);
                    ack.setLog(MailAckProcessor.createLog(msg));
                    acks.add(ack);
                    msg.setFlag(Flags.Flag.DELETED, true);
                    MailAckProcessor.log().debug("createAcks: found alarm acknowledgment." + ack);
                }
                catch (MessagingException e) {
                    MailAckProcessor.log().error("createAcks: messaging error: " + (Object)((Object)e));
                }
                catch (IOException e) {
                    MailAckProcessor.log().error("createAcks: IO problem: " + e);
                }
            }
        } else {
            MailAckProcessor.log().debug("createAcks: No messages for acknowledgment processing.");
        }
        MailAckProcessor.log().info("createAcks: Completed detecting and possibly creating acknowledgments.  Created " + (acks == null ? 0 : acks.size()) + " acknowledgments.");
        return acks;
    }

    protected static Integer detectId(String subject, String expression) {
        MailAckProcessor.log().debug("detectId: Detecting aknowledgable ID from subject: " + subject + " using expression: " + expression);
        Integer id = null;
        String ackExpression = null;
        ackExpression = expression.startsWith("~") ? expression.substring(1) : expression;
        Pattern pattern = Pattern.compile(ackExpression);
        Matcher matcher = pattern.matcher(subject);
        if (matcher.matches() && matcher.groupCount() > 0) {
            id = Integer.valueOf(matcher.group(1));
            MailAckProcessor.log().debug("detectId: found acknowledgable ID: " + id);
        } else {
            MailAckProcessor.log().debug("detectId: no acknowledgable ID found.");
        }
        return id;
    }

    protected OnmsAcknowledgment createAck(Message msg, Integer refId) throws MessagingException, IOException {
        String ackUser = ((InternetAddress)msg.getFrom()[0]).getAddress();
        Date ackTime = msg.getReceivedDate();
        OnmsAcknowledgment ack = new OnmsAcknowledgment(ackTime, ackUser);
        ack.setAckType(AckType.NOTIFICATION);
        ack.setAckAction(this.determineAckAction(msg));
        ack.setRefId(refId);
        return ack;
    }

    protected AckAction determineAckAction(Message msg) throws IOException, MessagingException {
        MailAckProcessor.log().info("determineAckAcktion: evaluating message looking for user specified acktion...");
        List messageText = JavaReadMailer.getText((Message)msg);
        AckAction action = AckAction.UNSPECIFIED;
        if (messageText != null && messageText.size() > 0) {
            MailAckProcessor.log().debug("determineAction: message text: " + messageText);
            action = this.m_ackdDao.acknowledgmentMatch(messageText).booleanValue() ? AckAction.ACKNOWLEDGE : (this.m_ackdDao.clearMatch(messageText).booleanValue() ? AckAction.CLEAR : (this.m_ackdDao.escalationMatch(messageText).booleanValue() ? AckAction.ESCALATE : (this.m_ackdDao.unAcknowledgmentMatch(messageText).booleanValue() ? AckAction.UNACKNOWLEDGE : AckAction.UNSPECIFIED)));
        } else {
            String concern = "determineAckAction: a reply message to a notification has no text to evaluate.  No action can be determined.";
            MailAckProcessor.log().warn(concern);
            throw new MessagingException(concern);
        }
        MailAckProcessor.log().info("determineAckAcktion: evaluated message, " + action + " action determined from message.");
        return action;
    }

    protected List<Message> retrieveAckMessages() throws JavaMailerException {
        MailAckProcessor.log().debug("retrieveAckMessages: Retrieving messages...");
        ReadmailConfig readMailConfig = this.determineMailReaderConfig();
        MailAckProcessor.log().debug("retrieveAckMessages: creating JavaReadMailer with config: host: " + readMailConfig.getReadmailHost().getHost() + " port: " + readMailConfig.getReadmailHost().getPort() + " ssl: " + readMailConfig.getReadmailHost().getReadmailProtocol().getSslEnable() + " transport: " + readMailConfig.getReadmailHost().getReadmailProtocol().getTransport() + " user: " + readMailConfig.getUserAuth().getUserName() + " password: " + readMailConfig.getUserAuth().getPassword());
        JavaReadMailer readMailer = new JavaReadMailer(readMailConfig, Boolean.valueOf(true));
        String notifRe = this.m_ackdDao.getConfig().getNotifyidMatchExpression();
        notifRe = notifRe.startsWith("~") ? notifRe.substring(1) : notifRe;
        String alarmRe = this.m_ackdDao.getConfig().getAlarmidMatchExpression();
        alarmRe = alarmRe.startsWith("~") ? alarmRe.substring(1) : alarmRe;
        Pattern notifPattern = Pattern.compile(notifRe);
        Pattern alarmPattern = Pattern.compile(alarmRe);
        List msgs = readMailer.retrieveMessages();
        MailAckProcessor.log().info("retrieveAckMessages: Iterating " + msgs.size() + " messages with notif expression: " + notifRe + " and alarm expression: " + alarmRe);
        Iterator iterator = msgs.iterator();
        while (iterator.hasNext()) {
            Message msg = (Message)iterator.next();
            try {
                String subject = msg.getSubject();
                Matcher alarmMatcher = alarmPattern.matcher(subject);
                Matcher notifMatcher = notifPattern.matcher(subject);
                MailAckProcessor.log().debug("retrieveAckMessages: comparing the subject: " + subject);
                if (!notifMatcher.matches() && !alarmMatcher.matches()) {
                    MailAckProcessor.log().debug("retrieveAckMessages: Subject doesn't match either expression.");
                    iterator.remove();
                    continue;
                }
                MailAckProcessor.log().debug("retrieveAckMessages: Subject matched, setting deleted flag");
                if (!readMailConfig.isDeleteAllMail()) continue;
                msg.setFlag(Flags.Flag.DELETED, true);
            }
            catch (Throwable t) {
                MailAckProcessor.log().error("retrieveAckMessages: Problem processing message: " + t);
            }
        }
        return msgs;
    }

    private static String createLog(Message msg) {
        Enumeration allHeaders;
        StringBuilder bldr = new StringBuilder();
        try {
            allHeaders = msg.getAllHeaders();
        }
        catch (MessagingException e) {
            return null;
        }
        while (allHeaders.hasMoreElements()) {
            Header header = (Header)allHeaders.nextElement();
            String name = header.getName();
            String value = header.getValue();
            bldr.append(name);
            bldr.append(":");
            bldr.append(value);
            bldr.append("\n");
        }
        return StringUtils.truncate((String)bldr.toString(), (int)128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            MailAckProcessor.log().info("run: Processing mail acknowledgments (opposed to femail acks ;)...");
            this.findAndProcessAcks();
            MailAckProcessor.log().info("run: Finished processing mail acknowledgments.");
        }
        catch (Throwable e) {
            MailAckProcessor.log().debug("run: threw exception: " + e, e);
        }
        finally {
            MailAckProcessor.log().debug("run: method completed.");
        }
    }

    public ReadmailConfig determineMailReaderConfig() {
        MailAckProcessor.log().info("determineMailReaderConfig: determining mail reader configuration...");
        List parms = this.m_ackdDao.getParametersForReader("JavaMailReader");
        ReadmailConfig config = this.m_jmConfigDao.getDefaultReadmailConfig();
        for (Parameter parameter : parms) {
            if (!"readmail-config".equalsIgnoreCase(parameter.getKey())) continue;
            config = this.m_jmConfigDao.getReadMailConfig(parameter.getValue());
        }
        MailAckProcessor.log().info("determinedMailReaderConfig: " + config);
        return config;
    }

    public synchronized void setAckdConfigDao(AckdConfigurationDao configDao) {
        this.m_ackdDao = configDao;
    }

    public synchronized void setAckService(AckService ackService) {
        this.m_ackService = ackService;
    }

    @Override
    public synchronized void reloadConfigs() {
        MailAckProcessor.log().debug("reloadConfigs: lock acquired; reloading configuration...");
        this.m_jmConfigDao.reloadConfiguration();
        MailAckProcessor.log().debug("reloadConfigs: configuration reloaded");
    }

    protected JavaMailConfigurationDao getJmConfigDao() {
        return this.m_jmConfigDao;
    }

    public void setJmConfigDao(JavaMailConfigurationDao jmConfigDao) {
        this.m_jmConfigDao = jmConfigDao;
    }
}

