/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ackd.readers;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ackd.readers.AckProcessor;
import org.opennms.netmgt.config.ackd.Parameter;
import org.opennms.netmgt.dao.AckdConfigurationDao;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.acknowledgments.AckService;

public class HypericAckProcessor
implements AckProcessor {
    public static final String READER_NAME_HYPERIC = "HypericReader";
    public static final String PARAMETER_PREFIX_HYPERIC_SOURCE = "source:";
    public static final int ALERTS_PER_HTTP_TRANSACTION = 200;
    private AckdConfigurationDao m_ackdDao;
    private AlarmDao m_alarmDao;
    private AckService m_ackService;

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(HypericAckProcessor.class);
    }

    @Override
    public void reloadConfigs() {
        HypericAckProcessor.log().debug("reloadConfigs: reloading configuration...");
        this.m_ackdDao.reloadConfiguration();
        HypericAckProcessor.log().debug("reloadConfigs: configuration reloaded");
    }

    public List<OnmsAlarm> fetchUnclearedHypericAlarms() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAlarm.class, "alarm");
        criteria.add((Criterion)Restrictions.eq((String)"uei", (Object)"uei.opennms.org/external/hyperic/alert"));
        criteria.add((Criterion)Restrictions.gt((String)"severity", (Object)OnmsSeverity.NORMAL));
        return this.m_alarmDao.findMatching(criteria);
    }

    public String getUrlForHypericSource(String source) {
        if (source == null) {
            throw new IllegalArgumentException("Cannot search for null Hyperic platform IDs inside the ackd configuration");
        }
        if ("".equals(source)) {
            throw new IllegalArgumentException("Cannot search for blank Hyperic platform IDs inside the ackd configuration");
        }
        List params = this.m_ackdDao.getParametersForReader(READER_NAME_HYPERIC);
        if (params == null) {
            throw new IllegalStateException("There is no configuration for the 'HypericReader' reader inside the ackd configuration");
        }
        for (Parameter param : params) {
            if (!(PARAMETER_PREFIX_HYPERIC_SOURCE + source).equalsIgnoreCase(param.getKey())) continue;
            return param.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<OnmsAcknowledgment> acks = new ArrayList<OnmsAcknowledgment>();
        try {
            HypericAckProcessor.log().info("run: Processing Hyperic acknowledgments...");
            List<OnmsAlarm> unAckdAlarms = this.fetchUnclearedHypericAlarms();
            TreeMap<String, ArrayList<OnmsAlarm>> organizedAlarms = new TreeMap<String, ArrayList<OnmsAlarm>>();
            int legacyAlarmCount = 0;
            for (OnmsAlarm onmsAlarm : unAckdAlarms) {
                String key = HypericAckProcessor.getAlertSourceParmValue(onmsAlarm);
                if (key == null || "".equals(key)) {
                    ++legacyAlarmCount;
                    continue;
                }
                ArrayList<OnmsAlarm> targetList = (ArrayList<OnmsAlarm>)organizedAlarms.get(key);
                if (targetList == null) {
                    targetList = new ArrayList<OnmsAlarm>();
                    organizedAlarms.put(key, targetList);
                }
                targetList.add(onmsAlarm);
            }
            if (legacyAlarmCount > 0) {
                HypericAckProcessor.log().info(String.valueOf(legacyAlarmCount) + " Hyperic alarms without an alert.source param found, these alarms will not be processed");
            }
            for (Map.Entry entry : organizedAlarms.entrySet()) {
                String hypericSystem = (String)entry.getKey();
                List alarmsForSystem = (List)entry.getValue();
                String hypericUrl = this.getUrlForHypericSource(hypericSystem);
                if (hypericUrl == null) {
                    HypericAckProcessor.log().warn("Could not find Hyperic host URL for the following platform ID: " + hypericSystem);
                    HypericAckProcessor.log().warn("Skipping processing of " + alarmsForSystem.size() + " alarms with that platform ID");
                    continue;
                }
                try {
                    ArrayList<String> alertIdList = new ArrayList<String>();
                    for (OnmsAlarm alarmForSystem : (List)entry.getValue()) {
                        String alertId = HypericAckProcessor.getAlertIdParmValue(alarmForSystem);
                        alertIdList.add(alertId);
                    }
                    List<HypericAlertStatus> alertsForSystem = HypericAckProcessor.fetchHypericAlerts(hypericUrl, alertIdList);
                    for (HypericAlertStatus alert : alertsForSystem) {
                        OnmsAcknowledgment ack;
                        OnmsAlarm alarm = HypericAckProcessor.findAlarmForHypericAlert(alarmsForSystem, hypericSystem, alert);
                        if (alarm == null) {
                            HypericAckProcessor.log().warn("Could not find the OpenNMS alarm for the following Hyperic alert: URL: \"" + hypericUrl + "\", id: " + alert.getAlertId());
                            continue;
                        }
                        if (alert.isFixed() && !OnmsSeverity.CLEARED.equals((Object)alarm.getSeverity())) {
                            ack = new OnmsAcknowledgment((Acknowledgeable)alarm, "Ackd.HypericAckProcessor", alert.getFixTime() != null ? alert.getFixTime() : new Date());
                            ack.setAckAction(AckAction.CLEAR);
                            ack.setLog(alert.getFixMessage());
                            acks.add(ack);
                            continue;
                        }
                        if (alert.getAckMessage() == null || alarm.getAckTime() != null) continue;
                        ack = new OnmsAcknowledgment((Acknowledgeable)alarm, "Ackd.HypericAckProcessor", alert.getAckTime() != null ? alert.getAckTime() : new Date());
                        ack.setAckAction(AckAction.ACKNOWLEDGE);
                        ack.setLog(alert.getAckMessage());
                        acks.add(ack);
                    }
                }
                catch (Throwable e) {
                    HypericAckProcessor.log().warn("run: threw exception when processing alarms for Hyperic system " + hypericSystem + ": " + e.getMessage());
                    HypericAckProcessor.log().warn("run: " + acks.size() + " acknowledgements processed successfully before exception");
                }
                finally {
                    if (acks.size() <= 0) continue;
                    this.m_ackService.processAcks(acks);
                }
            }
            HypericAckProcessor.log().info("run: Finished processing Hyperic acknowledgments (" + acks.size() + " ack(s) processed for " + unAckdAlarms.size() + " alarm(s))");
        }
        catch (Throwable e) {
            HypericAckProcessor.log().warn("run: threw exception: " + e.getMessage(), e);
        }
    }

    public static OnmsAlarm findAlarmForHypericAlert(List<OnmsAlarm> alarms, String platformId, HypericAlertStatus alert) {
        String targetPlatformId = "alert.source=" + platformId + "(string,text)";
        String targetAlertId = "alert.id=" + String.valueOf(alert.getAlertId()) + "(string,text)";
        for (OnmsAlarm alarm : alarms) {
            String[] parms;
            String parmString = alarm.getEventParms();
            for (String parm : parms = parmString.split(";")) {
                if (!targetPlatformId.equals(parm)) continue;
                for (String alertparm : parms) {
                    if (!targetAlertId.equals(alertparm)) continue;
                    return alarm;
                }
            }
        }
        return null;
    }

    public static String getAlertSourceParmValue(OnmsAlarm alarm) {
        return HypericAckProcessor.getParmValueByRegex(alarm, "alert.source=(.*)[(]string,text[)]");
    }

    public static String getAlertIdParmValue(OnmsAlarm alarm) {
        return HypericAckProcessor.getParmValueByRegex(alarm, "alert.id=([0-9]*)[(]string,text[)]");
    }

    public static String getParmValueByRegex(OnmsAlarm alarm, String regex) {
        String[] parms;
        Pattern pattern = Pattern.compile(regex);
        String parmString = alarm.getEventParms();
        for (String parm : parms = parmString.split(";")) {
            Matcher matcher = pattern.matcher(parm);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HypericAlertStatus> fetchHypericAlerts(String hypericUrl, List<String> alertIds) throws IOException, JAXBException, XMLStreamException {
        List<HypericAlertStatus> retval = new ArrayList<HypericAlertStatus>();
        if (alertIds.size() < 1) {
            return retval;
        }
        for (int i = 0; i < alertIds.size(); ++i) {
            StringBuffer alertIdString = new StringBuffer();
            alertIdString.append("?");
            for (int j = 0; j < 200 && i < alertIds.size(); ++j, ++i) {
                if (j > 0) {
                    alertIdString.append("&");
                }
                alertIdString.append("id=").append(alertIds.get(i));
            }
            DefaultHttpClient httpClient = new DefaultHttpClient();
            httpClient.getParams().setIntParameter("http.connection.timeout", 3000);
            httpClient.getParams().setIntParameter("http.socket.timeout", 3000);
            HttpGet httpMethod = new HttpGet(hypericUrl + alertIdString.toString());
            httpMethod.getParams().setParameter("http.useragent", (Object)"OpenNMS-Ackd.HypericAckProcessor");
            String userinfo = null;
            try {
                URI hypericUri = new URI(hypericUrl);
                userinfo = hypericUri.getUserInfo();
            }
            catch (URISyntaxException e) {
                HypericAckProcessor.log().warn("Could not parse URI to get username/password stanza: " + hypericUrl, (Throwable)e);
            }
            if (userinfo != null && !"".equals(userinfo)) {
                httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userinfo));
                HttpRequestInterceptor preemptiveAuth = new HttpRequestInterceptor(){

                    public void process(HttpRequest request, HttpContext context) throws IOException {
                        AuthScope authScope;
                        Credentials creds;
                        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
                        CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                        if (authState.getAuthScheme() == null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                            authState.setAuthScheme((AuthScheme)new BasicScheme());
                            authState.setCredentials(creds);
                        }
                    }
                };
                httpClient.addRequestInterceptor(preemptiveAuth, 0);
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)httpMethod);
            retval = HypericAckProcessor.parseHypericAlerts(new StringReader(EntityUtils.toString((HttpEntity)response.getEntity())));
            continue;
        }
        return retval;
    }

    public static List<HypericAlertStatus> parseHypericAlerts(Reader reader) throws JAXBException, XMLStreamException {
        ArrayList<HypericAlertStatus> retval = new ArrayList<HypericAlertStatus>();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{HypericAlertStatuses.class, HypericAlertStatus.class});
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        XMLEventReader xmler = xmlif.createXMLEventReader(reader);
        EventFilter filter = new EventFilter(){

            @Override
            public boolean accept(XMLEvent event) {
                return event.isStartElement();
            }
        };
        XMLEventReader xmlfer = xmlif.createFilteredReader(xmler, filter);
        StartElement startElement = (StartElement)xmlfer.nextEvent();
        String rootElementName = context.createJAXBIntrospector().getElementName((Object)new HypericAlertStatuses()).getLocalPart();
        if (rootElementName.equals(startElement.getName().getLocalPart())) {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            while (xmlfer.peek() != null) {
                Object object = unmarshaller.unmarshal(xmler);
                if (!(object instanceof HypericAlertStatus)) continue;
                HypericAlertStatus alertStatus = (HypericAlertStatus)object;
                retval.add(alertStatus);
            }
        } else {
            StringBuffer errorContent = new StringBuffer();
            LineNumberReader lineReader = new LineNumberReader(reader);
            try {
                String line;
                while ((line = lineReader.readLine()) != null) {
                    errorContent.append(line.trim());
                }
            }
            catch (IOException e) {
                errorContent.append("Exception while trying to print out message content: " + e.getMessage());
            }
            throw new JAXBException("Found wrong root element in Hyperic XML document, expected: \"" + rootElementName + "\", found \"" + startElement.getName().getLocalPart() + "\"\n" + errorContent.toString());
        }
        return retval;
    }

    public synchronized void setAckdConfigDao(AckdConfigurationDao configDao) {
        this.m_ackdDao = configDao;
    }

    public synchronized void setAckService(AckService ackService) {
        this.m_ackService = ackService;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public synchronized void setAlarmDao(AlarmDao dao) {
        this.m_alarmDao = dao;
    }

    @XmlRootElement(name="alert")
    static class HypericAlertStatus {
        private int alertId;
        private String ackUser;
        private String ackMessage;
        private Date ackTime;
        private boolean isFixed;
        private String fixUser;
        private String fixMessage;
        private Date fixTime;

        HypericAlertStatus() {
        }

        @XmlAttribute(name="id", required=true)
        public int getAlertId() {
            return this.alertId;
        }

        public void setAlertId(int alertId) {
            this.alertId = alertId;
        }

        @XmlAttribute(name="fixed", required=true)
        public boolean isFixed() {
            return this.isFixed;
        }

        public void setFixed(boolean isFixed) {
            this.isFixed = isFixed;
        }

        @XmlAttribute(name="ackUser")
        public String getAckUser() {
            return this.ackUser;
        }

        public void setAckUser(String ackUser) {
            this.ackUser = ackUser;
        }

        @XmlAttribute(name="ackMessage")
        public String getAckMessage() {
            return this.ackMessage;
        }

        public void setAckMessage(String ackMessage) {
            this.ackMessage = ackMessage;
        }

        @XmlAttribute(name="ackTime")
        public Date getAckTime() {
            return this.ackTime;
        }

        public void setAckTime(Date ackTime) {
            this.ackTime = ackTime;
        }

        @XmlAttribute(name="fixUser")
        public String getFixUser() {
            return this.fixUser;
        }

        public void setFixUser(String fixUser) {
            this.fixUser = fixUser;
        }

        @XmlAttribute(name="fixMessage")
        public String getFixMessage() {
            return this.fixMessage;
        }

        public void setFixMessage(String fixMessage) {
            this.fixMessage = fixMessage;
        }

        @XmlAttribute(name="fixTime")
        public Date getFixTime() {
            return this.fixTime;
        }

        public void setFixTime(Date fixTime) {
            this.fixTime = fixTime;
        }

        public String toString() {
            StringBuffer retval = new StringBuffer();
            retval.append("{ ");
            retval.append("id: ").append(String.valueOf(this.alertId)).append(", ");
            retval.append("fixed: ").append(String.valueOf(this.isFixed)).append(", ");
            retval.append("ackUser: ").append(String.valueOf(this.ackUser)).append(", ");
            retval.append("ackMessage: ").append(String.valueOf(this.ackMessage)).append(", ");
            retval.append("ackTime: ").append(String.valueOf(this.ackTime)).append(", ");
            retval.append("fixUser: ").append(String.valueOf(this.fixUser)).append(", ");
            retval.append("fixMessage: ").append(String.valueOf(this.fixMessage)).append(", ");
            retval.append("fixTime: ").append(String.valueOf(this.fixTime));
            retval.append(" }");
            return retval.toString();
        }
    }

    @XmlRootElement(name="hyperic-alert-statuses")
    static class HypericAlertStatuses {
        private List<HypericAlertStatus> statusList;

        HypericAlertStatuses() {
        }

        @XmlElement
        public List<HypericAlertStatus> getStatusList() {
            return this.statusList;
        }

        public void setStatusList(List<HypericAlertStatus> statusList) {
            this.statusList = statusList;
        }
    }
}

