/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.ocs.inventory.client.request.logic;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.codec.binary.Base64;
import org.opennms.ocs.inventory.client.request.Engine;
import org.opennms.ocs.inventory.client.request.Request;
import org.opennms.ocs.inventory.client.request.RequestFactory;
import org.opennms.ocs.inventory.client.request.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeneralClientLogic {
    private static Logger LOGGER = LoggerFactory.getLogger(GeneralClientLogic.class);
    protected static String m_url;
    private static String m_urlNameSpaceXml;
    private static String m_login;
    private static String m_password;
    private static String m_checksum;
    private static List<Tag> m_tags;
    protected SOAPConnection soapConnection;
    private static final String ENGINE = "FIRST";
    protected String m_askingfor;
    private static final String DEFAULT_CHECKSUM = "4099";
    private static final String WANTED = "1";
    protected String m_web_service_method;

    GeneralClientLogic() {
    }

    protected void init(String host, String login, String password) throws SOAPException {
        this.init(host, login, password, null, new ArrayList<String>());
    }

    protected void init(String host, String login, String password, String checksum) throws SOAPException {
        this.init(host, login, password, checksum, new ArrayList<String>());
    }

    protected void init(String host, String login, String password, String checksum, List<String> tags) throws SOAPException {
        LOGGER.info("Initialization OCS Inventory Client");
        LOGGER.info("Init parameters: host=" + host + ", login=" + login);
        m_login = login;
        m_password = password;
        m_checksum = DEFAULT_CHECKSUM;
        if (checksum != null) {
            m_checksum = checksum;
        }
        LOGGER.info("Using checksum value {}", (Object)m_checksum);
        m_tags = new ArrayList<Tag>();
        if (tags != null) {
            LOGGER.info("Including {} tags in request", (Object)tags.size());
            for (String tagName : tags) {
                Tag aTag = new Tag();
                aTag.setValue(tagName);
                m_tags.add(aTag);
            }
        }
        m_url = String.format("%s/ocsinterface", host);
        m_urlNameSpaceXml = String.format("%s/Apache/Ocsinventory/Interface", host);
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        this.soapConnection = soapConnectionFactory.createConnection();
    }

    protected SOAPMessage createSOAPRequest(Integer offset) throws Exception {
        LOGGER.info("Create SOAP request");
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        LOGGER.debug("Create SOAP envelope");
        SOAPEnvelope envelope = soapPart.getEnvelope();
        SOAPHeader header = envelope.getHeader();
        header.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        header.addNamespaceDeclaration("soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
        header.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        header.addNamespaceDeclaration("soap", "http://schemas.xmlsoap.org/soap/envelope/");
        MimeHeaders hd = soapMessage.getMimeHeaders();
        String authorization = Base64.encodeBase64String((byte[])(m_login + ":" + m_password).getBytes());
        hd.addHeader("Authorization", "Basic " + authorization);
        LOGGER.debug("Create SOAP body");
        RequestFactory objFact = new RequestFactory();
        Request request = objFact.createRequest();
        Engine eng = new Engine();
        eng.setValue(ENGINE);
        request.setEngine(eng);
        request.setAskingfor(this.m_askingfor);
        request.setChecksum(m_checksum);
        request.getTag().addAll(m_tags);
        request.setOffset(Integer.toString(offset));
        request.setWanted(WANTED);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Request.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        StringWriter writer = new StringWriter();
        jaxbMarshaller.marshal((Object)request, (Writer)writer);
        SOAPBody soapBody = envelope.getBody();
        QName bodyName = new QName(m_urlNameSpaceXml, this.m_web_service_method, "");
        SOAPBodyElement bodyElement = soapBody.addBodyElement(bodyName);
        SOAPElement soapBodyElem1 = bodyElement.addChildElement("c-gensym3");
        soapBodyElem1.setTextContent(writer.toString());
        soapMessage.saveChanges();
        LOGGER.info("SOAP request created");
        return soapMessage;
    }
}

