/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.snmp.internal;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.opennms.netmgt.api.sample.Agent;
import org.opennms.netmgt.api.sample.support.SingletonBeanFactory;
import org.opennms.netmgt.config.snmp.AddressSnmpConfigVisitor;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.config.snmp.SnmpConfigVisitor;
import org.opennms.netmgt.sampler.config.snmp.SnmpAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpAgentProcessor
implements Processor {
    public static final Logger LOG = LoggerFactory.getLogger(SnmpAgentProcessor.class);
    SingletonBeanFactory<SnmpConfig> m_snmpConfigFactory;

    public SingletonBeanFactory<SnmpConfig> getSnmpConfigFactory() {
        return this.m_snmpConfigFactory;
    }

    public void setSnmpConfigFactory(SingletonBeanFactory<SnmpConfig> factory) {
        this.m_snmpConfigFactory = factory;
    }

    public void process(Exchange exchange) throws Exception {
        Agent agent = (Agent)exchange.getIn().getBody(Agent.class);
        SnmpAgent snmpAgent = new SnmpAgent(agent);
        if (this.m_snmpConfigFactory != null && this.m_snmpConfigFactory.getInstance() != null) {
            SnmpConfig config = (SnmpConfig)this.m_snmpConfigFactory.getInstance();
            AddressSnmpConfigVisitor visitor = new AddressSnmpConfigVisitor(agent.getInetAddress());
            config.visit((SnmpConfigVisitor)visitor);
            Definition def = visitor.getDefinition();
            LOG.debug("SNMP configuration for address {}: {}", (Object)agent.getInetAddress(), (Object)def);
            snmpAgent.setCommunity(def.getReadCommunity());
            snmpAgent.setRetries(def.getRetry().intValue());
            snmpAgent.setTimeout(def.getTimeout().intValue());
            snmpAgent.setVersion(def.getVersion());
        } else {
            LOG.debug("SNMP config factory is not set!");
        }
        exchange.getIn().setBody((Object)snmpAgent);
    }
}

