/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.scheduler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.api.sample.Agent;
import org.opennms.netmgt.api.sample.AgentDispatcher;
import org.opennms.netmgt.api.sample.PackageAgentList;
import org.opennms.netmgt.api.sample.support.SchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler
implements SchedulerService {
    private static final Logger LOG = LoggerFactory.getLogger(Scheduler.class);
    private static final AgentDispatcher NULL_DISPATCHER = new AgentDispatcher(){

        public void dispatch(Agent agent) {
            LOG.debug("No dispatcher for scheduled request {}", (Object)agent);
        }
    };
    private final ScheduledExecutorService m_executor;
    private final ConcurrentHashMap<String, AgentDispatcher> m_dispatchers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<ScheduledFuture<?>>> m_schedules = new ConcurrentHashMap();

    public Scheduler(int poolSize) {
        this.m_executor = Executors.newScheduledThreadPool(poolSize);
    }

    public AgentDispatcher getDispatcher(String service) {
        AgentDispatcher dispatcher = this.m_dispatchers.get(service);
        if (dispatcher == null) {
            return NULL_DISPATCHER;
        }
        return dispatcher;
    }

    public void setDispatcher(String service, AgentDispatcher dispatcher) {
        this.m_dispatchers.put(service, dispatcher);
    }

    public void removeDispatcher(String service, AgentDispatcher dispatcher) {
        this.m_dispatchers.remove(service, dispatcher);
    }

    public void onDispatcherBind(AgentDispatcher dispatcher, Map properties) {
        String service = (String)properties.get("org.opennms.netmgt.sampler.scheduler.serviceName");
        LOG.debug("onDispatcherBind(service={})", (Object)service);
        if (service != null && dispatcher != null) {
            this.setDispatcher(service, dispatcher);
        }
    }

    public void onDispatcherUnbind(AgentDispatcher dispatcher, Map properties) {
        String service = (String)properties.get("org.opennms.netmgt.sampler.scheduler.serviceName");
        LOG.debug("onDispatcherUnbind(service={})", (Object)service);
        if (service != null && dispatcher != null) {
            this.removeDispatcher(service, dispatcher);
        }
    }

    public void schedule(PackageAgentList agentSchedule) {
        LOG.debug("Scheduling agents: {}", (Object)agentSchedule);
        Long interval = agentSchedule.getInterval();
        final String service = agentSchedule.getServiceName();
        String id = agentSchedule.getId();
        int count = 0;
        double offset = (double)interval.longValue() / (double)agentSchedule.getAgents().size();
        if (this.m_schedules.containsKey(id)) {
            LOG.debug("Existing schedules found for {}: canceling.", (Object)id);
            for (ScheduledFuture<?> future : this.m_schedules.get(id)) {
                LOG.debug("Canceling: {}", future);
                future.cancel(false);
            }
        }
        ArrayList futures = new ArrayList();
        for (final Agent agent : agentSchedule.getAgents()) {
            ScheduledFuture<?> future = this.m_executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    AgentDispatcher dispatcher = Scheduler.this.getDispatcher(service);
                    LOG.trace("Dispatching agent {} to {}", (Object)dispatcher);
                    dispatcher.dispatch(agent);
                }
            }, (long)((double)count * offset), interval, TimeUnit.MILLISECONDS);
            ++count;
            futures.add(future);
        }
        this.m_schedules.put(id, futures);
    }

    public String toString() {
        return "Scheduler[ dispatchers=" + this.m_dispatchers + ", schedules=" + this.m_schedules + " ]";
    }
}

