/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd.camel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CamelTrapEventProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(CamelTrapEventProcessor.class);
    private final ExecutorService m_executor = Executors.newFixedThreadPool(5, (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName(), 5));

    public void process(Exchange exchange) throws Exception {
        final String message = (String)exchange.getIn().getBody(String.class);
        this.m_executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SnmpMessageParser parser = new SnmpMessageParser();
                SnmpMessage snmpAgent = parser.parse(message);
                LOG.debug("Received trap: {}", (Object)snmpAgent.toString());
                return null;
            }
        });
    }

    public static class SnmpMessageParser
    extends DefaultHandler {
        private SnmpMessage snmpMessage;
        private String temp;
        private String oid;
        private String value;
        private final SAXParser parser;

        public SnmpMessageParser() {
            try {
                SAXParserFactory spfac = SAXParserFactory.newInstance();
                this.parser = spfac.newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        public SnmpMessage parse(String message) throws SAXException, IOException {
            this.snmpMessage = new SnmpMessage();
            this.parser.parse((InputStream)new ByteArrayInputStream(message.getBytes("UTF-8")), (DefaultHandler)this);
            return this.snmpMessage;
        }

        @Override
        public void characters(char[] buffer, int start, int length) {
            this.temp = new String(buffer, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("entry")) {
                this.oid = null;
                this.value = null;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("enterprise")) {
                this.snmpMessage.setEnterprise(this.temp);
                return;
            } else if (qName.equalsIgnoreCase("agent-addr")) {
                this.snmpMessage.setAgentAddr(this.temp);
                return;
            } else if (qName.equalsIgnoreCase("generic-trap")) {
                this.snmpMessage.setGenericTrap(Integer.parseInt(this.temp));
                return;
            } else if (qName.equalsIgnoreCase("specific-trap")) {
                this.snmpMessage.setSpecificTrap(Integer.parseInt(this.temp));
                return;
            } else if (qName.equalsIgnoreCase("time-stamp")) {
                this.snmpMessage.setTimestamp(Long.parseLong(this.temp));
                return;
            } else if (qName.equalsIgnoreCase("entry")) {
                if (this.oid == null && this.value == null) return;
                if (this.oid == null || this.value == null) throw new IllegalStateException(String.format("Null OID or value found: %s -> %s", this.oid, this.value));
                this.snmpMessage.putOid(this.oid, this.value);
                return;
            } else if (qName.equalsIgnoreCase("oid")) {
                this.oid = this.temp;
                return;
            } else {
                if (!qName.equalsIgnoreCase("value")) return;
                this.value = this.temp;
            }
        }
    }

    public static class SnmpMessage {
        private String enterprise;
        private String agentAddr;
        private int genericTrap;
        private int specificTrap;
        private long timestamp;
        private Map<String, String> m_oids = new HashMap<String, String>();

        public String getEnterprise() {
            return this.enterprise;
        }

        public void setEnterprise(String enterprise) {
            this.enterprise = enterprise;
        }

        public String getAgentAddr() {
            return this.agentAddr;
        }

        public void setAgentAddr(String agentAddr) {
            this.agentAddr = agentAddr;
        }

        public int getGenericTrap() {
            return this.genericTrap;
        }

        public void setGenericTrap(int genericTrap) {
            this.genericTrap = genericTrap;
        }

        public int getSpecificTrap() {
            return this.specificTrap;
        }

        public void setSpecificTrap(int specificTrap) {
            this.specificTrap = specificTrap;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public void putOid(String oid, String value) {
            this.m_oids.put(oid, value);
        }

        public Map<String, String> getOids() {
            return Collections.unmodifiableMap(this.m_oids);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("enterprise", (Object)this.getEnterprise()).append("agentAddr", (Object)this.getAgentAddr()).append("genericTrap", this.getGenericTrap()).append("specificTrap", this.getSpecificTrap()).append("timestamp", this.getTimestamp()).append("oids", this.getOids()).toString();
        }
    }
}

