/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.mock.snmp;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.opennms.mock.snmp.MockSnmpMOLoader;
import org.opennms.mock.snmp.Updatable;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.springframework.core.io.Resource;

public class PropsMockSnmpMOLoaderImpl
implements MockSnmpMOLoader {
    @Override
    public List<ManagedObject> loadMOs(Resource moFile) {
        ArrayList<ManagedObject> moList = new ArrayList<ManagedObject>();
        Properties moProps = SnmpUtils.loadProperties((Resource)moFile);
        if (moProps == null) {
            return null;
        }
        Enumeration<Object> moKeys = moProps.keys();
        while (moKeys.hasMoreElements()) {
            String oidStr = moKeys.nextElement().toString();
            ManagedObject newMo = PropsMockSnmpMOLoaderImpl.getMOFromPropString(oidStr, moProps.getProperty(oidStr));
            moList.add(newMo);
        }
        return moList;
    }

    public static Properties loadProperties(Resource propertiesFile) {
        return SnmpUtils.loadProperties((Resource)propertiesFile);
    }

    protected static ManagedObject getMOFromPropString(String oidStr, String valStr) {
        OID moOID = new OID(oidStr);
        Variable newVar = PropsMockSnmpMOLoaderImpl.getVariableFromValueString(oidStr, valStr);
        UpdatableScalar newMO = new UpdatableScalar(moOID, MOAccessImpl.ACCESS_READ_ONLY, newVar);
        newMO.setVolatile(true);
        return newMO;
    }

    public static Variable getVariableFromValueString(String oidStr, String valStr) {
        Null newVar;
        block14: {
            if ("\"\"".equals(valStr)) {
                newVar = new Null();
            } else {
                String moTypeStr = valStr.substring(0, valStr.indexOf(":"));
                String moValStr = valStr.substring(valStr.indexOf(":") + 2);
                try {
                    if (moTypeStr.equals("STRING")) {
                        newVar = new OctetString(moValStr);
                        break block14;
                    }
                    if (moTypeStr.equals("Hex-STRING")) {
                        newVar = OctetString.fromHexString((String)moValStr.trim().replace(' ', ':'));
                        break block14;
                    }
                    if (moTypeStr.equals("INTEGER")) {
                        newVar = new Integer32(Integer.parseInt(moValStr));
                        break block14;
                    }
                    if (moTypeStr.equals("Gauge32")) {
                        newVar = new Gauge32(Long.parseLong(moValStr));
                        break block14;
                    }
                    if (moTypeStr.equals("Counter32")) {
                        newVar = new Counter32(Long.parseLong(moValStr));
                        break block14;
                    }
                    if (moTypeStr.equals("Counter64")) {
                        newVar = new Counter64(Long.parseLong(moValStr));
                        break block14;
                    }
                    if (moTypeStr.equals("Timeticks")) {
                        Integer ticksInt = Integer.parseInt(moValStr.substring(moValStr.indexOf("(") + 1, moValStr.indexOf(")")));
                        newVar = new TimeTicks((long)ticksInt.intValue());
                        break block14;
                    }
                    if (moTypeStr.equals("OID")) {
                        newVar = new OID(moValStr);
                        break block14;
                    }
                    if (moTypeStr.equals("IpAddress")) {
                        newVar = new IpAddress(moValStr.trim());
                        break block14;
                    }
                    if (moTypeStr.equals("Network Address")) {
                        newVar = OctetString.fromHexString((String)moValStr.trim());
                        break block14;
                    }
                    throw new IllegalArgumentException("Unrecognized SNMP Type " + moTypeStr);
                }
                catch (Throwable t) {
                    throw new UndeclaredThrowableException(t, "Could not convert value '" + moValStr + "' of type '" + moTypeStr + "' to SNMP object for OID " + oidStr);
                }
            }
        }
        return newVar;
    }

    private static class UpdatableScalar
    extends MOScalar
    implements Updatable {
        public UpdatableScalar(OID id, MOAccess access, Variable value) {
            super(id, access, value);
        }

        @Override
        public void updateValue(OID oid, Variable value) {
            if (!this.getScope().covers(oid)) {
                throw new IllegalArgumentException("attempt to set value of oid not defined in this scalar: oid = " + oid + ", scalar = " + this);
            }
            this.setValue(value);
        }
    }
}

