/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.mock.snmp;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opennms.core.utils.LogUtils;
import org.opennms.mock.snmp.MockSnmpMOLoader;
import org.opennms.mock.snmp.PropsMockSnmpMOLoaderImpl;
import org.opennms.mock.snmp.Updatable;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.springframework.core.io.Resource;

public class PropertiesBackedManagedObject
implements ManagedObject,
MockSnmpMOLoader,
Updatable,
MOAccess {
    private TreeMap<OID, Object> m_vars = null;
    private MOScope m_scope = null;
    private Object m_oldValue;

    @Override
    public List<ManagedObject> loadMOs(Resource moFile) {
        Properties props = SnmpUtils.loadProperties((Resource)moFile);
        this.m_vars = new TreeMap();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String key = (String)e.getKey();
            Object value = e.getValue();
            if (!key.startsWith(".")) {
                LogUtils.debugf((Object)this, (String)"key does not start with '.', probably a linewrap issue in snmpwalk: %s = %s", (Object[])new Object[]{key, value});
                continue;
            }
            try {
                this.m_vars.put(new OID(key), value);
            }
            catch (Throwable ex) {
                IllegalArgumentException nfe = new IllegalArgumentException("Could not load OID value: [" + key + "] [" + value + "]");
                nfe.initCause(ex);
                throw nfe;
            }
        }
        this.m_scope = new DefaultMOScope(this.m_vars.firstKey(), true, this.m_vars.lastKey(), true);
        return Collections.singletonList(this);
    }

    public OID find(MOScope range) {
        SortedMap<OID, Object> tail;
        if (!this.m_scope.isOverlapping(range)) {
            return null;
        }
        OID first = range.getLowerBound();
        if (range.isLowerIncluded()) {
            first = first.successor();
        }
        if ((tail = this.m_vars.tailMap(first)).isEmpty()) {
            return null;
        }
        return tail.firstKey();
    }

    public OID findNextOid(OID given) {
        OID next = given.successor();
        SortedMap<OID, Object> tail = this.m_vars.tailMap(next);
        if (tail.isEmpty()) {
            return null;
        }
        return tail.firstKey();
    }

    private Variable findValueForOID(OID oid) {
        Object val = this.m_vars.get(oid);
        if (val == null) {
            return null;
        }
        if (val instanceof Variable) {
            return (Variable)val;
        }
        return PropsMockSnmpMOLoaderImpl.getVariableFromValueString(oid.toString(), (String)val);
    }

    public void get(SubRequest request) {
        this.getVariable(request, request.getVariableBinding().getOid());
    }

    private void getVariable(SubRequest request, OID oid) {
        Variable value = this.findValueForOID(oid);
        VariableBinding vb = request.getVariableBinding();
        vb.setOid(oid);
        vb.setVariable((Variable)(value == null ? Null.noSuchObject : value));
        request.completed();
    }

    public MOScope getScope() {
        return this.m_scope;
    }

    public boolean next(SubRequest request) {
        OID nextOid = this.findNextOid(request.getVariableBinding().getOid());
        if (nextOid == null) {
            return false;
        }
        this.getVariable(request, nextOid);
        return true;
    }

    public void prepare(SubRequest request) {
        VariableBinding vb = request.getVariableBinding();
        this.m_oldValue = this.m_vars.get(vb.getOid());
        RequestStatus status = request.getStatus();
        status.setErrorStatus(0);
        status.setPhaseComplete(true);
    }

    public void commit(SubRequest request) {
        VariableBinding vb = request.getVariableBinding();
        Variable v = vb.getVariable();
        this.m_vars.put(vb.getOid(), v);
        RequestStatus status = request.getStatus();
        status.setPhaseComplete(true);
    }

    public void cleanup(SubRequest request) {
        this.m_oldValue = null;
        RequestStatus status = request.getStatus();
        status.setPhaseComplete(true);
    }

    public void undo(SubRequest request) {
        this.m_vars.put(request.getVariableBinding().getOid(), this.m_oldValue);
        this.m_oldValue = null;
        RequestStatus status = request.getStatus();
        status.setErrorStatus(0);
        status.setPhaseComplete(true);
    }

    @Override
    public void updateValue(OID oid, Variable value) {
        this.m_vars.put(oid, value);
    }

    public boolean isAccessibleForCreate() {
        return false;
    }

    public boolean isAccessibleForNotify() {
        return false;
    }

    public boolean isAccessibleForRead() {
        return true;
    }

    public boolean isAccessibleForWrite() {
        return false;
    }
}

