/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.mock.snmp;

import java.math.BigInteger;
import java.net.InetAddress;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

public class MockSnmpValue
implements SnmpValue {
    private int m_type;
    private String m_value;
    public static final SnmpValue NULL_VALUE = new MockSnmpValue(5, null){

        @Override
        public boolean isNull() {
            return true;
        }
    };
    public static final SnmpValue NO_SUCH_INSTANCE = new MockSnmpValue(129, "noSuchInstance");
    public static final SnmpValue NO_SUCH_OBJECT = new MockSnmpValue(128, "noSuchObject");
    public static final SnmpValue END_OF_MIB = new MockSnmpValue(130, "endOfMibView");

    public MockSnmpValue(int type, String value) {
        this.m_type = type;
        this.m_value = value;
    }

    public boolean isEndOfMib() {
        return this.getType() == 130;
    }

    public int getType() {
        return this.m_type;
    }

    public String toDisplayString() {
        return this.toString();
    }

    public String toString() {
        return this.m_value;
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MockSnmpValue) {
            MockSnmpValue val = (MockSnmpValue)obj;
            return this.m_value == null ? val.m_value == null : this.m_value.equals(val.m_value);
        }
        return false;
    }

    public int hashCode() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.hashCode();
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isError() {
        switch (this.getType()) {
            case 128: 
            case 129: {
                return true;
            }
        }
        return false;
    }

    public int toInt() {
        throw new IllegalArgumentException("Unable to convert " + this + " to an int");
    }

    public InetAddress toInetAddress() {
        throw new IllegalArgumentException("Unable to convert " + this + " to an InetAddress");
    }

    public long toLong() {
        throw new IllegalArgumentException("Unable to convert " + this + " to a long");
    }

    public String toHexString() {
        throw new IllegalArgumentException("Unable to convert " + this + " to a hex string");
    }

    public BigInteger toBigInteger() {
        throw new IllegalArgumentException("Unable to convert " + this + " to a hex string");
    }

    public SnmpObjId toSnmpObjId() {
        throw new IllegalArgumentException("Unable to convert " + this + " to an SNMP object ID");
    }

    public byte[] getBytes() {
        return this.toString().getBytes();
    }

    public boolean isDisplayable() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public static class OidSnmpValue
    extends MockSnmpValue {
        public OidSnmpValue(String value) {
            super(6, value);
        }

        @Override
        public SnmpObjId toSnmpObjId() {
            return SnmpObjId.get((String)this.toString());
        }

        @Override
        public boolean isDisplayable() {
            return true;
        }
    }

    public static class StringSnmpValue
    extends MockSnmpValue {
        public StringSnmpValue(String value) {
            super(4, value);
        }

        @Override
        public int toInt() {
            try {
                return Integer.parseInt(this.toString());
            }
            catch (NumberFormatException e) {
                return super.toInt();
            }
        }

        @Override
        public boolean isDisplayable() {
            return true;
        }

        @Override
        public long toLong() {
            return Long.parseLong(this.toString());
        }

        @Override
        public String toHexString() {
            StringBuffer buff = new StringBuffer();
            for (byte b : this.toString().getBytes()) {
                buff.append(Integer.toHexString(b));
            }
            return buff.toString();
        }
    }

    public static class TimeticksSnmpValue
    extends NumberSnmpValue {
        public TimeticksSnmpValue(String value) {
            super(67, value);
        }

        @Override
        public String getNumberString() {
            String str = this.getValue();
            int end = str.indexOf(41);
            return end < 0 ? str : str.substring(1, end);
        }

        @Override
        public String toString() {
            return String.valueOf(this.toLong());
        }

        @Override
        public String toDisplayString() {
            return this.toString();
        }
    }

    static enum UnitOfTime {
        DAYS(4),
        HOURS(3),
        MINUTES(2),
        SECONDS(1),
        MILLIS(0);

        private int m_index;
        private static final long[] s_millisPerUnit;
        private static final String[] s_unitName;

        private UnitOfTime(int index) {
            this.m_index = index;
        }

        public long wholeUnits(long millis) {
            return millis / s_millisPerUnit[this.m_index];
        }

        public long remainingMillis(long millis) {
            return millis % s_millisPerUnit[this.m_index];
        }

        public String unit() {
            return s_unitName[this.m_index];
        }

        static {
            s_millisPerUnit = new long[]{1L, 1000L, 60000L, 3600000L, 86400000L};
            s_unitName = new String[]{"ms", "s", "m", "h", "d"};
        }
    }

    public static class Counter64SnmpValue
    extends NumberSnmpValue {
        public Counter64SnmpValue(long value) {
            this(Long.toString(value));
        }

        public Counter64SnmpValue(String value) {
            super(70, value);
        }
    }

    public static class Counter32SnmpValue
    extends NumberSnmpValue {
        public Counter32SnmpValue(int value) {
            this(Integer.toString(value));
        }

        public Counter32SnmpValue(String value) {
            super(65, value);
        }
    }

    public static class Gauge32SnmpValue
    extends NumberSnmpValue {
        public Gauge32SnmpValue(int value) {
            this(Integer.toString(value));
        }

        public Gauge32SnmpValue(String value) {
            super(66, value);
        }
    }

    public static class Integer32SnmpValue
    extends NumberSnmpValue {
        public Integer32SnmpValue(int value) {
            this(Integer.toString(value));
        }

        public Integer32SnmpValue(String value) {
            super(2, value);
        }
    }

    public static class NumberSnmpValue
    extends MockSnmpValue {
        public NumberSnmpValue(int type, String value) {
            super(type, value);
        }

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public int toInt() {
            return Integer.parseInt(this.getNumberString());
        }

        @Override
        public long toLong() {
            return Long.parseLong(this.getNumberString());
        }

        @Override
        public BigInteger toBigInteger() {
            return new BigInteger(this.getNumberString());
        }

        public String getNumberString() {
            return this.toString();
        }

        @Override
        public byte[] getBytes() {
            return this.toBigInteger().toByteArray();
        }

        @Override
        public boolean isDisplayable() {
            return true;
        }
    }

    public static class IpAddressSnmpValue
    extends MockSnmpValue {
        public IpAddressSnmpValue(String value) {
            super(64, value);
        }

        @Override
        public InetAddress toInetAddress() {
            try {
                return InetAddress.getByName(this.toString());
            }
            catch (Exception e) {
                return super.toInetAddress();
            }
        }

        @Override
        public byte[] getBytes() {
            return this.toInetAddress().getAddress();
        }

        @Override
        public boolean isDisplayable() {
            return true;
        }
    }

    public static class OctetStringSnmpValue
    extends MockSnmpValue {
        private byte[] m_bytes;

        public OctetStringSnmpValue(byte[] bytes) {
            super(4, new String(bytes));
            this.m_bytes = bytes;
        }

        @Override
        public byte[] getBytes() {
            return this.m_bytes;
        }

        @Override
        public String toString() {
            byte[] data = this.getBytes();
            byte[] results = new byte[data.length];
            for (int i = 0; i < data.length; ++i) {
                results[i] = Character.isISOControl((char)data[i]) ? 46 : data[i];
            }
            return new String(results);
        }

        @Override
        public String toHexString() {
            byte[] data = this.getBytes();
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < data.length; ++i) {
                int x = data[i] & 0xFF;
                if (x < 16) {
                    b.append("0");
                }
                b.append(Integer.toString(x, 16).toLowerCase());
            }
            return b.toString();
        }

        @Override
        public boolean isDisplayable() {
            return SnmpUtils.allBytesDisplayable((byte[])this.getBytes());
        }
    }

    public static class NetworkAddressSnmpValue
    extends MockSnmpValue {
        public NetworkAddressSnmpValue(String value) {
            super(4, value);
        }

        @Override
        public boolean isDisplayable() {
            return false;
        }
    }
}

