/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import junit.framework.TestCase;
import org.xbill.DNS.utils.base64;

public class base64Test
extends TestCase {
    public base64Test(String name) {
        super(name);
    }

    public void test_toString_empty() {
        byte[] data = new byte[]{};
        String out = base64.toString(data);
        base64Test.assertEquals("", out);
    }

    public void test_toString_basic1() {
        byte[] data = new byte[]{0};
        String out = base64.toString(data);
        base64Test.assertEquals("AA==", out);
    }

    public void test_toString_basic2() {
        byte[] data = new byte[]{0, 0};
        String out = base64.toString(data);
        base64Test.assertEquals("AAA=", out);
    }

    public void test_toString_basic3() {
        byte[] data = new byte[]{0, 0, 1};
        String out = base64.toString(data);
        base64Test.assertEquals("AAAB", out);
    }

    public void test_toString_basic4() {
        byte[] data = new byte[]{-4, 0, 0};
        String out = base64.toString(data);
        base64Test.assertEquals("/AAA", out);
    }

    public void test_toString_basic5() {
        byte[] data = new byte[]{-1, -1, -1};
        String out = base64.toString(data);
        base64Test.assertEquals("////", out);
    }

    public void test_toString_basic6() {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.toString(data);
        base64Test.assertEquals("AQIDBAUGBwgJ", out);
    }

    public void test_formatString_empty1() {
        String out = base64.formatString(new byte[0], 5, "", false);
        base64Test.assertEquals("", out);
    }

    public void test_formatString_shorter() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 13, "", false);
        base64Test.assertEquals("AQIDBAUGBwgJ", out);
    }

    public void test_formatString_sameLength() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 12, "", false);
        base64Test.assertEquals("AQIDBAUGBwgJ", out);
    }

    public void test_formatString_oneBreak() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 10, "", false);
        base64Test.assertEquals("AQIDBAUGBw\ngJ", out);
    }

    public void test_formatString_twoBreaks1() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 5, "", false);
        base64Test.assertEquals("AQIDB\nAUGBw\ngJ", out);
    }

    public void test_formatString_twoBreaks2() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 4, "", false);
        base64Test.assertEquals("AQID\nBAUG\nBwgJ", out);
    }

    public void test_formatString_shorterWithPrefix() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 13, "!_", false);
        base64Test.assertEquals("!_AQIDBAUGBwgJ", out);
    }

    public void test_formatString_sameLengthWithPrefix() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 12, "!_", false);
        base64Test.assertEquals("!_AQIDBAUGBwgJ", out);
    }

    public void test_formatString_oneBreakWithPrefix() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 10, "!_", false);
        base64Test.assertEquals("!_AQIDBAUGBw\n!_gJ", out);
    }

    public void test_formatString_twoBreaks1WithPrefix() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 5, "!_", false);
        base64Test.assertEquals("!_AQIDB\n!_AUGBw\n!_gJ", out);
    }

    public void test_formatString_twoBreaks2WithPrefix() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 4, "!_", false);
        base64Test.assertEquals("!_AQID\n!_BAUG\n!_BwgJ", out);
    }

    public void test_formatString_shorterWithPrefixAndClose() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 13, "!_", true);
        base64Test.assertEquals("!_AQIDBAUGBwgJ )", out);
    }

    public void test_formatString_sameLengthWithPrefixAndClose() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 12, "!_", true);
        base64Test.assertEquals("!_AQIDBAUGBwgJ )", out);
    }

    public void test_formatString_oneBreakWithPrefixAndClose() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 10, "!_", true);
        base64Test.assertEquals("!_AQIDBAUGBw\n!_gJ )", out);
    }

    public void test_formatString_twoBreaks1WithPrefixAndClose() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 5, "!_", true);
        base64Test.assertEquals("!_AQIDB\n!_AUGBw\n!_gJ )", out);
    }

    public void test_formatString_twoBreaks2WithPrefixAndClose() {
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        String out = base64.formatString(in, 4, "!_", true);
        base64Test.assertEquals("!_AQID\n!_BAUG\n!_BwgJ )", out);
    }

    private void assertEquals(byte[] exp, byte[] act) {
        base64Test.assertEquals(exp.length, act.length);
        for (int i = 0; i < exp.length; ++i) {
            base64Test.assertEquals(exp[i], act[i]);
        }
    }

    public void test_fromString_empty1() {
        byte[] data = new byte[]{};
        byte[] out = base64.fromString("");
        this.assertEquals(new byte[0], out);
    }

    public void test_fromString_basic1() {
        byte[] exp = new byte[]{0};
        byte[] out = base64.fromString("AA==");
        this.assertEquals(exp, out);
    }

    public void test_fromString_basic2() {
        byte[] exp = new byte[]{0, 0};
        byte[] out = base64.fromString("AAA=");
        this.assertEquals(exp, out);
    }

    public void test_fromString_basic3() {
        byte[] exp = new byte[]{0, 0, 1};
        byte[] out = base64.fromString("AAAB");
        this.assertEquals(exp, out);
    }

    public void test_fromString_basic4() {
        byte[] exp = new byte[]{-4, 0, 0};
        byte[] out = base64.fromString("/AAA");
        this.assertEquals(exp, out);
    }

    public void test_fromString_basic5() {
        byte[] exp = new byte[]{-1, -1, -1};
        byte[] out = base64.fromString("////");
        this.assertEquals(exp, out);
    }

    public void test_fromString_basic6() {
        byte[] exp = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] out = base64.fromString("AQIDBAUGBwgJ");
        this.assertEquals(exp, out);
    }

    public void test_fromString_invalid1() {
        byte[] out = base64.fromString("AAA");
        base64Test.assertNull(out);
    }

    public void test_fromString_invalid2() {
        byte[] out = base64.fromString("AA");
        base64Test.assertNull(out);
    }

    public void test_fromString_invalid3() {
        byte[] out = base64.fromString("A");
        base64Test.assertNull(out);
    }

    public void test_fromString_invalid4() {
        byte[] out = base64.fromString("BB==");
        base64Test.assertNull(out);
    }

    public void test_fromString_invalid5() {
        byte[] out = base64.fromString("BBB=");
        base64Test.assertNull(out);
    }
}

