/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import junit.framework.TestCase;
import org.xbill.DNS.InvalidTTLException;
import org.xbill.DNS.TTL;

public class TTLTest
extends TestCase {
    private final long S = 1L;
    private final long M = 60L;
    private final long H = 3600L;
    private final long D = 86400L;
    private final long W = 604800L;

    public void test_parseTTL() {
        TTLTest.assertEquals(9876L, TTL.parseTTL("9876"));
        TTLTest.assertEquals(0L, TTL.parseTTL("0S"));
        TTLTest.assertEquals(0L, TTL.parseTTL("0M"));
        TTLTest.assertEquals(0L, TTL.parseTTL("0H"));
        TTLTest.assertEquals(0L, TTL.parseTTL("0D"));
        TTLTest.assertEquals(0L, TTL.parseTTL("0W"));
        TTLTest.assertEquals(1L, TTL.parseTTL("1s"));
        TTLTest.assertEquals(60L, TTL.parseTTL("1m"));
        TTLTest.assertEquals(3600L, TTL.parseTTL("1h"));
        TTLTest.assertEquals(86400L, TTL.parseTTL("1d"));
        TTLTest.assertEquals(604800L, TTL.parseTTL("1w"));
        TTLTest.assertEquals(98L, TTL.parseTTL("98S"));
        TTLTest.assertEquals(4560L, TTL.parseTTL("76M"));
        TTLTest.assertEquals(194400L, TTL.parseTTL("54H"));
        TTLTest.assertEquals(2764800L, TTL.parseTTL("32D"));
        TTLTest.assertEquals(6048000L, TTL.parseTTL("10W"));
        TTLTest.assertEquals(5220758L, TTL.parseTTL("98S11M1234H2D01W"));
    }

    public void test_parseTTL_invalid() {
        try {
            TTL.parseTTL(null);
            TTLTest.fail("NumberFormatException not throw");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            TTL.parseTTL("");
            TTLTest.fail("NumberFormatException not throw");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            TTL.parseTTL("S");
            TTLTest.fail("NumberFormatException not throw");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            TTL.parseTTL("10S4B");
            TTLTest.fail("NumberFormatException not throw");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            TTL.parseTTL("1S4294967295S");
            TTLTest.fail("NumberFormatException not throw");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            TTL.parseTTL("4294967296");
            TTLTest.fail("NumberFormatException not throw");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void test_format() {
        TTLTest.assertEquals("0S", TTL.format(0L));
        TTLTest.assertEquals("1S", TTL.format(1L));
        TTLTest.assertEquals("59S", TTL.format(59L));
        TTLTest.assertEquals("1M", TTL.format(60L));
        TTLTest.assertEquals("59M", TTL.format(3540L));
        TTLTest.assertEquals("1M33S", TTL.format(93L));
        TTLTest.assertEquals("59M59S", TTL.format(3599L));
        TTLTest.assertEquals("1H", TTL.format(3600L));
        TTLTest.assertEquals("10H1M21S", TTL.format(36081L));
        TTLTest.assertEquals("23H59M59S", TTL.format(86399L));
        TTLTest.assertEquals("1D", TTL.format(86400L));
        TTLTest.assertEquals("4D18H45M30S", TTL.format(413130L));
        TTLTest.assertEquals("6D23H59M59S", TTL.format(604799L));
        TTLTest.assertEquals("1W", TTL.format(604800L));
        TTLTest.assertEquals("10W4D1H21M29S", TTL.format(6398489L));
        TTLTest.assertEquals("3550W5D3H14M7S", TTL.format(Integer.MAX_VALUE));
    }

    public void test_format_invalid() {
        try {
            TTL.format(-1L);
            TTLTest.fail("InvalidTTLException not thrown");
        }
        catch (InvalidTTLException e) {
            // empty catch block
        }
        try {
            TTL.format(0x100000000L);
            TTLTest.fail("InvalidTTLException not thrown");
        }
        catch (InvalidTTLException invalidTTLException) {
            // empty catch block
        }
    }
}

