/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import junit.framework.TestCase;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.EmptyRecord;
import org.xbill.DNS.InvalidDClassException;
import org.xbill.DNS.InvalidTTLException;
import org.xbill.DNS.InvalidTypeException;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TTL;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.UNKRecord;

public class RecordTest
extends TestCase {
    public void test_ctor_0arg() {
        SubRecord sr = new SubRecord();
        RecordTest.assertNull(sr.getName());
        RecordTest.assertEquals(0, sr.getType());
        RecordTest.assertEquals(0L, sr.getTTL());
        RecordTest.assertEquals(0, sr.getDClass());
    }

    public void test_ctor_4arg() throws TextParseException {
        Name n = Name.fromString("my.name.");
        int t = 1;
        int d = 1;
        long ttl = 703710L;
        SubRecord r = new SubRecord(n, t, d, ttl);
        RecordTest.assertEquals(n, r.getName());
        RecordTest.assertEquals(t, r.getType());
        RecordTest.assertEquals(d, r.getDClass());
        RecordTest.assertEquals(ttl, r.getTTL());
    }

    public void test_ctor_4arg_invalid() throws TextParseException {
        Name n = Name.fromString("my.name.");
        Name r = Name.fromString("my.relative.name");
        int t = 1;
        int d = 1;
        long ttl = 703710L;
        try {
            new SubRecord(r, t, d, ttl);
            RecordTest.fail("RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
        try {
            new SubRecord(n, -1, d, ttl);
            RecordTest.fail("InvalidTypeException not thrown");
        }
        catch (InvalidTypeException e) {
            // empty catch block
        }
        try {
            new SubRecord(n, t, -1, ttl);
            RecordTest.fail("InvalidDClassException not thrown");
        }
        catch (InvalidDClassException e) {
            // empty catch block
        }
        try {
            new SubRecord(n, t, d, -1L);
            RecordTest.fail("InvalidTTLException not thrown");
        }
        catch (InvalidTTLException e) {
            // empty catch block
        }
    }

    public void test_newRecord_3arg() throws TextParseException {
        Name n = Name.fromString("my.name.");
        Name r = Name.fromString("my.relative.name");
        int t = 1;
        int d = 1;
        Record rec = Record.newRecord(n, t, d);
        RecordTest.assertTrue(rec instanceof EmptyRecord);
        RecordTest.assertEquals(n, rec.getName());
        RecordTest.assertEquals(t, rec.getType());
        RecordTest.assertEquals(d, rec.getDClass());
        RecordTest.assertEquals(0L, rec.getTTL());
        try {
            Record.newRecord(r, t, d);
            RecordTest.fail("RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
    }

    public void test_newRecord_4arg() throws TextParseException {
        Name n = Name.fromString("my.name.");
        Name r = Name.fromString("my.relative.name");
        int t = 1;
        int d = 1;
        int ttl = 56296;
        Record rec = Record.newRecord(n, t, d, ttl);
        RecordTest.assertTrue(rec instanceof EmptyRecord);
        RecordTest.assertEquals(n, rec.getName());
        RecordTest.assertEquals(t, rec.getType());
        RecordTest.assertEquals(d, rec.getDClass());
        RecordTest.assertEquals((long)ttl, rec.getTTL());
        try {
            Record.newRecord(r, t, d, ttl);
            RecordTest.fail("RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
    }

    public void test_newRecord_5arg() throws TextParseException, UnknownHostException {
        Name n = Name.fromString("my.name.");
        int t = 1;
        int d = 1;
        int ttl = 56296;
        byte[] data = new byte[]{123, -24, 0, -1};
        InetAddress exp = InetAddress.getByName("123.232.0.255");
        Record rec = Record.newRecord(n, t, d, ttl, data);
        RecordTest.assertTrue(rec instanceof ARecord);
        RecordTest.assertEquals(n, rec.getName());
        RecordTest.assertEquals(t, rec.getType());
        RecordTest.assertEquals(d, rec.getDClass());
        RecordTest.assertEquals((long)ttl, rec.getTTL());
        RecordTest.assertEquals(exp, ((ARecord)rec).getAddress());
    }

    public void test_newRecord_6arg() throws TextParseException, UnknownHostException {
        Name n = Name.fromString("my.name.");
        int t = 1;
        int d = 1;
        int ttl = 56296;
        byte[] data = new byte[]{123, -24, 0, -1};
        InetAddress exp = InetAddress.getByName("123.232.0.255");
        Record rec = Record.newRecord(n, t, d, (long)ttl, 0, null);
        RecordTest.assertTrue(rec instanceof EmptyRecord);
        RecordTest.assertEquals(n, rec.getName());
        RecordTest.assertEquals(t, rec.getType());
        RecordTest.assertEquals(d, rec.getDClass());
        RecordTest.assertEquals((long)ttl, rec.getTTL());
        rec = Record.newRecord(n, t, d, (long)ttl, data.length, data);
        RecordTest.assertTrue(rec instanceof ARecord);
        RecordTest.assertEquals(n, rec.getName());
        RecordTest.assertEquals(t, rec.getType());
        RecordTest.assertEquals(d, rec.getDClass());
        RecordTest.assertEquals((long)ttl, rec.getTTL());
        RecordTest.assertEquals(exp, ((ARecord)rec).getAddress());
        rec = Record.newRecord(n, 32, d, (long)ttl, data.length, data);
        RecordTest.assertTrue(rec instanceof UNKRecord);
        RecordTest.assertEquals(n, rec.getName());
        RecordTest.assertEquals(32, rec.getType());
        RecordTest.assertEquals(d, rec.getDClass());
        RecordTest.assertEquals((long)ttl, rec.getTTL());
        RecordTest.assertTrue(Arrays.equals(data, ((UNKRecord)rec).getData()));
    }

    public void test_newRecord_6arg_invalid() throws TextParseException {
        Name n = Name.fromString("my.name.");
        Name r = Name.fromString("my.relative.name");
        int t = 1;
        int d = 1;
        int ttl = 56296;
        byte[] data = new byte[]{123, -24, 0, -1};
        RecordTest.assertNull(Record.newRecord(n, t, d, (long)ttl, 0, new byte[0]));
        RecordTest.assertNull(Record.newRecord(n, t, d, (long)ttl, 1, new byte[0]));
        RecordTest.assertNull(Record.newRecord(n, t, d, (long)ttl, data.length + 1, data));
        RecordTest.assertNull(Record.newRecord(n, t, d, (long)ttl, 5, new byte[]{data[0], data[1], data[2], data[3], 0}));
        try {
            Record.newRecord(r, t, d, (long)ttl, 0, null);
            RecordTest.fail("RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
    }

    public void test_fromWire() throws IOException, TextParseException, UnknownHostException {
        Name n = Name.fromString("my.name.");
        int t = 1;
        int d = 1;
        int ttl = 56296;
        byte[] data = new byte[]{123, -24, 0, -1};
        InetAddress exp = InetAddress.getByName("123.232.0.255");
        DNSOutput out = new DNSOutput();
        n.toWire(out, null);
        out.writeU16(t);
        out.writeU16(d);
        out.writeU32(ttl);
        out.writeU16(data.length);
        out.writeByteArray(data);
        DNSInput in = new DNSInput(out.toByteArray());
        Record rec = Record.fromWire(in, 1, false);
        RecordTest.assertTrue(rec instanceof ARecord);
        RecordTest.assertEquals(n, rec.getName());
        RecordTest.assertEquals(t, rec.getType());
        RecordTest.assertEquals(d, rec.getDClass());
        RecordTest.assertEquals((long)ttl, rec.getTTL());
        RecordTest.assertEquals(exp, ((ARecord)rec).getAddress());
        in = new DNSInput(out.toByteArray());
        rec = Record.fromWire(in, 0, false);
        RecordTest.assertTrue(rec instanceof EmptyRecord);
        RecordTest.assertEquals(n, rec.getName());
        RecordTest.assertEquals(t, rec.getType());
        RecordTest.assertEquals(d, rec.getDClass());
        RecordTest.assertEquals(0L, rec.getTTL());
        in = new DNSInput(out.toByteArray());
        rec = Record.fromWire(in, 0);
        RecordTest.assertTrue(rec instanceof EmptyRecord);
        RecordTest.assertEquals(n, rec.getName());
        RecordTest.assertEquals(t, rec.getType());
        RecordTest.assertEquals(d, rec.getDClass());
        RecordTest.assertEquals(0L, rec.getTTL());
        rec = Record.fromWire(out.toByteArray(), 0);
        RecordTest.assertTrue(rec instanceof EmptyRecord);
        RecordTest.assertEquals(n, rec.getName());
        RecordTest.assertEquals(t, rec.getType());
        RecordTest.assertEquals(d, rec.getDClass());
        RecordTest.assertEquals(0L, rec.getTTL());
        out = new DNSOutput();
        n.toWire(out, null);
        out.writeU16(t);
        out.writeU16(d);
        out.writeU32(ttl);
        out.writeU16(0);
        in = new DNSInput(out.toByteArray());
        rec = Record.fromWire(in, 1, true);
        RecordTest.assertTrue(rec instanceof EmptyRecord);
        RecordTest.assertEquals(n, rec.getName());
        RecordTest.assertEquals(t, rec.getType());
        RecordTest.assertEquals(d, rec.getDClass());
        RecordTest.assertEquals((long)ttl, rec.getTTL());
    }

    public void test_toWire() throws IOException, TextParseException, UnknownHostException {
        Name n = Name.fromString("my.name.");
        int t = 1;
        int d = 1;
        int ttl = 56296;
        byte[] data = new byte[]{123, -24, 0, -1};
        DNSOutput out = new DNSOutput();
        n.toWire(out, null);
        out.writeU16(t);
        out.writeU16(d);
        out.writeU32(ttl);
        out.writeU16(data.length);
        out.writeByteArray(data);
        byte[] exp = out.toByteArray();
        Record rec = Record.newRecord(n, t, d, (long)ttl, data.length, data);
        out = new DNSOutput();
        rec.toWire(out, 1, null);
        byte[] after = out.toByteArray();
        RecordTest.assertTrue(Arrays.equals(exp, after));
        after = rec.toWire(1);
        RecordTest.assertTrue(Arrays.equals(exp, after));
        out = new DNSOutput();
        n.toWire(out, null);
        out.writeU16(t);
        out.writeU16(d);
        exp = out.toByteArray();
        out = new DNSOutput();
        rec.toWire(out, 0, null);
        after = out.toByteArray();
        RecordTest.assertTrue(Arrays.equals(exp, after));
    }

    public void test_toWireCanonical() throws IOException, TextParseException, UnknownHostException {
        Name n = Name.fromString("My.Name.");
        int t = 1;
        int d = 1;
        int ttl = 56296;
        byte[] data = new byte[]{123, -24, 0, -1};
        DNSOutput out = new DNSOutput();
        n.toWireCanonical(out);
        out.writeU16(t);
        out.writeU16(d);
        out.writeU32(ttl);
        out.writeU16(data.length);
        out.writeByteArray(data);
        byte[] exp = out.toByteArray();
        Record rec = Record.newRecord(n, t, d, (long)ttl, data.length, data);
        byte[] after = rec.toWireCanonical();
        RecordTest.assertTrue(Arrays.equals(exp, after));
    }

    public void test_rdataToWireCanonical() throws IOException, TextParseException, UnknownHostException {
        Name n = Name.fromString("My.Name.");
        Name n2 = Name.fromString("My.Second.Name.");
        int t = 2;
        int d = 1;
        int ttl = 704153;
        DNSOutput out = new DNSOutput();
        n2.toWire(out, null);
        byte[] data = out.toByteArray();
        out = new DNSOutput();
        n2.toWireCanonical(out);
        byte[] exp = out.toByteArray();
        Record rec = Record.newRecord(n, t, d, (long)ttl, data.length, data);
        RecordTest.assertTrue(rec instanceof NSRecord);
        byte[] after = rec.rdataToWireCanonical();
        RecordTest.assertTrue(Arrays.equals(exp, after));
    }

    public void test_rdataToString() throws IOException, TextParseException, UnknownHostException {
        Name n = Name.fromString("My.Name.");
        Name n2 = Name.fromString("My.Second.Name.");
        int t = 2;
        int d = 1;
        int ttl = 704153;
        DNSOutput out = new DNSOutput();
        n2.toWire(out, null);
        byte[] data = out.toByteArray();
        Record rec = Record.newRecord(n, t, d, (long)ttl, data.length, data);
        RecordTest.assertTrue(rec instanceof NSRecord);
        RecordTest.assertEquals(rec.rrToString(), rec.rdataToString());
    }

    public void test_toString() throws TextParseException {
        Name n = Name.fromString("My.N.");
        Name n2 = Name.fromString("My.Second.Name.");
        int t = 2;
        int d = 1;
        int ttl = 704153;
        DNSOutput o = new DNSOutput();
        n2.toWire(o, null);
        byte[] data = o.toByteArray();
        Record rec = Record.newRecord(n, t, d, (long)ttl, data.length, data);
        String out = rec.toString();
        RecordTest.assertFalse(out.indexOf(n.toString()) == -1);
        RecordTest.assertFalse(out.indexOf(n2.toString()) == -1);
        RecordTest.assertFalse(out.indexOf("NS") == -1);
        RecordTest.assertFalse(out.indexOf("IN") == -1);
        RecordTest.assertFalse(out.indexOf(ttl + "") == -1);
        Options.set("BINDTTL");
        out = rec.toString();
        RecordTest.assertFalse(out.indexOf(n.toString()) == -1);
        RecordTest.assertFalse(out.indexOf(n2.toString()) == -1);
        RecordTest.assertFalse(out.indexOf("NS") == -1);
        RecordTest.assertFalse(out.indexOf("IN") == -1);
        RecordTest.assertFalse(out.indexOf(TTL.format(ttl)) == -1);
        Options.set("noPrintIN");
        out = rec.toString();
        RecordTest.assertFalse(out.indexOf(n.toString()) == -1);
        RecordTest.assertFalse(out.indexOf(n2.toString()) == -1);
        RecordTest.assertFalse(out.indexOf("NS") == -1);
        RecordTest.assertTrue(out.indexOf("IN") == -1);
        RecordTest.assertFalse(out.indexOf(TTL.format(ttl)) == -1);
    }

    public void test_byteArrayFromString() throws TextParseException {
        String in = "the 98 \" ' quick 0xAB brown";
        byte[] out = SubRecord.byteArrayFromString(in);
        RecordTest.assertTrue(Arrays.equals(in.getBytes(), out));
        in = " \\031Aa\\;\\\"\\\\~\\127\\255";
        byte[] exp = new byte[]{32, 31, 65, 97, 59, 34, 92, 126, 127, -1};
        out = SubRecord.byteArrayFromString(in);
        RecordTest.assertTrue(Arrays.equals(exp, out));
    }

    public void test_byteArrayFromString_invalid() {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < 257; ++i) {
            b.append('A');
        }
        try {
            SubRecord.byteArrayFromString(b.toString());
            RecordTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        try {
            SubRecord.byteArrayFromString("\\256");
            RecordTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        try {
            SubRecord.byteArrayFromString("\\25a");
            RecordTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        try {
            SubRecord.byteArrayFromString("\\25");
            RecordTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        b.append("\\233");
        try {
            SubRecord.byteArrayFromString(b.toString());
            RecordTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_byteArrayToString() {
        byte[] in = new byte[]{32, 31, 65, 97, 59, 34, 92, 126, 127, -1};
        String exp = "\" \\031Aa;\\\"\\\\~\\127\\255\"";
        RecordTest.assertEquals(exp, SubRecord.byteArrayToString(in, true));
    }

    public void test_unknownToString() {
        byte[] data = new byte[]{18, 52, 86, 120, -102, -68, -34, -1};
        String out = SubRecord.unknownToString(data);
        RecordTest.assertFalse(out.indexOf("" + data.length) == -1);
        RecordTest.assertFalse(out.indexOf("123456789ABCDEFF") == -1);
    }

    public void test_fromString() throws IOException, TextParseException {
        Name n = Name.fromString("My.N.");
        Name n2 = Name.fromString("My.Second.Name.");
        int t = 1;
        int d = 1;
        int ttl = 704153;
        String sa = "191.234.43.10";
        InetAddress addr = InetAddress.getByName(sa);
        byte[] b = new byte[]{-65, -22, 43, 10};
        Tokenizer st = new Tokenizer(sa);
        Record rec = Record.fromString(n, t, d, (long)ttl, st, n2);
        RecordTest.assertTrue(rec instanceof ARecord);
        RecordTest.assertEquals(n, rec.getName());
        RecordTest.assertEquals(t, rec.getType());
        RecordTest.assertEquals(d, rec.getDClass());
        RecordTest.assertEquals((long)ttl, rec.getTTL());
        RecordTest.assertEquals(addr, ((ARecord)rec).getAddress());
        String unkData = SubRecord.unknownToString(b);
        st = new Tokenizer(unkData);
        rec = Record.fromString(n, t, d, (long)ttl, st, n2);
        RecordTest.assertTrue(rec instanceof ARecord);
        RecordTest.assertEquals(n, rec.getName());
        RecordTest.assertEquals(t, rec.getType());
        RecordTest.assertEquals(d, rec.getDClass());
        RecordTest.assertEquals((long)ttl, rec.getTTL());
        RecordTest.assertEquals(addr, ((ARecord)rec).getAddress());
    }

    public void test_fromString_invalid() throws IOException, TextParseException {
        Name n = Name.fromString("My.N.");
        Name rel = Name.fromString("My.R");
        Name n2 = Name.fromString("My.Second.Name.");
        int t = 1;
        int d = 1;
        int ttl = 704153;
        InetAddress addr = InetAddress.getByName("191.234.43.10");
        Tokenizer st = new Tokenizer("191.234.43.10");
        try {
            Record.fromString(rel, t, d, (long)ttl, st, n2);
            RecordTest.fail("RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
        st = new Tokenizer("191.234.43.10 another_token");
        try {
            Record.fromString(n, t, d, (long)ttl, st, n2);
            RecordTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        st = new Tokenizer("\\# 100 ABCDE");
        try {
            Record.fromString(n, t, d, (long)ttl, st, n2);
            RecordTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        try {
            Record.fromString(n, t, d, (long)ttl, "\\# 100", n2);
            RecordTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
    }

    public void test_getRRsetType() throws TextParseException {
        Name n = Name.fromString("My.N.");
        Record r = Record.newRecord(n, 1, 1, 0L);
        RecordTest.assertEquals(1, r.getRRsetType());
        r = new RRSIGRecord(n, 1, 0L, 1, 1, 0L, new Date(), new Date(), 10, n, new byte[0]);
        RecordTest.assertEquals(1, r.getRRsetType());
    }

    public void test_sameRRset() throws TextParseException {
        Name n = Name.fromString("My.N.");
        Name m = Name.fromString("My.M.");
        Record r1 = Record.newRecord(n, 1, 1, 0L);
        RRSIGRecord r2 = new RRSIGRecord(n, 1, 0L, 1, 1, 0L, new Date(), new Date(), 10, n, new byte[0]);
        RecordTest.assertTrue(r1.sameRRset(r2));
        RecordTest.assertTrue(r2.sameRRset(r1));
        r1 = Record.newRecord(n, 1, 4, 0L);
        r2 = new RRSIGRecord(n, 1, 0L, 1, 1, 0L, new Date(), new Date(), 10, n, new byte[0]);
        RecordTest.assertFalse(r1.sameRRset(r2));
        RecordTest.assertFalse(r2.sameRRset(r1));
        r1 = Record.newRecord(n, 1, 1, 0L);
        r2 = new RRSIGRecord(m, 1, 0L, 1, 1, 0L, new Date(), new Date(), 10, n, new byte[0]);
        RecordTest.assertFalse(r1.sameRRset(r2));
        RecordTest.assertFalse(r2.sameRRset(r1));
    }

    public void test_equals() throws TextParseException {
        Name n = Name.fromString("My.N.");
        Name n2 = Name.fromString("my.n.");
        Name m = Name.fromString("My.M.");
        Record r1 = Record.newRecord(n, 1, 1, 0L);
        RecordTest.assertFalse(r1.equals(null));
        RecordTest.assertFalse(r1.equals(new Object()));
        Record r2 = Record.newRecord(n, 1, 1, 0L);
        RecordTest.assertEquals(r1, r2);
        RecordTest.assertEquals(r2, r1);
        r2 = Record.newRecord(n2, 1, 1, 0L);
        RecordTest.assertEquals(r1, r2);
        RecordTest.assertEquals(r2, r1);
        r2 = Record.newRecord(n2, 1, 1, 703710L);
        RecordTest.assertEquals(r1, r2);
        RecordTest.assertEquals(r2, r1);
        r2 = Record.newRecord(m, 1, 1, 703710L);
        RecordTest.assertFalse(r1.equals(r2));
        RecordTest.assertFalse(r2.equals(r1));
        r2 = Record.newRecord(n2, 15, 1, 703710L);
        RecordTest.assertFalse(r1.equals(r2));
        RecordTest.assertFalse(r2.equals(r1));
        r2 = Record.newRecord(n2, 1, 3, 703710L);
        RecordTest.assertFalse(r1.equals(r2));
        RecordTest.assertFalse(r2.equals(r1));
        byte[] d1 = new byte[]{23, 12, 9, -127};
        byte[] d2 = new byte[]{-36, 1, -125, -44};
        r1 = Record.newRecord(n, 1, 1, 11259369L, d1);
        r2 = Record.newRecord(n, 1, 1, 11259369L, d1);
        RecordTest.assertEquals(r1, r2);
        RecordTest.assertEquals(r2, r1);
        r2 = Record.newRecord(n, 1, 1, 11259369L, d2);
        RecordTest.assertFalse(r1.equals(r2));
        RecordTest.assertFalse(r2.equals(r1));
    }

    public void test_hashCode() throws TextParseException {
        Name n = Name.fromString("My.N.");
        Name n2 = Name.fromString("my.n.");
        Name m = Name.fromString("My.M.");
        byte[] d1 = new byte[]{23, 12, 9, -127};
        byte[] d2 = new byte[]{-36, 1, -125, -44};
        Record r1 = Record.newRecord(n, 1, 1, 11259369L, d1);
        Record r2 = Record.newRecord(n, 1, 1, 11259369L, d1);
        RecordTest.assertEquals(r1.hashCode(), r2.hashCode());
        r2 = Record.newRecord(n2, 1, 1, 11259369L, d1);
        RecordTest.assertEquals(r1.hashCode(), r2.hashCode());
        r2 = Record.newRecord(m, 1, 1, 11259369L, d1);
        RecordTest.assertFalse(r1.hashCode() == r2.hashCode());
        r2 = Record.newRecord(n, 1, 3, 11259369L, d1);
        RecordTest.assertFalse(r1.hashCode() == r2.hashCode());
        r2 = Record.newRecord(n, 1, 1, 703710L, d1);
        RecordTest.assertEquals(r1.hashCode(), r2.hashCode());
        r2 = Record.newRecord(n, 1, 1, 11259369L, d2);
        RecordTest.assertFalse(r1.hashCode() == r2.hashCode());
    }

    public void test_cloneRecord() throws TextParseException {
        Name n = Name.fromString("My.N.");
        byte[] d = new byte[]{23, 12, 9, -127};
        Record r = Record.newRecord(n, 1, 1, 11259369L, d);
        Record r2 = r.cloneRecord();
        RecordTest.assertNotSame(r, r2);
        RecordTest.assertEquals(r, r2);
        r = new SubRecord(n, 1, 1, 11259369L);
        try {
            r.cloneRecord();
            RecordTest.fail("IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    public void test_withName() throws TextParseException {
        Name n = Name.fromString("My.N.");
        Name m = Name.fromString("My.M.Name.");
        Name rel = Name.fromString("My.Relative.Name");
        byte[] d = new byte[]{23, 12, 9, -127};
        Record r = Record.newRecord(n, 1, 1, 11259369L, d);
        Record r1 = r.withName(m);
        RecordTest.assertEquals(m, r1.getName());
        RecordTest.assertEquals(1, r1.getType());
        RecordTest.assertEquals(1, r1.getDClass());
        RecordTest.assertEquals(11259369L, r1.getTTL());
        RecordTest.assertEquals(((ARecord)r).getAddress(), ((ARecord)r1).getAddress());
        try {
            r.withName(rel);
            RecordTest.fail("RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
    }

    public void test_withDClass() throws TextParseException {
        Name n = Name.fromString("My.N.");
        byte[] d = new byte[]{23, 12, 9, -127};
        Record r = Record.newRecord(n, 1, 1, 11259369L, d);
        Record r1 = r.withDClass(4, 39030L);
        RecordTest.assertEquals(n, r1.getName());
        RecordTest.assertEquals(1, r1.getType());
        RecordTest.assertEquals(4, r1.getDClass());
        RecordTest.assertEquals(39030L, r1.getTTL());
        RecordTest.assertEquals(((ARecord)r).getAddress(), ((ARecord)r1).getAddress());
    }

    public void test_setTTL() throws TextParseException, UnknownHostException {
        Name n = Name.fromString("My.N.");
        byte[] d = new byte[]{23, 12, 9, -127};
        InetAddress exp = InetAddress.getByName("23.12.9.129");
        Record r = Record.newRecord(n, 1, 1, 11259369L, d);
        RecordTest.assertEquals(11259369L, r.getTTL());
        r.setTTL(39030L);
        RecordTest.assertEquals(n, r.getName());
        RecordTest.assertEquals(1, r.getType());
        RecordTest.assertEquals(1, r.getDClass());
        RecordTest.assertEquals(39030L, r.getTTL());
        RecordTest.assertEquals(exp, ((ARecord)r).getAddress());
    }

    public void test_compareTo() throws TextParseException {
        Name n = Name.fromString("My.N.");
        Name n2 = Name.fromString("my.n.");
        Name m = Name.fromString("My.M.");
        byte[] d = new byte[]{23, 12, 9, -127};
        byte[] d2 = new byte[]{23, 12, 9, -128};
        Record r1 = Record.newRecord(n, 1, 1, 11259369L, d);
        Record r2 = Record.newRecord(n, 1, 1, 11259369L, d);
        RecordTest.assertEquals(0, r1.compareTo(r1));
        RecordTest.assertEquals(0, r1.compareTo(r2));
        RecordTest.assertEquals(0, r2.compareTo(r1));
        r2 = Record.newRecord(n2, 1, 1, 11259369L, d);
        RecordTest.assertEquals(0, r1.compareTo(r2));
        RecordTest.assertEquals(0, r2.compareTo(r1));
        r2 = Record.newRecord(m, 1, 1, 11259369L, d);
        RecordTest.assertEquals(n.compareTo(m), r1.compareTo(r2));
        RecordTest.assertEquals(m.compareTo(n), r2.compareTo(r1));
        r2 = Record.newRecord(n, 1, 3, 11259369L, d);
        RecordTest.assertEquals(-2, r1.compareTo(r2));
        RecordTest.assertEquals(2, r2.compareTo(r1));
        r2 = Record.newRecord(n, 2, 1, 11259369L, m.toWire());
        RecordTest.assertEquals(-1, r1.compareTo(r2));
        RecordTest.assertEquals(1, r2.compareTo(r1));
        r2 = Record.newRecord(n, 1, 1, 11259369L, d2);
        RecordTest.assertEquals(1, r1.compareTo(r2));
        RecordTest.assertEquals(-1, r2.compareTo(r1));
        m = Name.fromString("My.N.L.");
        r1 = Record.newRecord(n, 2, 1, 11259369L, n.toWire());
        r2 = Record.newRecord(n, 2, 1, 11259369L, m.toWire());
        RecordTest.assertEquals(-1, r1.compareTo(r2));
        RecordTest.assertEquals(1, r2.compareTo(r1));
    }

    public void test_getAdditionalName() throws TextParseException {
        Name n = Name.fromString("My.N.");
        SubRecord r = new SubRecord(n, 1, 1, 11259369L);
        RecordTest.assertNull(r.getAdditionalName());
    }

    public void test_checkU8() {
        try {
            Record.checkU8("field", -1);
            RecordTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        RecordTest.assertEquals(0, Record.checkU8("field", 0));
        RecordTest.assertEquals(157, Record.checkU8("field", 157));
        RecordTest.assertEquals(255, Record.checkU8("field", 255));
        try {
            Record.checkU8("field", 256);
            RecordTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_checkU16() {
        try {
            Record.checkU16("field", -1);
            RecordTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        RecordTest.assertEquals(0, Record.checkU16("field", 0));
        RecordTest.assertEquals(40353, Record.checkU16("field", 40353));
        RecordTest.assertEquals(65535, Record.checkU16("field", 65535));
        try {
            Record.checkU16("field", 65536);
            RecordTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_checkU32() {
        try {
            Record.checkU32("field", -1L);
            RecordTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        RecordTest.assertEquals(0L, Record.checkU32("field", 0L));
        RecordTest.assertEquals(2644635693L, Record.checkU32("field", 2644635693L));
        RecordTest.assertEquals(0xFFFFFFFFL, Record.checkU32("field", 0xFFFFFFFFL));
        try {
            Record.checkU32("field", 0x100000000L);
            RecordTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_checkName() throws TextParseException {
        Name n = Name.fromString("My.N.");
        Name m = Name.fromString("My.m");
        RecordTest.assertEquals(n, Record.checkName("field", n));
        try {
            Record.checkName("field", m);
            RecordTest.fail("RelativeNameException not thrown");
        }
        catch (RelativeNameException relativeNameException) {
            // empty catch block
        }
    }

    private static class SubRecord
    extends Record {
        public SubRecord() {
        }

        public SubRecord(Name name, int type, int dclass, long ttl) {
            super(name, type, dclass, ttl);
        }

        public Record getObject() {
            return null;
        }

        public void rrFromWire(DNSInput in) throws IOException {
        }

        public String rrToString() {
            return "{SubRecord: rrToString}";
        }

        public void rdataFromString(Tokenizer t, Name origin) throws IOException {
        }

        public void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        }

        public static byte[] byteArrayFromString(String in) throws TextParseException {
            return Record.byteArrayFromString(in);
        }

        public static String byteArrayToString(byte[] in, boolean quote) {
            return Record.byteArrayToString(in, quote);
        }

        public static String unknownToString(byte[] in) {
            return Record.unknownToString(in);
        }

        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }
    }
}

