/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import junit.framework.TestCase;
import org.xbill.DNS.Rcode;

public class RcodeTest
extends TestCase {
    public void test_string() {
        RcodeTest.assertEquals("NXDOMAIN", Rcode.string(3));
        RcodeTest.assertEquals("NOTIMP", Rcode.string(4));
        RcodeTest.assertTrue(Rcode.string(20).startsWith("RESERVED"));
        try {
            Rcode.string(-1);
            RcodeTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Rcode.string(4096);
            RcodeTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_TSIGstring() {
        RcodeTest.assertEquals("BADSIG", Rcode.TSIGstring(16));
        RcodeTest.assertTrue(Rcode.TSIGstring(20).startsWith("RESERVED"));
        try {
            Rcode.TSIGstring(-1);
            RcodeTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Rcode.string(65536);
            RcodeTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_value() {
        RcodeTest.assertEquals(1, Rcode.value("FORMERR"));
        RcodeTest.assertEquals(4, Rcode.value("NOTIMP"));
        RcodeTest.assertEquals(4, Rcode.value("NOTIMPL"));
        RcodeTest.assertEquals(35, Rcode.value("RESERVED35"));
        RcodeTest.assertEquals(-1, Rcode.value("RESERVED4096"));
        RcodeTest.assertEquals(-1, Rcode.value("THIS IS DEFINITELY UNKNOWN"));
        RcodeTest.assertEquals(-1, Rcode.value(""));
    }
}

