/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import junit.framework.TestCase;
import org.xbill.DNS.Options;

public class OptionsTest
extends TestCase {
    public void setUp() {
        Options.clear();
    }

    public void test_set_1arg() {
        Options.set("Option1");
        OptionsTest.assertEquals("true", Options.value("option1"));
        Options.set("OPTION2");
        OptionsTest.assertEquals("true", Options.value("option1"));
        OptionsTest.assertEquals("true", Options.value("OpTIOn2"));
        Options.set("option2");
        OptionsTest.assertEquals("true", Options.value("option2"));
    }

    public void test_set_2arg() {
        Options.set("OPTION1", "Value1");
        OptionsTest.assertEquals("value1", Options.value("Option1"));
        Options.set("option2", "value2");
        OptionsTest.assertEquals("value1", Options.value("Option1"));
        OptionsTest.assertEquals("value2", Options.value("OPTION2"));
        Options.set("OPTION2", "value2b");
        OptionsTest.assertEquals("value1", Options.value("Option1"));
        OptionsTest.assertEquals("value2b", Options.value("option2"));
    }

    public void test_check() {
        OptionsTest.assertFalse(Options.check("No Options yet"));
        Options.set("First Option");
        OptionsTest.assertFalse(Options.check("Not a valid option name"));
        OptionsTest.assertTrue(Options.check("First Option"));
        OptionsTest.assertTrue(Options.check("FIRST option"));
    }

    public void test_unset() {
        Options.unset("Not an option Name");
        Options.set("Temporary Option");
        OptionsTest.assertTrue(Options.check("Temporary Option"));
        Options.unset("Temporary Option");
        OptionsTest.assertFalse(Options.check("Temporary Option"));
        Options.set("Temporary Option");
        OptionsTest.assertTrue(Options.check("Temporary Option"));
        Options.unset("temporary option");
        OptionsTest.assertFalse(Options.check("Temporary Option"));
        Options.unset("Still Not an Option Name");
    }

    public void test_value() {
        OptionsTest.assertNull(Options.value("Table is Null"));
        Options.set("Testing Option");
        OptionsTest.assertNull(Options.value("Not an Option Name"));
        OptionsTest.assertEquals("true", Options.value("Testing OPTION"));
    }

    public void test_intValue() {
        OptionsTest.assertEquals(-1, Options.intValue("Table is Null"));
        Options.set("A Boolean Option");
        Options.set("An Int Option", "13");
        Options.set("Not An Int Option", "NotAnInt");
        Options.set("A Negative Int Value", "-1000");
        OptionsTest.assertEquals(-1, Options.intValue("A Boolean Option"));
        OptionsTest.assertEquals(-1, Options.intValue("Not an Option NAME"));
        OptionsTest.assertEquals(13, Options.intValue("an int option"));
        OptionsTest.assertEquals(-1, Options.intValue("NOT an INT option"));
        OptionsTest.assertEquals(-1, Options.intValue("A negative int Value"));
    }

    public void test_systemProperty() {
        System.setProperty("dnsjava.options", "booleanOption,valuedOption1=10,valuedOption2=NotAnInteger");
        Options.refresh();
        OptionsTest.assertTrue(Options.check("booleanOPTION"));
        OptionsTest.assertTrue(Options.check("booleanOption"));
        OptionsTest.assertTrue(Options.check("valuedOption1"));
        OptionsTest.assertTrue(Options.check("ValuedOption2"));
        OptionsTest.assertEquals("true", Options.value("booleanOption"));
        OptionsTest.assertEquals(-1, Options.intValue("BOOLEANOPTION"));
        OptionsTest.assertEquals("10", Options.value("valuedOption1"));
        OptionsTest.assertEquals(10, Options.intValue("valuedOption1"));
        OptionsTest.assertEquals("notaninteger", Options.value("VALUEDOPTION2"));
        OptionsTest.assertEquals(-1, Options.intValue("valuedOption2"));
    }
}

