/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import junit.framework.TestCase;
import org.xbill.DNS.Mnemonic;

public class MnemonicTest
extends TestCase {
    private Mnemonic m_mn;

    public MnemonicTest(String name) {
        super(name);
    }

    public void setUp() {
        this.m_mn = new Mnemonic(MnemonicTest.class.getName() + " UPPER", 2);
    }

    public void test_toInteger() {
        Integer i = Mnemonic.toInteger(64);
        MnemonicTest.assertEquals(new Integer(64), i);
        Integer i2 = Mnemonic.toInteger(64);
        MnemonicTest.assertEquals(i, i2);
        MnemonicTest.assertNotSame(i, i2);
        i = Mnemonic.toInteger(-1);
        MnemonicTest.assertEquals(new Integer(-1), i);
        i2 = Mnemonic.toInteger(-1);
        MnemonicTest.assertEquals(i, i2);
        MnemonicTest.assertNotSame(i, i2);
        i = Mnemonic.toInteger(0);
        MnemonicTest.assertEquals(new Integer(0), i);
        i2 = Mnemonic.toInteger(0);
        MnemonicTest.assertEquals(i, i2);
        MnemonicTest.assertSame(i, i2);
        i = Mnemonic.toInteger(63);
        MnemonicTest.assertEquals(new Integer(63), i);
        i2 = Mnemonic.toInteger(63);
        MnemonicTest.assertEquals(i, i2);
        MnemonicTest.assertSame(i, i2);
    }

    public void test_no_maximum() {
        try {
            this.m_mn.check(-1);
            MnemonicTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_mn.check(0);
        }
        catch (IllegalArgumentException e) {
            MnemonicTest.fail(e.getMessage());
        }
        try {
            this.m_mn.check(Integer.MAX_VALUE);
        }
        catch (IllegalArgumentException e) {
            MnemonicTest.fail(e.getMessage());
        }
        this.m_mn.setNumericAllowed(true);
        int val = this.m_mn.getValue("-2");
        MnemonicTest.assertEquals(-1, val);
        val = this.m_mn.getValue("0");
        MnemonicTest.assertEquals(0, val);
        val = this.m_mn.getValue("2147483647");
        MnemonicTest.assertEquals(Integer.MAX_VALUE, val);
    }

    public void test_setMaximum() {
        this.m_mn.setMaximum(15);
        try {
            this.m_mn.check(-1);
            MnemonicTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_mn.check(0);
        }
        catch (IllegalArgumentException e) {
            MnemonicTest.fail(e.getMessage());
        }
        try {
            this.m_mn.check(15);
        }
        catch (IllegalArgumentException e) {
            MnemonicTest.fail(e.getMessage());
        }
        try {
            this.m_mn.check(16);
            MnemonicTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.m_mn.setNumericAllowed(true);
        int val = this.m_mn.getValue("-2");
        MnemonicTest.assertEquals(-1, val);
        val = this.m_mn.getValue("0");
        MnemonicTest.assertEquals(0, val);
        val = this.m_mn.getValue("15");
        MnemonicTest.assertEquals(15, val);
        val = this.m_mn.getValue("16");
        MnemonicTest.assertEquals(-1, val);
    }

    public void test_setPrefix() {
        String prefix = "A mixed CASE Prefix".toUpperCase();
        this.m_mn.setPrefix(prefix);
        String out = this.m_mn.getText(10);
        MnemonicTest.assertEquals(prefix + "10", out);
        int i = this.m_mn.getValue(out);
        MnemonicTest.assertEquals(10, i);
    }

    public void test_basic_operation() {
        this.m_mn.add(10, "Ten");
        this.m_mn.add(20, "Twenty");
        this.m_mn.addAlias(20, "Veinte");
        this.m_mn.add(30, "Thirty");
        String text = this.m_mn.getText(10);
        MnemonicTest.assertEquals("TEN", text);
        text = this.m_mn.getText(20);
        MnemonicTest.assertEquals("TWENTY", text);
        text = this.m_mn.getText(30);
        MnemonicTest.assertEquals("THIRTY", text);
        text = this.m_mn.getText(40);
        MnemonicTest.assertEquals("40", text);
        int value = this.m_mn.getValue("tEn");
        MnemonicTest.assertEquals(10, value);
        value = this.m_mn.getValue("twenty");
        MnemonicTest.assertEquals(20, value);
        value = this.m_mn.getValue("VeiNTe");
        MnemonicTest.assertEquals(20, value);
        value = this.m_mn.getValue("THIRTY");
        MnemonicTest.assertEquals(30, value);
    }

    public void test_basic_operation_lower() {
        this.m_mn = new Mnemonic(MnemonicTest.class.getName() + " LOWER", 3);
        this.m_mn.add(10, "Ten");
        this.m_mn.add(20, "Twenty");
        this.m_mn.addAlias(20, "Veinte");
        this.m_mn.add(30, "Thirty");
        String text = this.m_mn.getText(10);
        MnemonicTest.assertEquals("ten", text);
        text = this.m_mn.getText(20);
        MnemonicTest.assertEquals("twenty", text);
        text = this.m_mn.getText(30);
        MnemonicTest.assertEquals("thirty", text);
        text = this.m_mn.getText(40);
        MnemonicTest.assertEquals("40", text);
        int value = this.m_mn.getValue("tEn");
        MnemonicTest.assertEquals(10, value);
        value = this.m_mn.getValue("twenty");
        MnemonicTest.assertEquals(20, value);
        value = this.m_mn.getValue("VeiNTe");
        MnemonicTest.assertEquals(20, value);
        value = this.m_mn.getValue("THIRTY");
        MnemonicTest.assertEquals(30, value);
    }

    public void test_basic_operation_sensitive() {
        this.m_mn = new Mnemonic(MnemonicTest.class.getName() + " SENSITIVE", 1);
        this.m_mn.add(10, "Ten");
        this.m_mn.add(20, "Twenty");
        this.m_mn.addAlias(20, "Veinte");
        this.m_mn.add(30, "Thirty");
        String text = this.m_mn.getText(10);
        MnemonicTest.assertEquals("Ten", text);
        text = this.m_mn.getText(20);
        MnemonicTest.assertEquals("Twenty", text);
        text = this.m_mn.getText(30);
        MnemonicTest.assertEquals("Thirty", text);
        text = this.m_mn.getText(40);
        MnemonicTest.assertEquals("40", text);
        int value = this.m_mn.getValue("Ten");
        MnemonicTest.assertEquals(10, value);
        value = this.m_mn.getValue("twenty");
        MnemonicTest.assertEquals(-1, value);
        value = this.m_mn.getValue("Twenty");
        MnemonicTest.assertEquals(20, value);
        value = this.m_mn.getValue("VEINTE");
        MnemonicTest.assertEquals(-1, value);
        value = this.m_mn.getValue("Veinte");
        MnemonicTest.assertEquals(20, value);
        value = this.m_mn.getValue("Thirty");
        MnemonicTest.assertEquals(30, value);
    }

    public void test_invalid_numeric() {
        this.m_mn.setNumericAllowed(true);
        int value = this.m_mn.getValue("Not-A-Number");
        MnemonicTest.assertEquals(-1, value);
    }

    public void test_addAll() {
        this.m_mn.add(10, "Ten");
        this.m_mn.add(20, "Twenty");
        Mnemonic mn2 = new Mnemonic("second test Mnemonic", 2);
        mn2.add(20, "Twenty");
        mn2.addAlias(20, "Veinte");
        mn2.add(30, "Thirty");
        this.m_mn.addAll(mn2);
        String text = this.m_mn.getText(10);
        MnemonicTest.assertEquals("TEN", text);
        text = this.m_mn.getText(20);
        MnemonicTest.assertEquals("TWENTY", text);
        text = this.m_mn.getText(30);
        MnemonicTest.assertEquals("THIRTY", text);
        text = this.m_mn.getText(40);
        MnemonicTest.assertEquals("40", text);
        int value = this.m_mn.getValue("tEn");
        MnemonicTest.assertEquals(10, value);
        value = this.m_mn.getValue("twenty");
        MnemonicTest.assertEquals(20, value);
        value = this.m_mn.getValue("VeiNTe");
        MnemonicTest.assertEquals(20, value);
        value = this.m_mn.getValue("THIRTY");
        MnemonicTest.assertEquals(30, value);
    }
}

