/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.KEYBase;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.base64;

public class KEYBaseTest
extends TestCase {
    public void test_ctor() throws TextParseException {
        TestClass tc = new TestClass();
        KEYBaseTest.assertEquals(0, tc.getFlags());
        KEYBaseTest.assertEquals(0, tc.getProtocol());
        KEYBaseTest.assertEquals(0, tc.getAlgorithm());
        KEYBaseTest.assertNull(tc.getKey());
        Name n = Name.fromString("my.name.");
        byte[] key = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        tc = new TestClass(n, 25, 1, 100L, 255, 15, 14, key);
        KEYBaseTest.assertSame(n, tc.getName());
        KEYBaseTest.assertEquals(25, tc.getType());
        KEYBaseTest.assertEquals(1, tc.getDClass());
        KEYBaseTest.assertEquals(100L, tc.getTTL());
        KEYBaseTest.assertEquals(255, tc.getFlags());
        KEYBaseTest.assertEquals(15, tc.getProtocol());
        KEYBaseTest.assertEquals(14, tc.getAlgorithm());
        KEYBaseTest.assertTrue(Arrays.equals(key, tc.getKey()));
    }

    public void test_rrFromWire() throws IOException {
        byte[] raw = new byte[]{-85, -51, -17, 25, 1, 2, 3, 4, 5};
        DNSInput in = new DNSInput(raw);
        TestClass tc = new TestClass();
        tc.rrFromWire(in);
        KEYBaseTest.assertEquals(43981, tc.getFlags());
        KEYBaseTest.assertEquals(239, tc.getProtocol());
        KEYBaseTest.assertEquals(25, tc.getAlgorithm());
        KEYBaseTest.assertTrue(Arrays.equals(new byte[]{1, 2, 3, 4, 5}, tc.getKey()));
        raw = new byte[]{-70, -38, -1, 40};
        in = new DNSInput(raw);
        tc = new TestClass();
        tc.rrFromWire(in);
        KEYBaseTest.assertEquals(47834, tc.getFlags());
        KEYBaseTest.assertEquals(255, tc.getProtocol());
        KEYBaseTest.assertEquals(40, tc.getAlgorithm());
        KEYBaseTest.assertNull(tc.getKey());
    }

    public void test_rrToString() throws IOException, TextParseException {
        Name n = Name.fromString("my.name.");
        byte[] key = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        TestClass tc = new TestClass(n, 25, 1, 100L, 255, 15, 14, null);
        String out = tc.rrToString();
        KEYBaseTest.assertEquals("255 15 14", out);
        tc = new TestClass(n, 25, 1, 100L, 255, 15, 14, key);
        out = tc.rrToString();
        KEYBaseTest.assertEquals("255 15 14 " + base64.toString(key), out);
        Options.set("multiline");
        out = tc.rrToString();
        KEYBaseTest.assertEquals("255 15 14 (\n\t" + base64.toString(key) + " ) ; key_tag = 18509", out);
        Options.unset("multiline");
    }

    public void test_getFootprint() throws TextParseException {
        Name n = Name.fromString("my.name.");
        byte[] key = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        TestClass tc = new TestClass(n, 25, 1, 100L, 255, 15, 1, key);
        int foot = tc.getFootprint();
        KEYBaseTest.assertEquals(3342, foot);
        KEYBaseTest.assertEquals(foot, tc.getFootprint());
        tc = new TestClass(n, 25, 1, 100L, 35243, 205, 239, new byte[]{18, 52, 86});
        foot = tc.getFootprint();
        KEYBaseTest.assertEquals(49103, foot);
        KEYBaseTest.assertEquals(foot, tc.getFootprint());
        tc = new TestClass();
        KEYBaseTest.assertEquals(0, tc.getFootprint());
    }

    public void test_rrToWire() throws IOException, TextParseException {
        Name n = Name.fromString("my.name.");
        byte[] key = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        TestClass tc = new TestClass(n, 25, 1, 100L, 30345, 171, 205, key);
        byte[] exp = new byte[]{118, -119, -85, -51, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        DNSOutput o = new DNSOutput();
        tc.rrToWire(o, null, true);
        KEYBaseTest.assertTrue(Arrays.equals(exp, o.toByteArray()));
        o = new DNSOutput();
        tc.rrToWire(o, null, false);
        KEYBaseTest.assertTrue(Arrays.equals(exp, o.toByteArray()));
    }

    private static class TestClass
    extends KEYBase {
        public TestClass() {
        }

        public TestClass(Name name, int type, int dclass, long ttl, int flags, int proto, int alg, byte[] key) {
            super(name, type, dclass, ttl, flags, proto, alg, key);
        }

        public Record getObject() {
            return null;
        }

        void rdataFromString(Tokenizer st, Name origin) throws IOException {
        }
    }
}

