/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import junit.framework.TestCase;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Header;
import org.xbill.DNS.Opcode;
import org.xbill.DNS.Rcode;

public class HeaderTest
extends TestCase {
    private Header m_h;

    public void setUp() {
        this.m_h = new Header(43981);
    }

    public void test_fixture_state() {
        HeaderTest.assertEquals(43981, this.m_h.getID());
        boolean[] flags = this.m_h.getFlags();
        for (int i = 0; i < flags.length; ++i) {
            HeaderTest.assertFalse(flags[i]);
        }
        HeaderTest.assertEquals(0, this.m_h.getRcode());
        HeaderTest.assertEquals(0, this.m_h.getOpcode());
        HeaderTest.assertEquals(0, this.m_h.getCount(0));
        HeaderTest.assertEquals(0, this.m_h.getCount(1));
        HeaderTest.assertEquals(0, this.m_h.getCount(2));
        HeaderTest.assertEquals(0, this.m_h.getCount(3));
    }

    public void test_ctor_0arg() {
        this.m_h = new Header();
        HeaderTest.assertTrue(0 <= this.m_h.getID() && this.m_h.getID() < 65535);
        boolean[] flags = this.m_h.getFlags();
        for (int i = 0; i < flags.length; ++i) {
            HeaderTest.assertFalse(flags[i]);
        }
        HeaderTest.assertEquals(0, this.m_h.getRcode());
        HeaderTest.assertEquals(0, this.m_h.getOpcode());
        HeaderTest.assertEquals(0, this.m_h.getCount(0));
        HeaderTest.assertEquals(0, this.m_h.getCount(1));
        HeaderTest.assertEquals(0, this.m_h.getCount(2));
        HeaderTest.assertEquals(0, this.m_h.getCount(3));
    }

    public void test_ctor_DNSInput() throws IOException {
        byte[] raw = new byte[]{18, -85, -113, -67, 101, 28, 16, -16, -104, -70, 113, -112};
        this.m_h = new Header(new DNSInput(raw));
        HeaderTest.assertEquals(4779, this.m_h.getID());
        boolean[] flags = this.m_h.getFlags();
        HeaderTest.assertTrue(flags[0]);
        HeaderTest.assertEquals(1, this.m_h.getOpcode());
        HeaderTest.assertTrue(flags[5]);
        HeaderTest.assertTrue(flags[6]);
        HeaderTest.assertTrue(flags[7]);
        HeaderTest.assertTrue(flags[8]);
        HeaderTest.assertFalse(flags[9]);
        HeaderTest.assertTrue(flags[10]);
        HeaderTest.assertTrue(flags[11]);
        HeaderTest.assertEquals(13, this.m_h.getRcode());
        HeaderTest.assertEquals(25884, this.m_h.getCount(0));
        HeaderTest.assertEquals(4336, this.m_h.getCount(1));
        HeaderTest.assertEquals(39098, this.m_h.getCount(2));
        HeaderTest.assertEquals(29072, this.m_h.getCount(3));
    }

    public void test_toWire() throws IOException {
        int i;
        byte[] raw = new byte[]{18, -85, -113, -67, 101, 28, 16, -16, -104, -70, 113, -112};
        this.m_h = new Header(raw);
        DNSOutput dout = new DNSOutput();
        this.m_h.toWire(dout);
        byte[] out = dout.toByteArray();
        HeaderTest.assertEquals(12, out.length);
        for (i = 0; i < out.length; ++i) {
            HeaderTest.assertEquals(raw[i], out[i]);
        }
        this.m_h.setOpcode(10);
        HeaderTest.assertEquals(10, this.m_h.getOpcode());
        this.m_h.setRcode(7);
        raw[2] = -41;
        raw[3] = -73;
        out = this.m_h.toWire();
        HeaderTest.assertEquals(12, out.length);
        for (i = 0; i < out.length; ++i) {
            HeaderTest.assertEquals("i=" + i, raw[i], out[i]);
        }
    }

    public void test_flags() {
        this.m_h.setFlag(0);
        this.m_h.setFlag(5);
        HeaderTest.assertTrue(this.m_h.getFlag(0));
        HeaderTest.assertTrue(this.m_h.getFlags()[0]);
        HeaderTest.assertTrue(this.m_h.getFlag(5));
        HeaderTest.assertTrue(this.m_h.getFlags()[5]);
        this.m_h.unsetFlag(0);
        HeaderTest.assertFalse(this.m_h.getFlag(0));
        HeaderTest.assertFalse(this.m_h.getFlags()[0]);
        HeaderTest.assertTrue(this.m_h.getFlag(5));
        HeaderTest.assertTrue(this.m_h.getFlags()[5]);
        this.m_h.unsetFlag(5);
        HeaderTest.assertFalse(this.m_h.getFlag(0));
        HeaderTest.assertFalse(this.m_h.getFlags()[0]);
        HeaderTest.assertFalse(this.m_h.getFlag(5));
        HeaderTest.assertFalse(this.m_h.getFlags()[5]);
        boolean[] flags = this.m_h.getFlags();
        for (int i = 0; i < flags.length; ++i) {
            if (i > 0 && i < 5 || i > 11) continue;
            HeaderTest.assertFalse(flags[i]);
        }
    }

    public void test_flags_invalid() {
        try {
            this.m_h.setFlag(-1);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.setFlag(1);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.setFlag(16);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.unsetFlag(-1);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.unsetFlag(13);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.unsetFlag(16);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.getFlag(-1);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.getFlag(4);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.getFlag(16);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_ID() {
        HeaderTest.assertEquals(43981, this.m_h.getID());
        this.m_h = new Header();
        int id = this.m_h.getID();
        HeaderTest.assertEquals(id, this.m_h.getID());
        HeaderTest.assertTrue(id >= 0 && id < 65535);
        this.m_h.setID(56506);
        HeaderTest.assertEquals(56506, this.m_h.getID());
    }

    public void test_setID_invalid() {
        try {
            this.m_h.setID(65536);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.setID(-1);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_Rcode() {
        HeaderTest.assertEquals(0, this.m_h.getRcode());
        this.m_h.setRcode(10);
        HeaderTest.assertEquals(10, this.m_h.getRcode());
        for (int i = 0; i < 12; ++i) {
            if (i > 0 && i < 5 || i > 11) continue;
            HeaderTest.assertFalse(this.m_h.getFlag(i));
        }
    }

    public void test_setRcode_invalid() {
        try {
            this.m_h.setRcode(-1);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.setRcode(256);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_Opcode() {
        HeaderTest.assertEquals(0, this.m_h.getOpcode());
        this.m_h.setOpcode(14);
        HeaderTest.assertEquals(14, this.m_h.getOpcode());
        HeaderTest.assertFalse(this.m_h.getFlag(0));
        for (int i = 5; i < 12; ++i) {
            HeaderTest.assertFalse(this.m_h.getFlag(i));
        }
        HeaderTest.assertEquals(0, this.m_h.getRcode());
    }

    public void test_setOpcode_invalid() {
        try {
            this.m_h.setOpcode(-1);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.setOpcode(256);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_Count() {
        this.m_h.setCount(2, 30);
        HeaderTest.assertEquals(0, this.m_h.getCount(0));
        HeaderTest.assertEquals(0, this.m_h.getCount(1));
        HeaderTest.assertEquals(30, this.m_h.getCount(2));
        HeaderTest.assertEquals(0, this.m_h.getCount(3));
        this.m_h.incCount(0);
        HeaderTest.assertEquals(1, this.m_h.getCount(0));
        this.m_h.decCount(2);
        HeaderTest.assertEquals(29, this.m_h.getCount(2));
    }

    public void test_setCount_invalid() {
        try {
            this.m_h.setCount(-1, 0);
            HeaderTest.fail("ArrayIndexOutOfBoundsException not thrown");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.m_h.setCount(4, 0);
            HeaderTest.fail("ArrayIndexOutOfBoundsException not thrown");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.m_h.setCount(0, -1);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.setCount(3, 65536);
            HeaderTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_getCount_invalid() {
        try {
            this.m_h.getCount(-1);
            HeaderTest.fail("ArrayIndexOutOfBoundsException not thrown");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.m_h.getCount(4);
            HeaderTest.fail("ArrayIndexOutOfBoundsException not thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_incCount_invalid() {
        this.m_h.setCount(1, 65535);
        try {
            this.m_h.incCount(1);
            HeaderTest.fail("IllegalStateException not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void test_decCount_invalid() {
        this.m_h.setCount(2, 0);
        try {
            this.m_h.decCount(2);
            HeaderTest.fail("IllegalStateException not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void test_toString() {
        this.m_h.setOpcode(Opcode.value("STATUS"));
        this.m_h.setRcode(Rcode.value("NXDOMAIN"));
        this.m_h.setFlag(0);
        this.m_h.setFlag(7);
        this.m_h.setFlag(8);
        this.m_h.setFlag(11);
        this.m_h.setCount(1, 255);
        this.m_h.setCount(2, 10);
        String text = this.m_h.toString();
        HeaderTest.assertFalse(text.indexOf("id: 43981") == -1);
        HeaderTest.assertFalse(text.indexOf("opcode: STATUS") == -1);
        HeaderTest.assertFalse(text.indexOf("status: NXDOMAIN") == -1);
        HeaderTest.assertFalse(text.indexOf(" qr ") == -1);
        HeaderTest.assertFalse(text.indexOf(" rd ") == -1);
        HeaderTest.assertFalse(text.indexOf(" ra ") == -1);
        HeaderTest.assertFalse(text.indexOf(" cd ") == -1);
        HeaderTest.assertFalse(text.indexOf("qd: 0 ") == -1);
        HeaderTest.assertFalse(text.indexOf("an: 255 ") == -1);
        HeaderTest.assertFalse(text.indexOf("au: 10 ") == -1);
        HeaderTest.assertFalse(text.indexOf("ad: 0 ") == -1);
    }

    public void test_clone() {
        int i;
        this.m_h.setOpcode(Opcode.value("IQUERY"));
        this.m_h.setRcode(Rcode.value("SERVFAIL"));
        this.m_h.setFlag(0);
        this.m_h.setFlag(7);
        this.m_h.setFlag(8);
        this.m_h.setFlag(11);
        this.m_h.setCount(1, 255);
        this.m_h.setCount(2, 10);
        Header h2 = (Header)this.m_h.clone();
        HeaderTest.assertNotSame(this.m_h, h2);
        HeaderTest.assertEquals(this.m_h.getID(), h2.getID());
        for (i = 0; i < 16; ++i) {
            if (i > 0 && i < 5 || i > 11) continue;
            HeaderTest.assertEquals(this.m_h.getFlag(i), h2.getFlag(i));
        }
        for (i = 0; i < 4; ++i) {
            HeaderTest.assertEquals(this.m_h.getCount(i), h2.getCount(i));
        }
    }
}

