/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import junit.framework.TestCase;
import org.xbill.DNS.Flags;

public class FlagsTest
extends TestCase {
    public void test_string() {
        FlagsTest.assertEquals("aa", Flags.string(5));
        FlagsTest.assertTrue(Flags.string(12).startsWith("flag"));
        try {
            Flags.string(-1);
            FlagsTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Flags.string(16);
            FlagsTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_value() {
        FlagsTest.assertEquals(11, Flags.value("cd"));
        FlagsTest.assertEquals(13, Flags.value("FLAG13"));
        FlagsTest.assertEquals(-1, Flags.value("FLAG16"));
        FlagsTest.assertEquals(-1, Flags.value("THIS IS DEFINITELY UNKNOWN"));
        FlagsTest.assertEquals(-1, Flags.value(""));
    }

    public void test_isFlag() {
        try {
            Flags.isFlag(-1);
            FlagsTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        FlagsTest.assertTrue(Flags.isFlag(0));
        FlagsTest.assertFalse(Flags.isFlag(1));
        FlagsTest.assertFalse(Flags.isFlag(2));
        FlagsTest.assertFalse(Flags.isFlag(3));
        FlagsTest.assertFalse(Flags.isFlag(4));
        FlagsTest.assertTrue(Flags.isFlag(5));
        FlagsTest.assertTrue(Flags.isFlag(6));
        FlagsTest.assertTrue(Flags.isFlag(7));
        FlagsTest.assertTrue(Flags.isFlag(8));
        FlagsTest.assertTrue(Flags.isFlag(9));
        FlagsTest.assertTrue(Flags.isFlag(10));
        FlagsTest.assertTrue(Flags.isFlag(11));
        FlagsTest.assertFalse(Flags.isFlag(12));
        FlagsTest.assertFalse(Flags.isFlag(13));
        FlagsTest.assertFalse(Flags.isFlag(14));
        FlagsTest.assertFalse(Flags.isFlag(14));
        try {
            Flags.isFlag(16);
            FlagsTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

