/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import junit.framework.TestCase;
import org.xbill.DNS.InvalidDClassException;
import org.xbill.DNS.InvalidTTLException;
import org.xbill.DNS.InvalidTypeException;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.ZoneTransferException;

public class ExceptionTest
extends TestCase {
    public void test_InvalidDClassException() {
        InvalidDClassException e = new InvalidDClassException(10);
        ExceptionTest.assertEquals("Invalid DNS class: 10", e.getMessage());
    }

    public void test_InvalidTTLException() {
        InvalidTTLException e = new InvalidTTLException(32345L);
        ExceptionTest.assertEquals("Invalid DNS TTL: 32345", e.getMessage());
    }

    public void test_InvalidTypeException() {
        InvalidTypeException e = new InvalidTypeException(32345);
        ExceptionTest.assertEquals("Invalid DNS type: 32345", e.getMessage());
    }

    public void test_NameTooLongException() {
        NameTooLongException e = new NameTooLongException();
        ExceptionTest.assertNull(e.getMessage());
        e = new NameTooLongException("This is my too long name");
        ExceptionTest.assertEquals("This is my too long name", e.getMessage());
    }

    public void test_RelativeNameException() throws TextParseException {
        RelativeNameException e = new RelativeNameException("This is my relative name");
        ExceptionTest.assertEquals("This is my relative name", e.getMessage());
        e = new RelativeNameException(Name.fromString("relative"));
        ExceptionTest.assertEquals("'relative' is not an absolute name", e.getMessage());
    }

    public void test_TextParseException() {
        TextParseException e = new TextParseException();
        ExceptionTest.assertNull(e.getMessage());
        e = new TextParseException("This is my message");
        ExceptionTest.assertEquals("This is my message", e.getMessage());
    }

    public void test_WireParseException() {
        WireParseException e = new WireParseException();
        ExceptionTest.assertNull(e.getMessage());
        e = new WireParseException("This is my message");
        ExceptionTest.assertEquals("This is my message", e.getMessage());
    }

    public void test_ZoneTransferException() {
        ZoneTransferException e = new ZoneTransferException();
        ExceptionTest.assertNull(e.getMessage());
        e = new ZoneTransferException("This is my message");
        ExceptionTest.assertEquals("This is my message", e.getMessage());
    }
}

