/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.UnknownHostException;
import junit.framework.TestCase;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.EmptyRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class EmptyRecordTest
extends TestCase {
    public void test_ctor() throws UnknownHostException {
        EmptyRecord ar = new EmptyRecord();
        EmptyRecordTest.assertNull(ar.getName());
        EmptyRecordTest.assertEquals(0, ar.getType());
        EmptyRecordTest.assertEquals(0, ar.getDClass());
        EmptyRecordTest.assertEquals(0L, ar.getTTL());
    }

    public void test_getObject() {
        EmptyRecord ar = new EmptyRecord();
        Record r = ar.getObject();
        EmptyRecordTest.assertTrue(r instanceof EmptyRecord);
    }

    public void test_rrFromWire() throws IOException {
        DNSInput i = new DNSInput(new byte[]{1, 2, 3, 4, 5});
        i.jump(3);
        EmptyRecord er = new EmptyRecord();
        er.rrFromWire(i);
        EmptyRecordTest.assertEquals(3, i.current());
        EmptyRecordTest.assertNull(er.getName());
        EmptyRecordTest.assertEquals(0, er.getType());
        EmptyRecordTest.assertEquals(0, er.getDClass());
        EmptyRecordTest.assertEquals(0L, er.getTTL());
    }

    public void test_rdataFromString() throws IOException {
        Tokenizer t = new Tokenizer("these are the tokens");
        EmptyRecord er = new EmptyRecord();
        er.rdataFromString(t, null);
        EmptyRecordTest.assertNull(er.getName());
        EmptyRecordTest.assertEquals(0, er.getType());
        EmptyRecordTest.assertEquals(0, er.getDClass());
        EmptyRecordTest.assertEquals(0L, er.getTTL());
        EmptyRecordTest.assertEquals("these", t.getString());
    }

    public void test_rrToString() {
        EmptyRecord er = new EmptyRecord();
        EmptyRecordTest.assertEquals("", er.rrToString());
    }

    public void test_rrToWire() {
        EmptyRecord er = new EmptyRecord();
        DNSOutput out = new DNSOutput();
        er.rrToWire(out, null, true);
        EmptyRecordTest.assertEquals(0, out.toByteArray().length);
    }
}

