/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.DSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class DSRecordTest
extends TestCase {
    public void test_ctor_0arg() {
        DSRecord dr = new DSRecord();
        DSRecordTest.assertNull(dr.getName());
        DSRecordTest.assertEquals(0, dr.getType());
        DSRecordTest.assertEquals(0, dr.getDClass());
        DSRecordTest.assertEquals(0L, dr.getTTL());
        DSRecordTest.assertEquals(0, dr.getAlgorithm());
        DSRecordTest.assertEquals(0, dr.getDigestID());
        DSRecordTest.assertNull(dr.getDigest());
        DSRecordTest.assertEquals(0, dr.getFootprint());
    }

    public void test_getObject() {
        DSRecord dr = new DSRecord();
        Record r = dr.getObject();
        DSRecordTest.assertTrue(r instanceof DSRecord);
    }

    public void test_rrFromWire() throws IOException {
        byte[] raw = new byte[]{-85, -51, -17, 1, 35, 69, 103, -119};
        DNSInput in = new DNSInput(raw);
        DSRecord dr = new DSRecord();
        dr.rrFromWire(in);
        DSRecordTest.assertEquals(43981, dr.getFootprint());
        DSRecordTest.assertEquals(239, dr.getAlgorithm());
        DSRecordTest.assertEquals(1, dr.getDigestID());
        DSRecordTest.assertTrue(Arrays.equals(new byte[]{35, 69, 103, -119}, dr.getDigest()));
    }

    public void test_rdataFromString() throws IOException {
        byte[] raw = new byte[]{-85, -51, -17, 1, 35, 69, 103, -119};
        Tokenizer t = new Tokenizer("43981 239 1 23456789AB");
        DSRecord dr = new DSRecord();
        dr.rdataFromString(t, null);
        DSRecordTest.assertEquals(43981, dr.getFootprint());
        DSRecordTest.assertEquals(239, dr.getAlgorithm());
        DSRecordTest.assertEquals(1, dr.getDigestID());
        DSRecordTest.assertTrue(Arrays.equals(new byte[]{35, 69, 103, -119, -85}, dr.getDigest()));
    }

    public void test_rrToString() throws TextParseException {
        String exp = "43981 239 1 23456789AB";
        DSRecord dr = new DSRecord(Name.fromString("The.Name."), 1, 291L, 43981, 239, 1, new byte[]{35, 69, 103, -119, -85});
        DSRecordTest.assertEquals(exp, dr.rrToString());
    }

    public void test_rrToWire() throws TextParseException {
        DSRecord dr = new DSRecord(Name.fromString("The.Name."), 1, 291L, 43981, 239, 1, new byte[]{35, 69, 103, -119, -85});
        byte[] exp = new byte[]{-85, -51, -17, 1, 35, 69, 103, -119, -85};
        DNSOutput out = new DNSOutput();
        dr.rrToWire(out, null, true);
        DSRecordTest.assertTrue(Arrays.equals(exp, out.toByteArray()));
    }

    public static Test suite() {
        TestSuite s = new TestSuite();
        s.addTestSuite(Test_Ctor_7arg.class);
        s.addTestSuite(DSRecordTest.class);
        return s;
    }

    public static class Test_Ctor_7arg
    extends TestCase {
        private Name m_n;
        private long m_ttl;
        private int m_footprint;
        private int m_algorithm;
        private int m_digestid;
        private byte[] m_digest;

        protected void setUp() throws TextParseException {
            this.m_n = Name.fromString("The.Name.");
            this.m_ttl = 43981L;
            this.m_footprint = 61185;
            this.m_algorithm = 35;
            this.m_digestid = 69;
            this.m_digest = new byte[]{103, -119, -85, -51, -17};
        }

        public void test_basic() throws TextParseException {
            DSRecord dr = new DSRecord(this.m_n, 1, this.m_ttl, this.m_footprint, this.m_algorithm, this.m_digestid, this.m_digest);
            Test_Ctor_7arg.assertEquals(this.m_n, dr.getName());
            Test_Ctor_7arg.assertEquals(1, dr.getDClass());
            Test_Ctor_7arg.assertEquals(43, dr.getType());
            Test_Ctor_7arg.assertEquals(this.m_ttl, dr.getTTL());
            Test_Ctor_7arg.assertEquals(this.m_footprint, dr.getFootprint());
            Test_Ctor_7arg.assertEquals(this.m_algorithm, dr.getAlgorithm());
            Test_Ctor_7arg.assertEquals(this.m_digestid, dr.getDigestID());
            Test_Ctor_7arg.assertTrue(Arrays.equals(this.m_digest, dr.getDigest()));
        }

        public void test_toosmall_footprint() throws TextParseException {
            try {
                new DSRecord(this.m_n, 1, this.m_ttl, -1, this.m_algorithm, this.m_digestid, this.m_digest);
                Test_Ctor_7arg.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_toobig_footprint() throws TextParseException {
            try {
                new DSRecord(this.m_n, 1, this.m_ttl, 65536, this.m_algorithm, this.m_digestid, this.m_digest);
                Test_Ctor_7arg.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_toosmall_algorithm() throws TextParseException {
            try {
                new DSRecord(this.m_n, 1, this.m_ttl, this.m_footprint, -1, this.m_digestid, this.m_digest);
                Test_Ctor_7arg.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_toobig_algorithm() throws TextParseException {
            try {
                new DSRecord(this.m_n, 1, this.m_ttl, this.m_footprint, 65536, this.m_digestid, this.m_digest);
                Test_Ctor_7arg.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_toosmall_digestid() throws TextParseException {
            try {
                new DSRecord(this.m_n, 1, this.m_ttl, this.m_footprint, this.m_algorithm, -1, this.m_digest);
                Test_Ctor_7arg.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_toobig_digestid() throws TextParseException {
            try {
                new DSRecord(this.m_n, 1, this.m_ttl, this.m_footprint, this.m_algorithm, 65536, this.m_digest);
                Test_Ctor_7arg.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_null_digest() {
            DSRecord dr = new DSRecord(this.m_n, 1, this.m_ttl, this.m_footprint, this.m_algorithm, this.m_digestid, null);
            Test_Ctor_7arg.assertEquals(this.m_n, dr.getName());
            Test_Ctor_7arg.assertEquals(1, dr.getDClass());
            Test_Ctor_7arg.assertEquals(43, dr.getType());
            Test_Ctor_7arg.assertEquals(this.m_ttl, dr.getTTL());
            Test_Ctor_7arg.assertEquals(this.m_footprint, dr.getFootprint());
            Test_Ctor_7arg.assertEquals(this.m_algorithm, dr.getAlgorithm());
            Test_Ctor_7arg.assertEquals(this.m_digestid, dr.getDigestID());
            Test_Ctor_7arg.assertNull(dr.getDigest());
        }
    }
}

