/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class DNSKEYRecordTest
extends TestCase {
    public void test_ctor_0arg() throws UnknownHostException {
        DNSKEYRecord ar = new DNSKEYRecord();
        DNSKEYRecordTest.assertNull(ar.getName());
        DNSKEYRecordTest.assertEquals(0, ar.getType());
        DNSKEYRecordTest.assertEquals(0, ar.getDClass());
        DNSKEYRecordTest.assertEquals(0L, ar.getTTL());
        DNSKEYRecordTest.assertEquals(0, ar.getAlgorithm());
        DNSKEYRecordTest.assertEquals(0, ar.getFlags());
        DNSKEYRecordTest.assertEquals(0, ar.getFootprint());
        DNSKEYRecordTest.assertEquals(0, ar.getProtocol());
        DNSKEYRecordTest.assertNull(ar.getKey());
    }

    public void test_getObject() {
        DNSKEYRecord ar = new DNSKEYRecord();
        Record r = ar.getObject();
        DNSKEYRecordTest.assertTrue(r instanceof DNSKEYRecord);
    }

    public void test_ctor_7arg() throws TextParseException {
        Name n = Name.fromString("My.Absolute.Name.");
        Name r = Name.fromString("My.Relative.Name");
        byte[] key = new byte[]{0, 1, 3, 5, 7, 9};
        DNSKEYRecord kr = new DNSKEYRecord(n, 1, 9388L, 38962, 18, 103, key);
        DNSKEYRecordTest.assertEquals(n, kr.getName());
        DNSKEYRecordTest.assertEquals(48, kr.getType());
        DNSKEYRecordTest.assertEquals(1, kr.getDClass());
        DNSKEYRecordTest.assertEquals(9388L, kr.getTTL());
        DNSKEYRecordTest.assertEquals(38962, kr.getFlags());
        DNSKEYRecordTest.assertEquals(18, kr.getProtocol());
        DNSKEYRecordTest.assertEquals(103, kr.getAlgorithm());
        DNSKEYRecordTest.assertTrue(Arrays.equals(key, kr.getKey()));
        try {
            new DNSKEYRecord(r, 1, 9388L, 38962, 18, 103, key);
            DNSKEYRecordTest.fail("RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
    }

    public void test_rdataFromString() throws IOException, TextParseException {
        DNSKEYRecord kr = new DNSKEYRecord();
        Tokenizer st = new Tokenizer("43981 129 RSASHA1 AQIDBAUGBwgJ");
        kr.rdataFromString(st, null);
        DNSKEYRecordTest.assertEquals(43981, kr.getFlags());
        DNSKEYRecordTest.assertEquals(129, kr.getProtocol());
        DNSKEYRecordTest.assertEquals(5, kr.getAlgorithm());
        DNSKEYRecordTest.assertTrue(Arrays.equals(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, kr.getKey()));
        kr = new DNSKEYRecord();
        st = new Tokenizer("4626 170 ZONE AQIDBAUGBwgJ");
        try {
            kr.rdataFromString(st, null);
            DNSKEYRecordTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }
}

