/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.jpa.EntityManagerFactoryAccessor;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerPlus;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedEntityManagerBean
extends EntityManagerFactoryAccessor
implements FactoryBean<EntityManager>,
InitializingBean {
    private Class<? extends EntityManager> entityManagerInterface;
    private EntityManager shared;

    public void setEntityManagerInterface(Class<? extends EntityManager> entityManagerInterface) {
        Assert.notNull(entityManagerInterface, "entityManagerInterface must not be null");
        Assert.isAssignable(EntityManager.class, entityManagerInterface);
        this.entityManagerInterface = entityManagerInterface;
    }

    @Override
    public final void afterPropertiesSet() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        if (emf == null) {
            throw new IllegalArgumentException("entityManagerFactory is required");
        }
        Class[] ifcs = null;
        if (emf instanceof EntityManagerFactoryInfo) {
            JpaDialect jpaDialect;
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)((Object)emf);
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = emfInfo.getEntityManagerInterface();
                if (this.entityManagerInterface == null) {
                    this.entityManagerInterface = EntityManager.class;
                }
            }
            ifcs = (jpaDialect = emfInfo.getJpaDialect()) != null && jpaDialect.supportsEntityManagerPlusOperations() ? new Class[]{this.entityManagerInterface, EntityManagerPlus.class} : new Class[]{this.entityManagerInterface};
        } else {
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = EntityManager.class;
            }
            ifcs = new Class[]{this.entityManagerInterface};
        }
        this.shared = SharedEntityManagerCreator.createSharedEntityManager(emf, this.getJpaPropertyMap(), ifcs);
    }

    @Override
    public EntityManager getObject() {
        return this.shared;
    }

    @Override
    public Class<? extends EntityManager> getObjectType() {
        return this.entityManagerInterface != null ? this.entityManagerInterface : EntityManager.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

