/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.Collection;
import java.util.Iterator;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SnmpFrameworkMIB
implements MOGroup {
    private USM usm;
    private Collection transportMappings;
    private MOScalar snmpEngineID;
    private MOScalar snmpEngineBoots;
    private MOScalar snmpEngineTime;
    private MOScalar snmpEngineMaxMessageSize;

    public SnmpFrameworkMIB(USM usm, Collection transportMappings) {
        this.usm = usm;
        this.transportMappings = transportMappings;
        this.createMOs();
    }

    private void createMOs() {
        this.snmpEngineID = new MOScalar(new OID("1.3.6.1.6.3.10.2.1.1.0"), MOAccessImpl.ACCESS_READ_ONLY, null){

            public Variable getValue() {
                return new OctetString(SnmpFrameworkMIB.this.getUSM().getLocalEngineID());
            }
        };
        this.snmpEngineBoots = new MOScalar(new OID("1.3.6.1.6.3.10.2.1.2.0"), MOAccessImpl.ACCESS_READ_ONLY, null){

            public Variable getValue() {
                return new Integer32(SnmpFrameworkMIB.this.getUSM().getEngineBoots());
            }
        };
        this.snmpEngineTime = new MOScalar(new OID("1.3.6.1.6.3.10.2.1.3.0"), MOAccessImpl.ACCESS_READ_ONLY, null){

            public Variable getValue() {
                return new Integer32(SnmpFrameworkMIB.this.getUSM().getEngineTime());
            }
        };
        Integer32 maxMsgSize = new Integer32(this.getMaxMessageSize());
        this.snmpEngineMaxMessageSize = new MOScalar(new OID("1.3.6.1.6.3.10.2.1.4.0"), MOAccessImpl.ACCESS_READ_ONLY, maxMsgSize);
    }

    private int getMaxMessageSize() {
        int totalMaxMessageSize = Integer.MAX_VALUE;
        Iterator it = this.transportMappings.iterator();
        while (it.hasNext()) {
            int maxMsgSize = ((TransportMapping)it.next()).getMaxInboundMessageSize();
            totalMaxMessageSize = Math.min(totalMaxMessageSize, maxMsgSize);
        }
        return totalMaxMessageSize;
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        if (this.usm != null) {
            server.register(this.snmpEngineID, context);
            server.register(this.snmpEngineBoots, context);
            server.register(this.snmpEngineTime, context);
        }
        server.register(this.snmpEngineMaxMessageSize, context);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmpEngineID, context);
        server.unregister(this.snmpEngineBoots, context);
        server.unregister(this.snmpEngineTime, context);
        server.unregister(this.snmpEngineMaxMessageSize, context);
    }

    public MOScalar getSnmpEngineBoots() {
        return this.snmpEngineBoots;
    }

    public MOScalar getSnmpEngineID() {
        return this.snmpEngineID;
    }

    public MOScalar getSnmpEngineMaxMessageSize() {
        return this.snmpEngineMaxMessageSize;
    }

    public MOScalar getSnmpEngineTime() {
        return this.snmpEngineTime;
    }

    public USM getUSM() {
        return this.usm;
    }
}

