/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.Vector;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOChangeEvent;
import org.snmp4j.agent.mo.MOChangeListener;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowFilter;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.RowStatusEvent;
import org.snmp4j.agent.mo.snmp.RowStatusListener;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;

public class RowStatus
extends MOMutableColumn
implements MOChangeListener,
MOTableRowListener {
    private static final LogAdapter logger = LogFactory.getLogger(RowStatus.class);
    public static final int notExistant = 0;
    public static final int active = 1;
    public static final int notInService = 2;
    public static final int notReady = 3;
    public static final int createAndGo = 4;
    public static final int createAndWait = 5;
    public static final int destroy = 6;
    private OID oid;
    private int columnIndex;
    private transient Vector rowStatusListeners;

    public RowStatus(int columnID) {
        super(columnID, 2, MOAccessImpl.ACCESS_READ_CREATE);
        this.addMOValueValidationListener(new RowStatusValidator());
    }

    public RowStatus(int columnID, MOAccess access) {
        super(columnID, 2, access);
        this.addMOValueValidationListener(new RowStatusValidator());
    }

    public void setTable(MOTable table) {
        super.setTable(table);
        this.oid = new OID(table.getOID());
        this.oid.append(this.getColumnID());
        this.columnIndex = table.getColumnIndex(this.getColumnID());
        table.addMOChangeListener(this);
        table.addMOTableRowListener(this);
    }

    public void unsetTable(MOTable table) {
        this.columnIndex = 0;
        table.removeMOChangeListener(this);
        table.removeMOTableRowListener(this);
    }

    protected boolean isReady(MOTableRow row, int rowStatusColumn) {
        return this.isReady(row, rowStatusColumn, null);
    }

    protected boolean isReady(MOTableRow row, int rowStatusColumn, MOTableRow changeSet) {
        MOColumn[] columns = this.getTable().getColumns();
        for (int i = 0; i < columns.length; ++i) {
            MOMutableColumn mcol;
            if (i == rowStatusColumn || !(columns[i] instanceof MOMutableColumn) || !(mcol = (MOMutableColumn)columns[i]).isMandatory() || row.getValue(i) != null || changeSet != null && changeSet.getValue(i) != null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Row " + row + " is not ready because column " + i + " is not set properly");
            }
            return false;
        }
        return true;
    }

    public void prepare(SubRequest subRequest, MOTableRow row, MOTableRow changeSet, int column) {
        super.prepare(subRequest, row, null, column);
        if (subRequest.getStatus().getErrorStatus() == 0) {
            int newValue = ((Integer32)subRequest.getVariableBinding().getVariable()).getValue();
            int oldValue = 0;
            if (row.getValue(column) != null) {
                oldValue = ((Integer32)row.getValue(column)).getValue();
            }
            if (oldValue == 0 || oldValue == 3 || oldValue == 4) {
                switch (newValue) {
                    case 1: 
                    case 2: 
                    case 4: {
                        if (this.isReady(row, column, changeSet)) break;
                        if (logger.isDebugEnabled()) {
                            logger.debug(this.toString() + ": Row '" + row.getIndex() + " is not ready! Cannot change status to from " + oldValue + " to " + newValue);
                        }
                        subRequest.getStatus().setErrorStatus(12);
                    }
                }
            }
            RowStatusEvent rowStatusEvent = new RowStatusEvent(this, this.getTable(), row, changeSet, oldValue, newValue, true, subRequest);
            this.fireRowStatusChanged(rowStatusEvent);
            if (rowStatusEvent.getDenyReason() != 0) {
                subRequest.getStatus().setErrorStatus(rowStatusEvent.getDenyReason());
            }
        }
    }

    public void commit(SubRequest subRequest, MOTableRow row, MOTableRow changeSet, int column) {
        int oldValue = ((Integer32)row.getValue(column)).getValue();
        super.commit(subRequest, row, null, column);
        if (!subRequest.hasError()) {
            int newValue = ((Integer32)row.getValue(column)).getValue();
            this.assignNewValue(subRequest, row, column, newValue);
            RowStatusEvent rowStatusEvent = new RowStatusEvent(this, this.getTable(), row, changeSet, oldValue, newValue, false, subRequest);
            this.fireRowStatusChanged(rowStatusEvent);
        }
    }

    protected void assignNewValue(SubRequest subRequest, MOTableRow row, int column, int newValue) {
        switch (newValue) {
            case 6: {
                MOTableRow deleted = this.getTable().removeRow(row.getIndex());
                if (deleted == null) {
                    subRequest.getStatus().setErrorStatus(14);
                    break;
                }
                subRequest.setUndoValue(deleted);
                break;
            }
            case 5: {
                if (this.isReady(row, column)) {
                    ((Integer32)row.getValue(column)).setValue(2);
                    break;
                }
                ((Integer32)row.getValue(column)).setValue(3);
                break;
            }
            case 4: {
                ((Integer32)row.getValue(column)).setValue(1);
            }
        }
    }

    public void undo(SubRequest subRequest, MOTableRow row, int column) {
        super.undo(subRequest, row, column);
        if (!subRequest.hasError()) {
            int newStatus = ((Integer32)row.getValue(column)).getValue();
            switch (newStatus) {
                case 6: {
                    MOTableRow oldRow = (MOTableRow)subRequest.getUndoValue();
                    Integer32 oldValue = (Integer32)oldRow.getValue(column);
                    boolean added = this.getTable().addRow((MOTableRow)subRequest.getUndoValue());
                    if (!added) {
                        subRequest.getStatus().setErrorStatus(15);
                        break;
                    }
                    RowStatusEvent rowStatusEvent = new RowStatusEvent(this, this.getTable(), oldRow, row, oldValue.getValue(), 6);
                    this.fireRowStatusChanged(rowStatusEvent);
                    break;
                }
                case 4: 
                case 5: {
                    MOTableRow deleted = this.getTable().removeRow(row.getIndex());
                    if (deleted == null) {
                        subRequest.getStatus().setErrorStatus(15);
                        break;
                    }
                    RowStatusEvent rowStatusEvent = new RowStatusEvent(this, this.getTable(), row, deleted, 0, newStatus);
                    this.fireRowStatusChanged(rowStatusEvent);
                    break;
                }
            }
        }
    }

    public void beforePrepareMOChange(MOChangeEvent changeEvent) {
        if (changeEvent.getOID().startsWith(this.oid)) {
            int currentValue = 0;
            if (changeEvent.getOldValue() instanceof Integer32) {
                currentValue = ((Integer32)changeEvent.getOldValue()).getValue();
            }
            int newValue = ((Integer32)changeEvent.getNewValue()).getValue();
            boolean ok = false;
            switch (currentValue) {
                case 0: {
                    ok = newValue == 4 || newValue == 5 || newValue == 6;
                    break;
                }
                case 3: {
                    ok = newValue == 6 || newValue == 1 || newValue == 2;
                    break;
                }
                case 1: {
                    ok = newValue == 1 || newValue == 2 || newValue == 6;
                    break;
                }
                case 2: {
                    ok = newValue == 2 || newValue == 1 || newValue == 6;
                    break;
                }
                case 5: {
                    ok = newValue == 5;
                    break;
                }
                case 4: {
                    ok = newValue == 4;
                    break;
                }
                case 6: {
                    boolean bl = ok = newValue == 6;
                }
            }
            if (!ok) {
                changeEvent.setDenyReason(10);
            }
        }
    }

    public void beforeMOChange(MOChangeEvent changeEvent) {
    }

    public void afterMOChange(MOChangeEvent changeEvent) {
    }

    public void afterPrepareMOChange(MOChangeEvent changeEvent) {
    }

    public synchronized void addRowStatusListener(RowStatusListener l) {
        if (this.rowStatusListeners == null) {
            this.rowStatusListeners = new Vector(2);
        }
        this.rowStatusListeners.add(l);
    }

    public synchronized void removeRowStatusListener(RowStatusListener l) {
        if (this.rowStatusListeners != null) {
            this.rowStatusListeners.remove(l);
        }
    }

    protected void fireRowStatusChanged(RowStatusEvent event) {
        if (this.rowStatusListeners != null) {
            Vector listeners = this.rowStatusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((RowStatusListener)listeners.elementAt(i)).rowStatusChanged(event);
            }
        }
    }

    public static boolean isRowActive(MOTableRow row, int rowStatusColumnIndex) {
        Integer32 rowStatus = (Integer32)row.getValue(rowStatusColumnIndex);
        if (rowStatus != null) {
            return rowStatus.getValue() == 1;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rowChanged(MOTableRowEvent event) {
        switch (event.getType()) {
            case 1: {
                MOTableRow row = event.getRow();
                int myIndex = this.getTable().getColumnIndex(this.getColumnID());
                if (row.getValue(myIndex) != null) return;
                event.setVetoStatus(18);
                return;
            }
            case 0: {
                int rowStatus = this.getCurrentRowStatus(event);
                switch (rowStatus) {
                    case 1: {
                        for (int i = 0; i < this.getTable().getColumnCount(); ++i) {
                            MOColumn col;
                            if (event.getPreparedChanges().getValue(i) == null || !((col = this.getTable().getColumn(i)) instanceof MOMutableColumn) || ((MOMutableColumn)col).isMutableInService()) continue;
                            event.setVetoStatus(12);
                            event.setVetoColumn(i);
                        }
                        break;
                    }
                }
            }
            case 4: {
                int rowStatus = this.getCurrentRowStatus(event);
                switch (rowStatus) {
                    case 3: {
                        if (!(event.getRow() instanceof MOMutableTableRow) || !this.isReady(event.getRow(), this.columnIndex)) return;
                        ((MOMutableTableRow)event.getRow()).setValue(this.columnIndex, new Integer32(2));
                    }
                }
            }
        }
    }

    private int getCurrentRowStatus(MOTableRowEvent event) {
        Integer32 rowStatusVariable = (Integer32)event.getRow().getValue(this.columnIndex);
        int rowStatus = 0;
        if (rowStatusVariable != null) {
            rowStatus = rowStatusVariable.getValue();
        }
        return rowStatus;
    }

    public boolean isVolatile(MOTableRow row, int column) {
        int rowStatus;
        Integer32 value = (Integer32)row.getValue(column);
        return value != null && (rowStatus = value.getValue()) != 1 && rowStatus != 2;
    }

    public void get(SubRequest subRequest, MOTableRow row, int column) {
        Integer32 rowStatus = (Integer32)this.getValue(row, column);
        if (rowStatus != null && rowStatus.getValue() == 3 && this.isReady(row, column)) {
            rowStatus.setValue(2);
        }
        super.get(subRequest, row, column);
    }

    static class RowStatusValidator
    implements MOValueValidationListener {
        RowStatusValidator() {
        }

        public void validate(MOValueValidationEvent event) {
            int v;
            if (!(event.getNewValue() instanceof Integer32)) {
                event.setValidationStatus(7);
            }
            if ((v = ((Integer32)event.getNewValue()).getValue()) < 1 || v > 6 || v == 3) {
                event.setValidationStatus(10);
            }
        }
    }

    public static class ActiveRowsFilter
    implements MOTableRowFilter {
        private int rowStatusColumnIndex;

        public ActiveRowsFilter(int rowStatusColumnIndex) {
            this.rowStatusColumnIndex = rowStatusColumnIndex;
        }

        public boolean passesFilter(MOTableRow row) {
            Integer32 rs = (Integer32)row.getValue(this.rowStatusColumnIndex);
            if (rs == null) {
                logger.warn("RowStatus column " + this.rowStatusColumnIndex + " does not exists although it is filter criteria");
                return false;
            }
            return rs.getValue() == 1;
        }
    }
}

