/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.agent.ProxyForwardRequest;
import org.snmp4j.agent.ProxyForwarder;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SnmpProxyMIB;
import org.snmp4j.agent.mo.snmp.SnmpTagList;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;

public class ProxyForwarderImpl
implements ProxyForwarder {
    private static final LogAdapter logger = LogFactory.getLogger(ProxyForwarderImpl.class);
    private Session session;
    private SnmpProxyMIB proxyMIB;
    private SnmpTargetMIB targetMIB;
    private transient Vector counterListeners;

    public ProxyForwarderImpl(Session session, SnmpProxyMIB proxyMIB, SnmpTargetMIB targetMIB) {
        this.session = session;
        this.proxyMIB = proxyMIB;
        this.targetMIB = targetMIB;
    }

    public boolean forward(ProxyForwardRequest request) {
        int pduType = request.getCommandEvent().getPDU().getType();
        if (SnmpRequest.getViewType(pduType) == 0) {
            return this.multipleForward(request);
        }
        ResponseEvent resp = this.singleForward(request);
        if (resp != null && resp.getResponse() != null) {
            PDU respPDU = resp.getResponse();
            PDU translatedResponse = DefaultPDUFactory.createPDU(request.getCommandEvent().getSecurityModel());
            if (!translatedResponse.getClass().equals(respPDU.getClass())) {
                translatedResponse.setType(respPDU.getType());
                translatedResponse.addAll(respPDU.toArray());
                translatedResponse.setErrorIndex(respPDU.getErrorIndex());
                translatedResponse.setErrorStatus(respPDU.getErrorStatus());
            } else {
                translatedResponse = respPDU;
            }
            if (translatedResponse.getType() == -94) {
                translatedResponse.setRequestID(request.getCommandEvent().getPDU().getRequestID());
                if (translatedResponse instanceof ScopedPDU && request.getCommandEvent().getPDU() instanceof ScopedPDU) {
                    ScopedPDU scopedPDUReq = (ScopedPDU)request.getCommandEvent().getPDU();
                    ScopedPDU scopedPDUResp = (ScopedPDU)translatedResponse;
                    scopedPDUResp.setContextEngineID(scopedPDUReq.getContextEngineID());
                    scopedPDUResp.setContextName(scopedPDUReq.getContextName());
                }
            }
            request.setResponsePDU(translatedResponse);
            return true;
        }
        return false;
    }

    protected List getMatches(ProxyForwardRequest request) {
        List matches = this.proxyMIB.getProxyRows(request.getProxyType(), request.getContextEngineID(), request.getContext());
        Iterator it = matches.iterator();
        while (it.hasNext()) {
            SnmpProxyMIB.SnmpProxyRow possibleMatch = (SnmpProxyMIB.SnmpProxyRow)((MOTableRow)it.next());
            OctetString paramIn = possibleMatch.getSnmpProxyTargetParamsIn();
            if (logger.isDebugEnabled()) {
                logger.debug("Checking possible match for in parameter: " + paramIn);
            }
            if (this.matchParameters(request, paramIn)) continue;
            it.remove();
        }
        return matches;
    }

    protected boolean matchParameters(ProxyForwardRequest request, OctetString paramIn) {
        MOTableRow param2Match = this.targetMIB.getTargetParamsRow(paramIn, true);
        if (param2Match != null) {
            int mpModel = param2Match.getValue(0).toInt();
            int secModel = param2Match.getValue(1).toInt();
            int secLevel = param2Match.getValue(3).toInt();
            OctetString secName = (OctetString)param2Match.getValue(2);
            if (logger.isDebugEnabled()) {
                logger.debug("Matching request " + request + "  with mpModel=" + mpModel + ", secModel=" + secModel + ", secLevel=" + secLevel + ", secName=" + secName);
            }
            if (mpModel == request.getCommandEvent().getMessageProcessingModel() && secName.equals(request.getSecurityName()) && (secModel == 0 || secModel == request.getCommandEvent().getSecurityModel()) && secLevel == request.getCommandEvent().getSecurityLevel()) {
                return true;
            }
        }
        return false;
    }

    protected ResponseEvent singleForward(ProxyForwardRequest request) {
        List matches = this.getMatches(request);
        if (matches == null || matches.isEmpty()) {
            if (logger.isInfoEnabled()) {
                logger.info("No matching proxy entry found for contextEngineID=" + request.getContextEngineID() + ", context=" + request.getContext() + " and request=" + request);
            }
            return null;
        }
        OctetString outParam = (OctetString)((MOTableRow)matches.get(0)).getValue(4);
        Target target = this.targetMIB.getTarget(outParam, request.getContextEngineID(), request.getContext());
        if (target == null) {
            if (logger.isInfoEnabled()) {
                logger.info("No matching target with name '" + outParam + "'");
            }
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Forwarding proxy request " + request + " to " + target);
        }
        PDU reqPDU = request.getCommandEvent().getPDU();
        PDU pdu = DefaultPDUFactory.createPDU(target, reqPDU.getType());
        this.setScope(request, pdu);
        try {
            this.proxyForwardTranslation(request, reqPDU, pdu);
            ResponseEvent response = null;
            do {
                response = this.session.send(pdu, target);
                if (!logger.isInfoEnabled()) continue;
                logger.info("Received proxy response from " + response.getPeerAddress() + " is " + response.getResponse());
            } while (this.proxyBackwardTranslation(reqPDU, pdu, response));
            return response;
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                ex.printStackTrace();
            }
            logger.error("Failed to send proxy request to " + target + " because: " + ex.getMessage());
            this.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpProxyDrops));
            if (SNMP4JSettings.isFowardRuntimeExceptions()) {
                throw new RuntimeException(ex);
            }
            return null;
        }
    }

    protected boolean proxyBackwardTranslation(PDU reqPDU, PDU pdu, ResponseEvent response) {
        if (response.getResponse() == null) {
            return false;
        }
        PDU resp = response.getResponse();
        if (resp.getErrorStatus() == 1 && reqPDU.getType() != -91) {
            response.getResponse().clear();
            response.getResponse().setErrorStatus(0);
            response.getResponse().setErrorIndex(0);
            return false;
        }
        if (resp.getErrorStatus() == 1 && reqPDU.getType() == -91 && pdu.getType() == -91) {
            if (pdu.size() == 1) {
                response.getResponse().clear();
                response.getResponse().setErrorStatus(0);
                response.getResponse().setErrorIndex(0);
                return false;
            }
            while (pdu.size() > 1) {
                pdu.trim();
            }
            pdu.setType(-95);
            return true;
        }
        if (reqPDU instanceof PDUv1 && !(response.getResponse() instanceof PDUv1)) {
            boolean resendNeeded = false;
            for (int i = 0; i < resp.size(); ++i) {
                VariableBinding vb = resp.get(i);
                if (!(vb.getVariable() instanceof Counter64)) continue;
                OID nextOID = new OID(vb.getOid());
                if (nextOID.last() < 65535) {
                    nextOID.set(nextOID.size() - 1, 65535);
                } else {
                    nextOID.set(nextOID.size() - 1, -1);
                }
                pdu.get(i).setOid(vb.getOid());
                resendNeeded = true;
            }
            if (resendNeeded && reqPDU.getType() != -95) {
                throw new IllegalArgumentException("GET response with Counter64 cannot be proxied");
            }
            return true;
        }
        return false;
    }

    protected void proxyForwardTranslation(ProxyForwardRequest request, PDU source, PDU target) throws IllegalArgumentException {
        target.clear();
        target.setType(source.getType());
        if (!(target instanceof PDUv1) && !(source instanceof PDUv1)) {
            target.setMaxRepetitions(source.getMaxRepetitions());
            target.setNonRepeaters(source.getNonRepeaters());
        }
        if (source.getType() == -92 && source instanceof PDUv1 && !(target instanceof PDUv1)) {
            PDUv1 sourceV1 = (PDUv1)source;
            target.setType(-89);
            target.add(new VariableBinding(SnmpConstants.sysUpTime, new TimeTicks(sourceV1.getTimestamp())));
            target.add(new VariableBinding(SnmpConstants.snmpTrapOID, SnmpConstants.getTrapOID(sourceV1.getEnterprise(), sourceV1.getGenericTrap(), sourceV1.getSpecificTrap())));
            target.addAll(source.toArray());
            target.add(new VariableBinding(SnmpConstants.snmpTrapAddress, sourceV1.getAgentAddress()));
            target.add(new VariableBinding(SnmpConstants.snmpTrapEnterprise, sourceV1.getEnterprise()));
            OctetString community = new OctetString(request.getCommandEvent().getSecurityName());
            target.add(new VariableBinding(SnmpConstants.snmpTrapCommunity, community));
        } else if ((source.getType() == -89 || source.getType() == -90) && target instanceof PDUv1) {
            PDUv1 targetV1 = (PDUv1)target;
            target.setType(-92);
            if (source.size() < 2 || !(source.get(0).getVariable() instanceof TimeTicks) || !(source.get(1).getVariable() instanceof OID)) {
                throw new IllegalArgumentException("Proxy source invalid notification PDU: " + source);
            }
            TimeTicks sysUpTime = (TimeTicks)source.get(0).getVariable();
            OID trapOID = (OID)source.get(1).getVariable();
            int genericID = SnmpConstants.getGenericTrapID(trapOID);
            if (genericID < 0) {
                OID enterprise;
                targetV1.setGenericTrap(6);
                if (trapOID.size() > 2 && trapOID.get(trapOID.size() - 2) == 0) {
                    targetV1.setSpecificTrap(trapOID.get(trapOID.size() - 1));
                    enterprise = new OID(trapOID);
                    enterprise.trim(2);
                    targetV1.setEnterprise(enterprise);
                } else if (trapOID.size() > 1) {
                    targetV1.setSpecificTrap(trapOID.get(trapOID.size() - 1));
                    enterprise = new OID(trapOID);
                    enterprise.trim(1);
                    targetV1.setEnterprise(enterprise);
                }
            } else {
                targetV1.setGenericTrap(genericID);
                targetV1.setSpecificTrap(0);
            }
            target.addAll(source.toArray());
            if (request.getCommandEvent().getPeerAddress() instanceof IpAddress) {
                InetAddress agentAddress = ((IpAddress)request.getCommandEvent().getPeerAddress()).getInetAddress();
                targetV1.setAgentAddress(new IpAddress(agentAddress));
            } else {
                targetV1.setAgentAddress(new IpAddress("0.0.0.0"));
            }
            targetV1.setTimestamp(sysUpTime.getValue());
        } else {
            target.addAll(source.toArray());
        }
    }

    protected boolean multipleForward(ProxyForwardRequest request) {
        List matches = this.getMatches(request);
        boolean allOK = true;
        Iterator it = matches.iterator();
        while (it.hasNext()) {
            SnmpProxyMIB.SnmpProxyRow item = (SnmpProxyMIB.SnmpProxyRow)it.next();
            OctetString outParam = item.getSnmpProxyMultipleTargetOut();
            Set tags = SnmpTagList.getTags(outParam);
            if (logger.isDebugEnabled()) {
                logger.debug("Proxy multiple targets out with tags " + tags);
            }
            Iterator tagit = tags.iterator();
            while (tagit.hasNext()) {
                OctetString tag = (OctetString)tagit.next();
                Collection targets = this.targetMIB.getTargetAddrRowsForTag(tag);
                Iterator tit = targets.iterator();
                while (tit.hasNext()) {
                    SnmpTargetMIB.SnmpTargetAddrEntryRow targetRow = (SnmpTargetMIB.SnmpTargetAddrEntryRow)tit.next();
                    Target target = targetRow.getTarget(request.getContextEngineID(), request.getContext());
                    if (target != null) {
                        try {
                            PDU reqPDU = request.getCommandEvent().getPDU();
                            PDU pdu = DefaultPDUFactory.createPDU(target, reqPDU.getType());
                            this.setScope(request, pdu);
                            this.proxyForwardTranslation(request, reqPDU, pdu);
                            ResponseEvent resp = this.session.send(pdu, target);
                            if (logger.isInfoEnabled()) {
                                logger.info("Forwarded " + request.getCommandEvent() + " to target " + target + " with response " + resp);
                            }
                            if (request.getCommandEvent().getPDU().getType() != -90 || resp.getResponse() != null && resp.getResponse().getType() != -88 && resp.getResponse().getErrorStatus() == 0) continue;
                            allOK = false;
                        }
                        catch (IOException ex) {
                            if (logger.isDebugEnabled()) {
                                ex.printStackTrace();
                            }
                            logger.error("Failed to forward request " + request + " to target " + target);
                            allOK = false;
                        }
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Parameters for target " + targetRow + " not found");
                }
            }
        }
        return allOK;
    }

    private void setScope(ProxyForwardRequest request, PDU pdu) {
        if (pdu instanceof ScopedPDU) {
            ScopedPDU scopedPDU = (ScopedPDU)pdu;
            scopedPDU.setContextEngineID(request.getContextEngineID());
            scopedPDU.setContextName(request.getContext());
        }
    }

    public synchronized void addCounterListener(CounterListener l) {
        if (this.counterListeners == null) {
            this.counterListeners = new Vector(2);
        }
        this.counterListeners.add(l);
    }

    public synchronized void removeCounterListener(CounterListener l) {
        if (this.counterListeners != null) {
            this.counterListeners.remove(l);
        }
    }

    protected void fireIncrementCounter(CounterEvent event) {
        if (this.counterListeners != null) {
            Vector listeners = this.counterListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((CounterListener)listeners.elementAt(i)).incrementCounter(event);
            }
        }
    }

    public void setSession(Session snmpSession) {
        this.session = snmpSession;
    }
}

