/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import org.snmp4j.agent.mo.MOTableIndexValidator;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public class MOTableIndex
implements MOTableIndexValidator {
    public static final int MAX_INDEX_OID_LENGTH = 127;
    private MOTableSubIndex[] subindexes;
    private boolean impliedLength = false;
    private MOTableIndexValidator validator;

    public MOTableIndex(MOTableSubIndex[] subIndexes) {
        if (subIndexes == null || subIndexes.length < 1) {
            throw new IllegalArgumentException("Index definition must have at least one sub-index");
        }
        this.subindexes = subIndexes;
    }

    public MOTableIndex(MOTableSubIndex[] subIndexes, boolean impliedLength) {
        this(subIndexes);
        this.impliedLength = impliedLength;
    }

    public MOTableIndex(MOTableSubIndex[] subIndexes, boolean impliedLength, MOTableIndexValidator validator) {
        this(subIndexes, impliedLength);
        this.validator = validator;
    }

    public MOTableSubIndex getIndex(int index) {
        return this.subindexes[index];
    }

    public boolean isImpliedLength() {
        return this.impliedLength;
    }

    public MOTableIndexValidator getValidator() {
        return this.validator;
    }

    public void setValidator(MOTableIndexValidator validator) {
        this.validator = validator;
    }

    public int size() {
        return this.subindexes.length;
    }

    private static boolean checkIndexBytes(OID index, long start, long end) {
        if (start < 0L || start > 127L || end < 0L || end > 127L) {
            return false;
        }
        for (int i = (int)start; i < index.size() && (long)i < end; ++i) {
            if (index.getUnsigned(i) <= 255L) continue;
            return false;
        }
        return true;
    }

    private static boolean isStringSyntax(int smiSyntax) {
        switch (smiSyntax) {
            case 4: 
            case 64: 
            case 68: {
                return true;
            }
        }
        return false;
    }

    public boolean isValidIndex(OID index) {
        int i;
        if (index.size() > 127) {
            return false;
        }
        int l = 0;
        for (i = 0; i < this.size() && l < index.size(); ++i) {
            MOTableSubIndex subIndex = this.getIndex(i);
            if (i + 1 == this.size() && this.isImpliedLength()) {
                int type = subIndex.getSmiSyntax();
                switch (type) {
                    case 4: 
                    case 64: {
                        if (MOTableIndex.checkIndexBytes(index, l, index.size())) break;
                        return false;
                    }
                }
                return true;
            }
            if (subIndex.getMinLength() != subIndex.getMaxLength()) {
                if (index.size() < index.get(l) + 1) {
                    return false;
                }
                if (index.get(l) < subIndex.getMinLength() || index.get(l) > subIndex.getMaxLength()) {
                    return false;
                }
                if (MOTableIndex.isStringSyntax(subIndex.getSmiSyntax()) && !MOTableIndex.checkIndexBytes(index, l, (long)l + index.getUnsigned(l) + 1L)) {
                    return false;
                }
                l = (int)((long)l + (index.getUnsigned(l) + 1L));
                continue;
            }
            if (MOTableIndex.isStringSyntax(subIndex.getSmiSyntax()) && !MOTableIndex.checkIndexBytes(index, l, l + subIndex.getMaxLength())) {
                return false;
            }
            l += subIndex.getMaxLength();
        }
        return index.size() == l && i >= this.size() && (this.validator == null || this.validator.isValidIndex(index));
    }

    private static Variable getIndexVariable(MOTableSubIndex subIndexDef, OID subIndex, boolean impliedLength) {
        switch (subIndexDef.getSmiSyntax()) {
            case 4: {
                if (impliedLength || subIndexDef.getMinLength() == subIndexDef.getMaxLength()) {
                    OctetString s = new OctetString(subIndex.toByteArray());
                    return s;
                }
                OID suffix = new OID(subIndex.getValue(), 1, subIndex.size() - 1);
                return new OctetString(suffix.toByteArray());
            }
            case 6: {
                if (impliedLength || subIndexDef.getMinLength() == subIndexDef.getMaxLength()) {
                    return subIndex;
                }
                OID suffix = new OID(subIndex.getValue(), 1, subIndex.size() - 1);
                return suffix;
            }
            case 66: {
                return new Gauge32((long)subIndex.get(subIndex.size() - 1));
            }
            case 67: {
                return new TimeTicks((long)subIndex.get(subIndex.size() - 1));
            }
            case 2: {
                return new Integer32(subIndex.get(subIndex.size() - 1));
            }
            case 64: {
                return new IpAddress(subIndex.toString());
            }
        }
        return null;
    }

    public OID[] getIndexOIDs(OID index) {
        OID[] r = new OID[this.size()];
        int[] ind = index.getValue();
        int pos = 0;
        for (int i = 0; i < this.subindexes.length; ++i) {
            if (i + 1 == this.size() && this.isImpliedLength()) {
                r[i] = new OID(ind, pos, index.size() - pos);
                break;
            }
            r[i] = this.subindexes[i].getMinLength() != this.subindexes[i].getMaxLength() ? new OID(ind, pos, index.get(pos) + 1) : new OID(index.getValue(), pos, this.subindexes[i].getMaxLength());
            pos += r[i].size();
        }
        return r;
    }

    public Variable[] getIndexValues(OID index) {
        OID[] oids = this.getIndexOIDs(index);
        Variable[] values = new Variable[oids.length];
        for (int i = 0; i < oids.length; ++i) {
            boolean implied = this.isImpliedLength() && i + 1 == this.size();
            values[i] = MOTableIndex.getIndexVariable(this.subindexes[i], oids[i], implied);
        }
        return values;
    }

    public OID getIndexOID(Variable[] indexValues) {
        if (indexValues.length != this.size()) {
            throw new IllegalArgumentException("Index value length != size()");
        }
        OID index = new OID();
        for (int i = 0; i < indexValues.length; ++i) {
            if (indexValues[i].getSyntax() != this.subindexes[i].getSmiSyntax()) {
                throw new IllegalArgumentException("Syntax of index value #" + i + " = " + indexValues[i].getSyntaxString() + " does not match index definition " + AbstractVariable.getSyntaxString(this.subindexes[i].getSmiSyntax()));
            }
            index.append(indexValues[i].toSubIndex(i + 1 == indexValues.length && this.impliedLength));
        }
        return index;
    }
}

