/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.snmp4j.agent.cfg.EngineBootsProvider;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;

public class EngineBootsCounterFile
implements EngineBootsProvider {
    private static final LogAdapter logger = LogFactory.getLogger(EngineBootsCounterFile.class);
    private File bootCounterFile;
    private int boots = -1;

    public EngineBootsCounterFile(File bootCounterFile) {
        this.bootCounterFile = bootCounterFile;
    }

    public int updateEngineBoots() {
        this.boots = this.getLastEngineBoots();
        ++this.boots;
        if (this.boots <= 0) {
            this.boots = 1;
        }
        this.setEngineBoots(this.boots);
        return this.boots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLastEngineBoots() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.bootCounterFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            int boots = ois.readInt();
            if (logger.isInfoEnabled()) {
                logger.info("Engine boots is: " + boots);
            }
            int n = boots;
            return n;
        }
        catch (FileNotFoundException ex) {
            logger.warn("Could not find boot counter file: " + this.bootCounterFile);
        }
        catch (IOException iox) {
            if (logger.isDebugEnabled()) {
                iox.printStackTrace();
            }
            logger.error("Failed to read boot counter: " + iox.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex1) {
                    logger.warn(ex1);
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setEngineBoots(int engineBoots) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.bootCounterFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeInt(engineBoots);
            oos.close();
            if (logger.isInfoEnabled()) {
                logger.info("Wrote boot counter: " + engineBoots);
            }
        }
        catch (FileNotFoundException fnfex) {
            logger.error("Boot counter configuration file not found: " + fnfex.getMessage());
        }
        catch (IOException iox) {
            logger.error("Failed to write boot counter: " + iox.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex1) {
                    logger.warn(ex1);
                }
            }
        }
    }

    public int getEngineBoots() {
        if (this.boots < 0) {
            this.boots = this.getLastEngineBoots();
        }
        return this.boots;
    }
}

